/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.rendering;

import com.android.ide.common.repository.GradleVersion;
import com.android.tools.idea.gradle.project.GradleProjectInfo;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.gradle.project.sync.hyperlink.FixAndroidGradlePluginVersionHyperlink;
import com.android.tools.idea.rendering.HtmlLinkManager;
import com.android.tools.idea.rendering.RenderErrorContributor;
import com.android.tools.idea.rendering.RenderLogger;
import com.android.tools.idea.rendering.RenderResult;
import com.android.tools.idea.rendering.errors.ui.RenderErrorModel;
import com.android.utils.HtmlBuilder;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.project.Project;
import java.util.Collection;
import java.util.Map;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GradleRenderErrorContributor
extends RenderErrorContributor {
    public GradleRenderErrorContributor(@NotNull RenderResult result, @Nullable DataContext dataContext) {
        if (result == null) {
            GradleRenderErrorContributor.$$$reportNull$$$0(0);
        }
        super(result, dataContext);
    }

    @Override
    public Collection<RenderErrorModel.Issue> reportIssues() {
        RenderResult result = this.getResult();
        RenderLogger logger = result.getLogger();
        AndroidFacet facet = AndroidFacet.getInstance(result.getModule());
        this.reportIssue170841(logger, facet);
        return this.getIssues();
    }

    private void reportIssue170841(RenderLogger logger, final AndroidFacet facet) {
        Map<String, Throwable> brokenClasses = logger.getBrokenClasses();
        if (brokenClasses == null || brokenClasses.isEmpty() || facet == null) {
            return;
        }
        AndroidModuleModel model = AndroidModuleModel.get(facet);
        if (model == null || !model.getFeatures().isLayoutRenderingIssuePresent()) {
            return;
        }
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                FixAndroidGradlePluginVersionHyperlink quickFix = new FixAndroidGradlePluginVersionHyperlink(GradleVersion.parse((String)"2.3.0"), null);
                quickFix.executeIfClicked(facet.getModule().getProject(), new HyperlinkEvent(this, HyperlinkEvent.EventType.ACTIVATED, null, quickFix.getUrl()));
            }
        };
        HtmlBuilder builder = new HtmlBuilder();
        HtmlLinkManager linkManager = logger.getLinkManager();
        builder.add("Tip: Either ").addLink("update the Gradle plugin build version to 1.2.3", linkManager.createRunnableLink(runnable)).add(" or later, or downgrade to version 1.1.3, or as a workaround, ");
        builder.beginList().listItem().addLink("", "Build the project", ", then", linkManager.createBuildProjectUrl()).listItem().addLink("", "Gradle Sync the project", ", then", linkManager.createSyncProjectUrl()).listItem().addLink("Manually ", "refresh the layout", " (or restart the IDE)", linkManager.createRefreshRenderUrl()).endList();
        builder.newline();
        GradleVersion modelVersion = model.getModelVersion();
        this.addIssue().setSeverity(HighlightSeverity.ERROR).setSummary("Using an obsolete version of the Gradle plugin (" + modelVersion + "); this can lead to layouts not rendering correctly.").setHtmlContent(builder).build();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/android/tools/idea/gradle/rendering/GradleRenderErrorContributor", "<init>"));
    }

    public static class GradleProvider
    extends RenderErrorContributor.Provider {
        @Override
        public boolean isApplicable(Project project) {
            return GradleProjectInfo.getInstance(project).isBuildWithGradle();
        }

        @Override
        public RenderErrorContributor getContributor(@NotNull RenderResult result, @Nullable DataContext dataContext) {
            if (result == null) {
                GradleProvider.$$$reportNull$$$0(0);
            }
            return new GradleRenderErrorContributor(result, dataContext);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/android/tools/idea/gradle/rendering/GradleRenderErrorContributor$GradleProvider", "getContributor"));
        }
    }
}

