/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.model.repositories.search;

import com.android.ide.common.repository.GradleVersion;
import com.android.tools.idea.gradle.structure.model.repositories.search.ArtifactRepository;
import com.android.tools.idea.gradle.structure.model.repositories.search.FoundArtifact;
import com.android.tools.idea.gradle.structure.model.repositories.search.SearchRequest;
import com.android.tools.idea.gradle.structure.model.repositories.search.SearchResult;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.io.HttpRequests;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class JCenterRepository
extends ArtifactRepository {
    @Override
    @NotNull
    public String getName() {
        if ("JCenter" == null) {
            JCenterRepository.$$$reportNull$$$0(0);
        }
        return "JCenter";
    }

    @Override
    public boolean isRemote() {
        return true;
    }

    @Override
    @NotNull
    protected SearchResult doSearch(@NotNull SearchRequest request) throws Exception {
        if (request == null) {
            JCenterRepository.$$$reportNull$$$0(1);
        }
        String url = JCenterRepository.createRequestUrl(request);
        SearchResult searchResult = (SearchResult)HttpRequests.request((String)url).accept("application/json").connect(request1 -> this.parse(request1.getReader()));
        if (searchResult == null) {
            JCenterRepository.$$$reportNull$$$0(2);
        }
        return searchResult;
    }

    @VisibleForTesting
    @NotNull
    static String createRequestUrl(SearchRequest request) {
        StringBuilder buffer = new StringBuilder();
        buffer.append("https://api.bintray.com/search/packages/maven?");
        String groupId = request.getGroupId();
        if (StringUtil.isNotEmpty((String)groupId)) {
            buffer.append("g=").append(groupId).append("&");
        }
        buffer.append("a=").append(request.getArtifactName()).append("&subject=bintray&repo=jcenter");
        String string = buffer.toString();
        if (string == null) {
            JCenterRepository.$$$reportNull$$$0(3);
        }
        return string;
    }

    SearchResult parse(@NotNull Reader response) {
        if (response == null) {
            JCenterRepository.$$$reportNull$$$0(4);
        }
        JsonParser parser = new JsonParser();
        JsonArray array = parser.parse(response).getAsJsonArray();
        int totalFound = array.size();
        ArrayList artifacts = Lists.newArrayListWithExpectedSize((int)totalFound);
        for (int i = 0; i < totalFound; ++i) {
            JsonObject root = array.get(i).getAsJsonObject();
            String name = root.getAsJsonPrimitive("name").getAsString();
            ArrayList availableVersions = Lists.newArrayList();
            JsonArray versions = root.getAsJsonArray("versions");
            versions.forEach(element -> {
                String version = element.getAsString();
                availableVersions.add(GradleVersion.parse((String)version));
            });
            List coordinate = Splitter.on((String)":").splitToList((CharSequence)name);
            assert (coordinate.size() == 2);
            artifacts.add(new FoundArtifact(this.getName(), (String)coordinate.get(0), (String)coordinate.get(1), availableVersions));
        }
        return new SearchResult(this.getName(), artifacts, totalFound);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        return o != null && this.getClass() == o.getClass();
    }

    public int hashCode() {
        return 1;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/structure/model/repositories/search/JCenterRepository";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "response";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/structure/model/repositories/search/JCenterRepository";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "doSearch";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createRequestUrl";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "doSearch";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "parse";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

