/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.lint;

import com.android.tools.idea.lint.DefaultLintQuickFix;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlTag;
import org.jetbrains.android.inspections.lint.AndroidQuickfixContexts;
import org.jetbrains.annotations.NotNull;

class RenameXmlTagQuickFix
extends DefaultLintQuickFix {
    private final String myNewName;

    RenameXmlTagQuickFix(@NotNull String newName) {
        if (newName == null) {
            RenameXmlTagQuickFix.$$$reportNull$$$0(0);
        }
        super("Use " + newName);
        this.myNewName = newName;
    }

    @Override
    public void apply(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.Context context) {
        XmlTag currentTag;
        if (startElement == null) {
            RenameXmlTagQuickFix.$$$reportNull$$$0(1);
        }
        if (endElement == null) {
            RenameXmlTagQuickFix.$$$reportNull$$$0(2);
        }
        if (context == null) {
            RenameXmlTagQuickFix.$$$reportNull$$$0(3);
        }
        if ((currentTag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)startElement, XmlTag.class, (boolean)false)) == null) {
            return;
        }
        XmlTag parentTag = currentTag.getParentTag();
        if (parentTag == null) {
            return;
        }
        XmlTag newTag = parentTag.createChildTag(this.myNewName, null, currentTag.isEmpty() ? null : currentTag.getValue().getText(), true);
        for (XmlAttribute attr : currentTag.getAttributes()) {
            newTag.setAttribute(attr.getLocalName(), attr.getNamespace(), attr.getValue());
        }
        currentTag.replace((PsiElement)newTag);
    }

    @Override
    public boolean isApplicable(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.ContextType contextType) {
        if (startElement == null) {
            RenameXmlTagQuickFix.$$$reportNull$$$0(4);
        }
        if (endElement == null) {
            RenameXmlTagQuickFix.$$$reportNull$$$0(5);
        }
        if (contextType == null) {
            RenameXmlTagQuickFix.$$$reportNull$$$0(6);
        }
        return startElement.isValid() && endElement.isValid() && PsiTreeUtil.getParentOfType((PsiElement)startElement, XmlTag.class) != null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startElement";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "endElement";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextType";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/lint/RenameXmlTagQuickFix";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "apply";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "isApplicable";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

