/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.navigator.nodes;

import com.android.tools.idea.navigator.AndroidProjectTreeBuilder;
import com.android.tools.idea.navigator.AndroidProjectViewPane;
import com.android.tools.idea.navigator.nodes.AndroidPsiDirectoryNode;
import com.android.tools.idea.navigator.nodes.AndroidPsiFileNode;
import com.android.tools.idea.navigator.nodes.DirectoryGroupNode;
import com.google.common.collect.Lists;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ProjectViewNode;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.nodes.ProjectViewDirectoryHelper;
import com.intellij.ide.projectView.impl.nodes.PsiDirectoryNode;
import com.intellij.ide.projectView.impl.nodes.PsiFileNode;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Queryable;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.ui.SimpleTextAttributes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidSourceType;
import org.jetbrains.android.facet.IdeaSourceProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidSourceTypeNode
extends ProjectViewNode<AndroidFacet>
implements DirectoryGroupNode {
    @NotNull
    private final AndroidSourceType mySourceType;
    @NotNull
    private final Set<VirtualFile> mySourceRoots;
    @NotNull
    protected final AndroidProjectViewPane myProjectViewPane;

    public AndroidSourceTypeNode(@NotNull Project project, @NotNull AndroidFacet facet, @NotNull ViewSettings viewSettings, @NotNull AndroidSourceType sourceType, @NotNull Set<VirtualFile> sources, @NotNull AndroidProjectViewPane projectViewPane) {
        if (project == null) {
            AndroidSourceTypeNode.$$$reportNull$$$0(0);
        }
        if (facet == null) {
            AndroidSourceTypeNode.$$$reportNull$$$0(1);
        }
        if (viewSettings == null) {
            AndroidSourceTypeNode.$$$reportNull$$$0(2);
        }
        if (sourceType == null) {
            AndroidSourceTypeNode.$$$reportNull$$$0(3);
        }
        if (sources == null) {
            AndroidSourceTypeNode.$$$reportNull$$$0(4);
        }
        if (projectViewPane == null) {
            AndroidSourceTypeNode.$$$reportNull$$$0(5);
        }
        super(project, (Object)facet, viewSettings);
        this.mySourceType = sourceType;
        this.mySourceRoots = sources;
        this.myProjectViewPane = projectViewPane;
    }

    @NotNull
    public Collection<? extends AbstractTreeNode> getChildren() {
        ArrayList children = Lists.newArrayList();
        ProjectViewDirectoryHelper projectViewDirectoryHelper = ProjectViewDirectoryHelper.getInstance((Project)this.myProject);
        AndroidProjectTreeBuilder treeBuilder = (AndroidProjectTreeBuilder)this.myProjectViewPane.getTreeBuilder();
        for (PsiDirectory directory : this.getSourceDirectories()) {
            Collection directoryChildren = projectViewDirectoryHelper.getDirectoryChildren(directory, this.getSettings(), true);
            children.addAll(this.annotateWithSourceProvider(directoryChildren));
            treeBuilder.createMapping(directory.getVirtualFile(), (AbstractTreeNode)this);
        }
        ArrayList arrayList = children;
        if (arrayList == null) {
            AndroidSourceTypeNode.$$$reportNull$$$0(6);
        }
        return arrayList;
    }

    private Collection<AbstractTreeNode> annotateWithSourceProvider(Collection<AbstractTreeNode> directoryChildren) {
        ArrayList children = Lists.newArrayListWithExpectedSize((int)directoryChildren.size());
        for (AbstractTreeNode child : directoryChildren) {
            if (child instanceof PsiDirectoryNode) {
                PsiDirectory directory = (PsiDirectory)((PsiDirectoryNode)child).getValue();
                children.add(new AndroidPsiDirectoryNode(this.myProject, directory, this.getSettings(), this.findSourceProvider(directory.getVirtualFile())));
                continue;
            }
            if (child instanceof PsiFileNode) {
                PsiFile file = (PsiFile)((PsiFileNode)child).getValue();
                children.add(new AndroidPsiFileNode(this.myProject, file, this.getSettings(), this.findSourceProvider(file.getVirtualFile())));
                continue;
            }
            children.add(child);
        }
        return children;
    }

    @Nullable
    private IdeaSourceProvider findSourceProvider(VirtualFile virtualFile) {
        for (IdeaSourceProvider provider : AndroidProjectViewPane.getSourceProviders((AndroidFacet)((Object)this.getValue()))) {
            if (!provider.containsFile(virtualFile)) continue;
            return provider;
        }
        return null;
    }

    protected List<PsiDirectory> getSourceDirectories() {
        PsiManager psiManager = PsiManager.getInstance((Project)this.myProject);
        ArrayList psiDirectories = Lists.newArrayListWithExpectedSize((int)this.mySourceRoots.size());
        for (VirtualFile root : this.mySourceRoots) {
            PsiDirectory directory;
            if (!root.isValid() || (directory = psiManager.findDirectory(root)) == null) continue;
            psiDirectories.add(directory);
        }
        return psiDirectories;
    }

    protected void update(PresentationData presentation) {
        presentation.addText(this.mySourceType.getName(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
        Icon icon = this.mySourceType.getIcon();
        if (icon != null) {
            presentation.setIcon(icon);
        }
        presentation.setPresentableText(this.mySourceType.getName());
    }

    @Nullable
    public String toTestString(@Nullable Queryable.PrintInfo printInfo) {
        return this.mySourceType.getName();
    }

    public boolean contains(@NotNull VirtualFile file) {
        if (file == null) {
            AndroidSourceTypeNode.$$$reportNull$$$0(7);
        }
        for (VirtualFile root : this.mySourceRoots) {
            if (!VfsUtilCore.isAncestor((VirtualFile)root, (VirtualFile)file, (boolean)false)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public Comparable getSortKey() {
        return this.mySourceType;
    }

    @Nullable
    public Comparable getTypeSortKey() {
        return this.mySourceType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AndroidSourceTypeNode that = (AndroidSourceTypeNode)o;
        if (this.mySourceType != that.mySourceType) {
            return false;
        }
        return this.mySourceRoots.equals(that.mySourceRoots);
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.mySourceType.hashCode();
        for (VirtualFile root : this.mySourceRoots) {
            result = 31 * result + root.hashCode();
        }
        return result;
    }

    @Override
    @NotNull
    public PsiDirectory[] getDirectories() {
        List<PsiDirectory> folders = this.getSourceDirectories();
        PsiDirectory[] psiDirectoryArray = folders.toArray(new PsiDirectory[folders.size()]);
        if (psiDirectoryArray == null) {
            AndroidSourceTypeNode.$$$reportNull$$$0(8);
        }
        return psiDirectoryArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "viewSettings";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceType";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sources";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectViewPane";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/navigator/nodes/AndroidSourceTypeNode";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/navigator/nodes/AndroidSourceTypeNode";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getDirectories";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: 
            case 8: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "contains";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

