/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.rendering;

import com.android.tools.idea.databinding.DataBindingUtil;
import com.google.common.collect.Lists;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlTag;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AttributeSnapshot {
    @Nullable
    public String namespace;
    @Nullable
    public String prefix;
    @NotNull
    public String name;
    @Nullable
    public String value;

    AttributeSnapshot(@Nullable String namespace, @Nullable String prefix, @NotNull String name, @Nullable String value) {
        if (name == null) {
            AttributeSnapshot.$$$reportNull$$$0(0);
        }
        this.namespace = namespace;
        this.prefix = prefix == null || prefix.isEmpty() ? null : prefix;
        this.name = name;
        this.value = value;
    }

    @Nullable
    public static AttributeSnapshot createAttributeSnapshot(@NotNull XmlAttribute psiAttribute) {
        if (psiAttribute == null) {
            AttributeSnapshot.$$$reportNull$$$0(1);
        }
        String localName = psiAttribute.getLocalName();
        String namespace = psiAttribute.getNamespace();
        String prefix = psiAttribute.getNamespacePrefix();
        String value = psiAttribute.getValue();
        if (value != null && DataBindingUtil.isBindingExpression(value) && (value = DataBindingUtil.getBindingExprDefault(psiAttribute)) == null) {
            return null;
        }
        return new AttributeSnapshot(namespace, prefix, localName, value);
    }

    @NotNull
    public static List<AttributeSnapshot> createAttributesForTag(@NotNull XmlTag tag) {
        if (tag == null) {
            AttributeSnapshot.$$$reportNull$$$0(2);
        }
        XmlAttribute[] psiAttributes = tag.getAttributes();
        ArrayList attributes = Lists.newArrayListWithExpectedSize((int)psiAttributes.length);
        for (XmlAttribute psiAttribute : psiAttributes) {
            AttributeSnapshot attribute = AttributeSnapshot.createAttributeSnapshot(psiAttribute);
            if (attribute == null) continue;
            attributes.add(attribute);
        }
        ArrayList arrayList = attributes;
        if (arrayList == null) {
            AttributeSnapshot.$$$reportNull$$$0(3);
        }
        return arrayList;
    }

    public String toString() {
        return "AttributeSnapshot{" + this.name + "=\"" + this.value + "\"}";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiAttribute";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/rendering/AttributeSnapshot";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/rendering/AttributeSnapshot";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createAttributesForTag";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createAttributeSnapshot";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createAttributesForTag";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

