/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run;

import com.android.ddmlib.Client;
import com.android.ddmlib.IDevice;
import com.android.sdklib.AndroidVersion;
import com.android.tools.idea.run.AndroidProcessHandler;
import com.intellij.execution.ExecutionManager;
import com.intellij.execution.Executor;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidSessionInfo {
    public static final Key<AndroidSessionInfo> KEY = new Key("KEY");
    public static final Key<Client> ANDROID_DEBUG_CLIENT = new Key("ANDROID_DEBUG_CLIENT");
    public static final Key<AndroidVersion> ANDROID_DEVICE_API_LEVEL = new Key("ANDROID_DEVICE_API_LEVEL");
    @NotNull
    private final ProcessHandler myProcessHandler;
    private final RunContentDescriptor myDescriptor;
    private final String myExecutorId;
    private final int myRunConfigId;
    private final boolean myInstantRun;

    public AndroidSessionInfo(@NotNull ProcessHandler processHandler, @NotNull RunContentDescriptor descriptor, int runConfigId, @NotNull String executorId, boolean instantRunEnabled) {
        if (processHandler == null) {
            AndroidSessionInfo.$$$reportNull$$$0(0);
        }
        if (descriptor == null) {
            AndroidSessionInfo.$$$reportNull$$$0(1);
        }
        if (executorId == null) {
            AndroidSessionInfo.$$$reportNull$$$0(2);
        }
        this.myProcessHandler = processHandler;
        this.myDescriptor = descriptor;
        this.myRunConfigId = runConfigId;
        this.myExecutorId = executorId;
        this.myInstantRun = instantRunEnabled;
    }

    @NotNull
    public ProcessHandler getProcessHandler() {
        ProcessHandler processHandler = this.myProcessHandler;
        if (processHandler == null) {
            AndroidSessionInfo.$$$reportNull$$$0(3);
        }
        return processHandler;
    }

    @NotNull
    public RunContentDescriptor getDescriptor() {
        RunContentDescriptor runContentDescriptor = this.myDescriptor;
        if (runContentDescriptor == null) {
            AndroidSessionInfo.$$$reportNull$$$0(4);
        }
        return runContentDescriptor;
    }

    @NotNull
    public String getExecutorId() {
        String string = this.myExecutorId;
        if (string == null) {
            AndroidSessionInfo.$$$reportNull$$$0(5);
        }
        return string;
    }

    public boolean isInstantRun() {
        return this.myInstantRun;
    }

    @Nullable
    public List<IDevice> getDevices() {
        if (this.myProcessHandler instanceof AndroidProcessHandler) {
            return ((AndroidProcessHandler)this.myProcessHandler).getDevices();
        }
        Client client = (Client)this.myProcessHandler.getUserData(ANDROID_DEBUG_CLIENT);
        if (client != null) {
            return Collections.singletonList(client.getDevice());
        }
        return null;
    }

    public int getRunConfigurationId() {
        return this.myRunConfigId;
    }

    @Nullable
    public static AndroidSessionInfo findOldSession(@NotNull Project project, @Nullable Executor executor, int currentID) {
        if (project == null) {
            AndroidSessionInfo.$$$reportNull$$$0(6);
        }
        for (ProcessHandler handler : ExecutionManager.getInstance((Project)project).getRunningProcesses()) {
            AndroidSessionInfo info;
            if (handler.isProcessTerminated() || handler.isProcessTerminating() || (info = (AndroidSessionInfo)handler.getUserData(KEY)) == null || currentID != info.getRunConfigurationId() || executor != null && !executor.getId().equals(info.getExecutorId())) continue;
            return info;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processHandler";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executorId";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/run/AndroidSessionInfo";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/run/AndroidSessionInfo";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getProcessHandler";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescriptor";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getExecutorId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findOldSession";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

