/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.model;

import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.uibuilder.model.NlComponent;
import com.android.tools.idea.uibuilder.model.SelectionModel;
import com.android.tools.idea.uibuilder.surface.ScreenView;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Coordinates {
    public static final float DEFAULT_DENSITY = 160.0f;

    public static int getSwingX(@NotNull ScreenView view, int androidX) {
        if (view == null) {
            Coordinates.$$$reportNull$$$0(0);
        }
        return view.getX() + (int)(view.getScale() * (double)androidX);
    }

    public static int getSwingY(@NotNull ScreenView view, int androidY) {
        if (view == null) {
            Coordinates.$$$reportNull$$$0(1);
        }
        return view.getY() + (int)(view.getScale() * (double)androidY);
    }

    public static int getSwingDimension(@NotNull ScreenView view, int androidDimension) {
        if (view == null) {
            Coordinates.$$$reportNull$$$0(2);
        }
        return (int)(view.getScale() * (double)androidDimension);
    }

    public static int dpToPx(@NotNull ScreenView view, int androidDp) {
        if (view == null) {
            Coordinates.$$$reportNull$$$0(3);
        }
        Configuration configuration = view.getConfiguration();
        int dpiValue = configuration.getDensity().getDpiValue();
        return Math.round((float)androidDp * ((float)dpiValue / 160.0f));
    }

    public static int dpToPx(@NotNull ScreenView view, float androidDp) {
        if (view == null) {
            Coordinates.$$$reportNull$$$0(4);
        }
        Configuration configuration = view.getConfiguration();
        int dpiValue = configuration.getDensity().getDpiValue();
        return Math.round(androidDp * ((float)dpiValue / 160.0f));
    }

    public static int pxToDp(@NotNull ScreenView view, int androidPx) {
        if (view == null) {
            Coordinates.$$$reportNull$$$0(5);
        }
        Configuration configuration = view.getConfiguration();
        int dpiValue = configuration.getDensity().getDpiValue();
        return Math.round((float)androidPx * (160.0f / (float)dpiValue));
    }

    public static int getSwingXDip(@NotNull ScreenView view, int androidDpX) {
        if (view == null) {
            Coordinates.$$$reportNull$$$0(6);
        }
        return Coordinates.getSwingX(view, Coordinates.dpToPx(view, androidDpX));
    }

    public static int getSwingYDip(@NotNull ScreenView view, int androidDpY) {
        if (view == null) {
            Coordinates.$$$reportNull$$$0(7);
        }
        return Coordinates.getSwingY(view, Coordinates.dpToPx(view, androidDpY));
    }

    public static int getSwingDimensionDip(@NotNull ScreenView view, int androidDpDimension) {
        if (view == null) {
            Coordinates.$$$reportNull$$$0(8);
        }
        return Coordinates.getSwingDimension(view, Coordinates.dpToPx(view, androidDpDimension));
    }

    public static int getAndroidX(@NotNull ScreenView view, int swingX) {
        if (view == null) {
            Coordinates.$$$reportNull$$$0(9);
        }
        return (int)((double)(swingX - view.getX()) / view.getScale());
    }

    public static int getAndroidXDip(@NotNull ScreenView view, int swingX) {
        if (view == null) {
            Coordinates.$$$reportNull$$$0(10);
        }
        return Coordinates.pxToDp(view, Coordinates.getAndroidX(view, swingX));
    }

    public static int getAndroidY(@NotNull ScreenView view, int swingY) {
        if (view == null) {
            Coordinates.$$$reportNull$$$0(11);
        }
        return (int)((double)(swingY - view.getY()) / view.getScale());
    }

    public static int getAndroidYDip(@NotNull ScreenView view, int swingY) {
        if (view == null) {
            Coordinates.$$$reportNull$$$0(12);
        }
        return Coordinates.pxToDp(view, Coordinates.getAndroidY(view, swingY));
    }

    public static int getAndroidDimension(@NotNull ScreenView view, int swingDimension) {
        if (view == null) {
            Coordinates.$$$reportNull$$$0(13);
        }
        return (int)((double)swingDimension / view.getScale());
    }

    public static int getAndroidDimensionDip(@NotNull ScreenView view, int swingDimension) {
        if (view == null) {
            Coordinates.$$$reportNull$$$0(14);
        }
        return Coordinates.pxToDp(view, Coordinates.getSwingDimension(view, swingDimension));
    }

    @Nullable
    public static NlComponent findComponent(@NotNull ScreenView view, int swingX, int swingY) {
        if (view == null) {
            Coordinates.$$$reportNull$$$0(15);
        }
        return view.getModel().findLeafAt(Coordinates.getAndroidX(view, swingX), Coordinates.getAndroidY(view, swingY), false);
    }

    @Nullable
    public static NlComponent findImmediateComponent(@NotNull ScreenView view, int swingX, int swingY) {
        if (view == null) {
            Coordinates.$$$reportNull$$$0(16);
        }
        if (view.getModel().getComponents().isEmpty()) {
            return null;
        }
        SelectionModel selectionModel = view.getSelectionModel();
        NlComponent start = null;
        start = selectionModel.isEmpty() ? view.getModel().getComponents().get(0).getRoot() : selectionModel.getPrimary();
        NlComponent found = start.findImmediateLeafAt(Coordinates.getAndroidX(view, swingX), Coordinates.getAndroidY(view, swingY));
        if (found == null) {
            found = Coordinates.findComponent(view, swingX, swingY);
        }
        return found;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "view";
        objectArray2[1] = "com/android/tools/idea/uibuilder/model/Coordinates";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getSwingX";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getSwingY";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getSwingDimension";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "dpToPx";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "pxToDp";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "getSwingXDip";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "getSwingYDip";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "getSwingDimensionDip";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "getAndroidX";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "getAndroidXDip";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "getAndroidY";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "getAndroidYDip";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "getAndroidDimension";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "getAndroidDimensionDip";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "findComponent";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[2] = "findImmediateComponent";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

