/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.palette;

import com.android.tools.adtui.splitter.ComponentsSplitter;
import com.android.tools.adtui.splitter.SplitterUtil;
import com.android.tools.adtui.workbench.ToolContent;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.uibuilder.model.DnDTransferComponent;
import com.android.tools.idea.uibuilder.model.DnDTransferItem;
import com.android.tools.idea.uibuilder.model.ItemTransferable;
import com.android.tools.idea.uibuilder.model.NlLayoutType;
import com.android.tools.idea.uibuilder.palette.DependencyManager;
import com.android.tools.idea.uibuilder.palette.IconPreviewFactory;
import com.android.tools.idea.uibuilder.palette.NlPaletteModel;
import com.android.tools.idea.uibuilder.palette.NlPaletteTreeGrid;
import com.android.tools.idea.uibuilder.palette.NlPreviewImagePanel;
import com.android.tools.idea.uibuilder.palette.NlPreviewPanel;
import com.android.tools.idea.uibuilder.palette.Palette;
import com.android.tools.idea.uibuilder.palette.PaletteMode;
import com.android.tools.idea.uibuilder.palette.TogglePaletteModeAction;
import com.android.tools.idea.uibuilder.surface.DesignSurface;
import com.intellij.ide.CopyProvider;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.datatransfer.Transferable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NlPalettePanel
extends JPanel
implements Disposable,
DataProvider,
ToolContent<DesignSurface> {
    private final Project myProject;
    private final NlPreviewPanel myPreviewPane;
    private final CopyProvider myCopyProvider;
    private final NlPaletteTreeGrid myPalettePanel;
    private final DependencyManager myDependencyManager;
    private final CopyPasteManager myCopyPasteManager;
    private NlLayoutType myLayoutType;
    private Runnable myCloseAutoHideCallback;

    public NlPalettePanel(@NotNull Project project, @Nullable DesignSurface designSurface) {
        if (project == null) {
            NlPalettePanel.$$$reportNull$$$0(0);
        }
        this(project, designSurface, CopyPasteManager.getInstance());
    }

    NlPalettePanel(@NotNull Project project, @Nullable DesignSurface designSurface, @NotNull CopyPasteManager copyPasteManager) {
        if (project == null) {
            NlPalettePanel.$$$reportNull$$$0(1);
        }
        if (copyPasteManager == null) {
            NlPalettePanel.$$$reportNull$$$0(2);
        }
        this.myProject = project;
        this.myCopyPasteManager = copyPasteManager;
        IconPreviewFactory iconPreviewFactory = new IconPreviewFactory();
        Disposer.register((Disposable)this, (Disposable)iconPreviewFactory);
        this.myDependencyManager = new DependencyManager(project, this, this);
        this.myPalettePanel = new NlPaletteTreeGrid(project, this.myDependencyManager, this::closeAutoHideToolWindow, designSurface, iconPreviewFactory);
        this.myPreviewPane = new NlPreviewPanel(new NlPreviewImagePanel(iconPreviewFactory, this.myDependencyManager, this::closeAutoHideToolWindow));
        this.myCopyProvider = new CopyProviderImpl();
        this.myPalettePanel.setSelectionListener(this.myPreviewPane);
        this.myLayoutType = NlLayoutType.UNKNOWN;
        ComponentsSplitter splitter = new ComponentsSplitter(true, true);
        splitter.setInnerComponent((JComponent)this.myPalettePanel);
        splitter.setLastComponent((JComponent)this.myPreviewPane);
        splitter.setHonorComponentsMinimumSize(true);
        splitter.setLastSize(JBUI.scale((int)140));
        SplitterUtil.setMinimumHeight((JComponent)this.myPalettePanel, (int)20);
        SplitterUtil.setMinimumHeight((JComponent)this.myPreviewPane, (int)40);
        Disposer.register((Disposable)this, (Disposable)splitter);
        Disposer.register((Disposable)this, (Disposable)this.myPalettePanel);
        Disposer.register((Disposable)this, (Disposable)this.myPreviewPane);
        this.setLayout(new BorderLayout());
        this.add((Component)splitter, "Center");
        this.setToolContext(designSurface);
    }

    @NotNull
    public JComponent getComponent() {
        NlPalettePanel nlPalettePanel = this;
        if (nlPalettePanel == null) {
            NlPalettePanel.$$$reportNull$$$0(3);
        }
        return nlPalettePanel;
    }

    @NotNull
    public JComponent getFocusedComponent() {
        NlPaletteTreeGrid nlPaletteTreeGrid = this.myPalettePanel;
        if (nlPaletteTreeGrid == null) {
            NlPalettePanel.$$$reportNull$$$0(4);
        }
        return nlPaletteTreeGrid;
    }

    @Override
    public void requestFocus() {
        this.myPalettePanel.requestFocus();
    }

    @NotNull
    public NlPaletteTreeGrid getTreeGrid() {
        NlPaletteTreeGrid nlPaletteTreeGrid = this.myPalettePanel;
        if (nlPaletteTreeGrid == null) {
            NlPalettePanel.$$$reportNull$$$0(5);
        }
        return nlPaletteTreeGrid;
    }

    @NotNull
    public List<AnAction> getGearActions() {
        ArrayList<AnAction> actions = new ArrayList<AnAction>(3);
        actions.add((AnAction)new TogglePaletteModeAction(this, PaletteMode.ICON_AND_NAME));
        actions.add((AnAction)new TogglePaletteModeAction(this, PaletteMode.LARGE_ICONS));
        actions.add((AnAction)new TogglePaletteModeAction(this, PaletteMode.SMALL_ICONS));
        ArrayList<AnAction> arrayList = actions;
        if (arrayList == null) {
            NlPalettePanel.$$$reportNull$$$0(6);
        }
        return arrayList;
    }

    @NotNull
    public List<AnAction> getAdditionalActions() {
        List<AnAction> list = Collections.emptyList();
        if (list == null) {
            NlPalettePanel.$$$reportNull$$$0(7);
        }
        return list;
    }

    public void registerCloseAutoHideWindow(@NotNull Runnable runnable) {
        if (runnable == null) {
            NlPalettePanel.$$$reportNull$$$0(8);
        }
        this.myCloseAutoHideCallback = runnable;
    }

    public boolean supportsFiltering() {
        return true;
    }

    public void setFilter(@NotNull String filter) {
        if (filter == null) {
            NlPalettePanel.$$$reportNull$$$0(9);
        }
        this.myPalettePanel.setFilter(filter);
    }

    public void setToolContext(@Nullable DesignSurface designSurface) {
        this.myPreviewPane.setDesignSurface(designSurface);
        Module module = NlPalettePanel.getModule(designSurface);
        if (designSurface != null && module != null && this.myLayoutType != designSurface.getLayoutType()) {
            this.myLayoutType = designSurface.getLayoutType();
            NlPaletteModel model = NlPaletteModel.get(this.myProject);
            Palette palette = model.getPalette(this.myLayoutType);
            this.myPalettePanel.populateUiModel(palette, designSurface);
            this.myDependencyManager.setPalette(palette, module);
            this.repaint();
        }
    }

    private void closeAutoHideToolWindow() {
        if (this.myCloseAutoHideCallback != null) {
            this.myCloseAutoHideCallback.run();
        }
    }

    @Nullable
    private static Module getModule(@Nullable DesignSurface designSurface) {
        Configuration configuration = designSurface != null && designSurface.getLayoutType().isSupportedByDesigner() ? designSurface.getConfiguration() : null;
        return configuration != null ? configuration.getModule() : null;
    }

    @NotNull
    public PaletteMode getMode() {
        PaletteMode paletteMode = this.myPalettePanel.getMode();
        if (paletteMode == null) {
            NlPalettePanel.$$$reportNull$$$0(10);
        }
        return paletteMode;
    }

    public void setMode(@NotNull PaletteMode mode) {
        if (mode == null) {
            NlPalettePanel.$$$reportNull$$$0(11);
        }
        this.myPalettePanel.setMode(mode);
    }

    public void dispose() {
    }

    @Nullable
    public Object getData(@NonNls String dataId) {
        return PlatformDataKeys.COPY_PROVIDER.is(dataId) ? this.myCopyProvider : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "copyPasteManager";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/uibuilder/palette/NlPalettePanel";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/uibuilder/palette/NlPalettePanel";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFocusedComponent";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getTreeGrid";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getGearActions";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getAdditionalActions";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getMode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 10: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "registerCloseAutoHideWindow";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "setFilter";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "setMode";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class CopyProviderImpl
    implements CopyProvider {
        private CopyProviderImpl() {
        }

        public void performCopy(@NotNull DataContext dataContext) {
            Palette.Item item;
            if (dataContext == null) {
                CopyProviderImpl.$$$reportNull$$$0(0);
            }
            if ((item = NlPalettePanel.this.myPalettePanel.getSelectedItem()) != null && !NlPalettePanel.this.myDependencyManager.needsLibraryLoad(item)) {
                DnDTransferComponent component = new DnDTransferComponent(item.getTagName(), item.getXml(), 0, 0);
                NlPalettePanel.this.myCopyPasteManager.setContents((Transferable)new ItemTransferable(new DnDTransferItem(component)));
            }
        }

        public boolean isCopyEnabled(@NotNull DataContext dataContext) {
            Palette.Item item;
            if (dataContext == null) {
                CopyProviderImpl.$$$reportNull$$$0(1);
            }
            return (item = NlPalettePanel.this.myPalettePanel.getSelectedItem()) != null && !NlPalettePanel.this.myDependencyManager.needsLibraryLoad(item);
        }

        public boolean isCopyVisible(@NotNull DataContext dataContext) {
            if (dataContext == null) {
                CopyProviderImpl.$$$reportNull$$$0(2);
            }
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "dataContext";
            objectArray2[1] = "com/android/tools/idea/uibuilder/palette/NlPalettePanel$CopyProviderImpl";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "performCopy";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isCopyEnabled";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isCopyVisible";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

