/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.structure;

import com.android.tools.idea.uibuilder.api.InsertType;
import com.android.tools.idea.uibuilder.api.ViewGroupHandler;
import com.android.tools.idea.uibuilder.model.DnDTransferItem;
import com.android.tools.idea.uibuilder.model.ModelListener;
import com.android.tools.idea.uibuilder.model.NlComponent;
import com.android.tools.idea.uibuilder.model.NlModel;
import com.android.tools.idea.uibuilder.model.SelectionListener;
import com.android.tools.idea.uibuilder.model.SelectionModel;
import com.android.tools.idea.uibuilder.structure.NlComponentTreeModel;
import com.android.tools.idea.uibuilder.structure.NlDropListener;
import com.android.tools.idea.uibuilder.structure.StructureTreeDecorator;
import com.android.tools.idea.uibuilder.structure.TreeTransferHandler;
import com.android.tools.idea.uibuilder.surface.DesignSurface;
import com.android.tools.idea.uibuilder.surface.DesignSurfaceListener;
import com.android.tools.idea.uibuilder.surface.ScreenView;
import com.google.common.collect.Sets;
import com.intellij.ide.CopyProvider;
import com.intellij.ide.CutProvider;
import com.intellij.ide.DeleteProvider;
import com.intellij.ide.PasteProvider;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.ColoredTextContainer;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.Alarm;
import com.intellij.util.IJSwingUtilities;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeUtil;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NlComponentTree
extends Tree
implements DesignSurfaceListener,
ModelListener,
SelectionListener,
Disposable,
DataProvider,
DeleteProvider,
CutProvider,
CopyProvider,
PasteProvider {
    private static final Insets INSETS = new JBInsets(0, 6, 0, 6);
    private final AtomicBoolean mySelectionIsUpdating;
    private final MergingUpdateQueue myUpdateQueue;
    private final CopyPasteManager myCopyPasteManager;
    private ScreenView myScreenView;
    private NlModel myModel;
    private TreePath myInsertionPath;
    private InsertionPoint myInsertionPoint;
    private boolean mySkipWait;

    public NlComponentTree(@Nullable DesignSurface designSurface) {
        this(designSurface, CopyPasteManager.getInstance());
    }

    NlComponentTree(@Nullable DesignSurface designSurface, @NotNull CopyPasteManager copyPasteManager) {
        if (copyPasteManager == null) {
            NlComponentTree.$$$reportNull$$$0(0);
        }
        this.mySelectionIsUpdating = new AtomicBoolean(false);
        this.myCopyPasteManager = copyPasteManager;
        this.myUpdateQueue = new MergingUpdateQueue("android.layout.structure-pane", 250, true, null, null, null, Alarm.ThreadToUse.SWING_THREAD);
        this.setModel(new NlComponentTreeModel());
        this.getSelectionModel().setSelectionMode(4);
        this.setBorder(new EmptyBorder(INSETS));
        this.setRootVisible(true);
        this.setShowsRootHandles(false);
        this.setToggleClickCount(2);
        ToolTipManager.sharedInstance().registerComponent((JComponent)((Object)this));
        TreeUtil.installActions((JTree)((Object)this));
        this.createCellRenderer();
        this.addTreeSelectionListener(new StructurePaneSelectionListener());
        new StructureSpeedSearch(this);
        this.enableDnD();
        this.setDesignSurface(designSurface);
        this.addMouseListener(new StructurePaneMouseListener());
    }

    private void enableDnD() {
        if (!ApplicationManager.getApplication().isHeadlessEnvironment()) {
            this.setDragEnabled(true);
            this.setTransferHandler(new TreeTransferHandler());
            this.setDropTarget(new DropTarget((Component)((Object)this), new NlDropListener(this)));
        }
    }

    public void setDesignSurface(@Nullable DesignSurface designSurface) {
        this.setScreenView(designSurface != null ? designSurface.getCurrentScreenView() : null);
    }

    private void setScreenView(@Nullable ScreenView screenView) {
        this.myScreenView = screenView;
        this.setModel(screenView != null ? screenView.getModel() : null);
    }

    @Nullable
    public ScreenView getScreenView() {
        return this.myScreenView;
    }

    private void setModel(@Nullable NlModel model) {
        if (this.myModel != null) {
            this.myModel.removeListener(this);
            this.myModel.getSelectionModel().removeListener(this);
        }
        this.myModel = model;
        if (this.myModel != null) {
            this.myModel.addListener(this);
            this.myModel.getSelectionModel().addListener(this);
        }
        this.updateHierarchy();
    }

    @Nullable
    public NlModel getDesignerModel() {
        return this.myModel;
    }

    public void dispose() {
        if (this.myModel != null) {
            this.myModel.removeListener(this);
            this.myModel.getSelectionModel().removeListener(this);
            this.myModel = null;
        }
        Disposer.dispose((Disposable)this.myUpdateQueue);
    }

    private void createCellRenderer() {
        ColoredTreeCellRenderer renderer = new ColoredTreeCellRenderer(){

            public void customizeCellRenderer(@NotNull JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                if (tree == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (value instanceof NlComponent) {
                    StructureTreeDecorator.decorate((ColoredTextContainer)this, (NlComponent)value);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/android/tools/idea/uibuilder/structure/NlComponentTree$1", "customizeCellRenderer"));
            }
        };
        renderer.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.setCellRenderer((TreeCellRenderer)renderer);
    }

    private void invalidateUI() {
        IJSwingUtilities.updateComponentTreeUI((Component)((Object)this));
    }

    private void updateHierarchy() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.setPaintBusy(true);
        this.myUpdateQueue.queue(new Update("updateComponentStructure"){

            public void run() {
                try {
                    if (NlComponentTree.this.myModel == null) {
                        return;
                    }
                    NlComponentTree.this.mySelectionIsUpdating.set(true);
                    Collection components = NlComponentTree.this.getCollapsedComponents();
                    NlComponentTree.this.setModel(new NlComponentTreeModel(NlComponentTree.this.myModel));
                    NlComponentTree.this.collapseComponents(components);
                    NlComponentTree.this.invalidateUI();
                }
                finally {
                    NlComponentTree.this.setPaintBusy(false);
                    NlComponentTree.this.mySelectionIsUpdating.set(false);
                }
                NlComponentTree.this.updateSelection();
            }
        });
        if (this.mySkipWait) {
            this.mySkipWait = false;
            this.myUpdateQueue.flush();
        }
    }

    @NotNull
    private Collection<NlComponent> getCollapsedComponents() {
        int rowCount = this.getRowCount();
        HashSet components = Sets.newHashSetWithExpectedSize((int)rowCount);
        for (int row = 0; row < rowCount; ++row) {
            NlComponent component;
            if (!this.isCollapsed(row) || (component = (NlComponent)this.getPathForRow(row).getLastPathComponent()).getChildCount() == 0) continue;
            components.add(component);
        }
        HashSet hashSet = components;
        if (hashSet == null) {
            NlComponentTree.$$$reportNull$$$0(1);
        }
        return hashSet;
    }

    private void collapseComponents(@NotNull Collection<NlComponent> components) {
        NlComponent root;
        if (components == null) {
            NlComponentTree.$$$reportNull$$$0(2);
        }
        if ((root = (NlComponent)this.getModel().getRoot()) == null) {
            return;
        }
        this.expandAll(root);
        components.forEach(component -> this.collapsePath(NlComponentTree.newTreePath(component)));
    }

    private void expandAll(@NotNull NlComponent parent) {
        if (parent == null) {
            NlComponentTree.$$$reportNull$$$0(3);
        }
        if (parent.getChildren().stream().allMatch(child -> child.getChildCount() == 0)) {
            this.expandPath(NlComponentTree.newTreePath(parent));
        } else {
            parent.getChildren().forEach(this::expandAll);
        }
    }

    void skipNextUpdateDelay() {
        this.mySkipWait = true;
    }

    private void updateSelection() {
        if (!this.mySelectionIsUpdating.compareAndSet(false, true)) {
            return;
        }
        try {
            this.clearSelection();
            if (this.myModel != null) {
                for (NlComponent component : this.myModel.getSelectionModel().getSelection()) {
                    this.addSelectionPath(NlComponentTree.newTreePath(component));
                }
            }
        }
        finally {
            this.mySelectionIsUpdating.set(false);
        }
    }

    @NotNull
    private static TreePath newTreePath(@NotNull NlComponent component) {
        if (component == null) {
            NlComponentTree.$$$reportNull$$$0(4);
        }
        ArrayList<NlComponent> components = new ArrayList<NlComponent>();
        components.add(component);
        for (NlComponent parent = component.getParent(); parent != null; parent = parent.getParent()) {
            components.add(parent);
        }
        Collections.reverse(components);
        TreePath treePath = new TreePath(components.toArray());
        if (treePath == null) {
            NlComponentTree.$$$reportNull$$$0(5);
        }
        return treePath;
    }

    public void paint(Graphics g) {
        super.paint(g);
        if (this.myInsertionPath != null) {
            this.paintInsertionPoint(g);
        }
    }

    private void paintInsertionPoint(Graphics g) {
        if (this.myInsertionPath != null) {
            Rectangle pathBounds = this.getPathBounds(this.myInsertionPath);
            if (pathBounds == null) {
                return;
            }
            int y = pathBounds.y;
            switch (this.myInsertionPoint) {
                case INSERT_BEFORE: {
                    break;
                }
                case INSERT_AFTER: {
                    y += pathBounds.height;
                    break;
                }
                case INSERT_INTO: {
                    y += pathBounds.height / 2;
                }
            }
            Rectangle bounds = this.getBounds();
            Polygon triangle = new Polygon();
            triangle.addPoint(bounds.x + 6, y);
            triangle.addPoint(bounds.x, y + 3);
            triangle.addPoint(bounds.x, y - 3);
            g.setColor(UIUtil.getTreeForeground());
            if (this.myInsertionPoint != InsertionPoint.INSERT_INTO) {
                g.drawLine(bounds.x, y, bounds.x + bounds.width, y);
            }
            g.drawPolygon(triangle);
            g.fillPolygon(triangle);
        }
    }

    public void markInsertionPoint(@Nullable TreePath path, @NotNull InsertionPoint insertionPoint) {
        if (insertionPoint == null) {
            NlComponentTree.$$$reportNull$$$0(6);
        }
        if (this.myInsertionPath != path || this.myInsertionPoint != insertionPoint) {
            this.myInsertionPath = path;
            this.myInsertionPoint = insertionPoint;
            this.repaint();
        }
    }

    protected void clearToggledPaths() {
        super.clearToggledPaths();
    }

    public List<NlComponent> getSelectedComponents() {
        ArrayList<NlComponent> selected = new ArrayList<NlComponent>();
        TreePath[] paths = this.getSelectionPaths();
        if (paths != null) {
            for (TreePath path : paths) {
                selected.add((NlComponent)path.getLastPathComponent());
            }
        }
        return selected;
    }

    @Override
    public void selectionChanged(@NotNull SelectionModel model, @NotNull List<NlComponent> selection) {
        if (model == null) {
            NlComponentTree.$$$reportNull$$$0(7);
        }
        if (selection == null) {
            NlComponentTree.$$$reportNull$$$0(8);
        }
        UIUtil.invokeLaterIfNeeded(this::updateSelection);
    }

    @Override
    public void modelChanged(@NotNull NlModel model) {
        if (model == null) {
            NlComponentTree.$$$reportNull$$$0(9);
        }
        UIUtil.invokeLaterIfNeeded(this::updateHierarchy);
    }

    @Override
    public void modelRendered(@NotNull NlModel model) {
        if (model == null) {
            NlComponentTree.$$$reportNull$$$0(10);
        }
    }

    @Override
    public void modelChangedOnLayout(@NotNull NlModel model, boolean animate) {
        if (model == null) {
            NlComponentTree.$$$reportNull$$$0(11);
        }
    }

    @Override
    public void componentSelectionChanged(@NotNull DesignSurface surface, @NotNull List<NlComponent> newSelection) {
        if (surface == null) {
            NlComponentTree.$$$reportNull$$$0(12);
        }
        if (newSelection == null) {
            NlComponentTree.$$$reportNull$$$0(13);
        }
    }

    @Override
    public void screenChanged(@NotNull DesignSurface surface, @Nullable ScreenView screenView) {
        if (surface == null) {
            NlComponentTree.$$$reportNull$$$0(14);
        }
        this.setScreenView(screenView);
    }

    @Override
    public void modelChanged(@NotNull DesignSurface surface, @Nullable NlModel model) {
        if (surface == null) {
            NlComponentTree.$$$reportNull$$$0(15);
        }
        if (model != null) {
            this.modelRendered(model);
        }
    }

    @Override
    public boolean activatePreferredEditor(@NotNull DesignSurface surface, @NotNull NlComponent component) {
        if (surface == null) {
            NlComponentTree.$$$reportNull$$$0(16);
        }
        if (component == null) {
            NlComponentTree.$$$reportNull$$$0(17);
        }
        return false;
    }

    public Object getData(@NonNls String dataId) {
        if (PlatformDataKeys.DELETE_ELEMENT_PROVIDER.is(dataId) || PlatformDataKeys.CUT_PROVIDER.is(dataId) || PlatformDataKeys.COPY_PROVIDER.is(dataId) || PlatformDataKeys.PASTE_PROVIDER.is(dataId)) {
            return this;
        }
        return null;
    }

    public boolean isCopyEnabled(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            NlComponentTree.$$$reportNull$$$0(18);
        }
        return !this.myModel.getSelectionModel().isEmpty();
    }

    public boolean isCopyVisible(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            NlComponentTree.$$$reportNull$$$0(19);
        }
        return true;
    }

    public void performCopy(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            NlComponentTree.$$$reportNull$$$0(20);
        }
        if (this.myModel.getSelectionModel().isEmpty()) {
            return;
        }
        this.myCopyPasteManager.setContents(this.myModel.getSelectionAsTransferable());
    }

    public boolean isCutEnabled(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            NlComponentTree.$$$reportNull$$$0(21);
        }
        return !this.myModel.getSelectionModel().isEmpty();
    }

    public boolean isCutVisible(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            NlComponentTree.$$$reportNull$$$0(22);
        }
        return true;
    }

    public void performCut(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            NlComponentTree.$$$reportNull$$$0(23);
        }
        this.performCopy(dataContext);
        this.deleteElement(dataContext);
    }

    public boolean canDeleteElement(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            NlComponentTree.$$$reportNull$$$0(24);
        }
        return true;
    }

    public void deleteElement(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            NlComponentTree.$$$reportNull$$$0(25);
        }
        SelectionModel selectionModel = this.myScreenView.getSelectionModel();
        NlModel model = this.myScreenView.getModel();
        this.skipNextUpdateDelay();
        model.delete(selectionModel.getSelection());
    }

    public boolean isPastePossible(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            NlComponentTree.$$$reportNull$$$0(26);
        }
        return this.getInsertSpecification() != null;
    }

    public boolean isPasteEnabled(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            NlComponentTree.$$$reportNull$$$0(27);
        }
        return true;
    }

    public void performPaste(@NotNull DataContext dataContext) {
        InsertSpecification spec;
        if (dataContext == null) {
            NlComponentTree.$$$reportNull$$$0(28);
        }
        if ((spec = this.getInsertSpecification()) == null) {
            return;
        }
        Transferable transferable = this.myCopyPasteManager.getContents();
        if (transferable == null) {
            return;
        }
        DnDTransferItem item = NlModel.getTransferItem(transferable, true);
        if (item == null) {
            return;
        }
        List components = (List)ApplicationManager.getApplication().runWriteAction(() -> this.myModel.createComponents(this.myScreenView, item, InsertType.PASTE));
        this.myModel.addComponents(components, spec.layout, spec.before, InsertType.PASTE);
    }

    @Nullable
    private InsertSpecification getInsertSpecification() {
        int selectionCount = this.myModel.getSelectionModel().getSelection().size();
        if (selectionCount > 1) {
            return null;
        }
        if (selectionCount == 1) {
            NlComponent component = this.myModel.getSelectionModel().getSelection().get(0);
            if (component.getViewHandler() instanceof ViewGroupHandler) {
                return new InsertSpecification(component, component.getChild(0));
            }
            NlComponent parent = component.getParent();
            return parent != null ? new InsertSpecification(parent, component.getNextSibling()) : null;
        }
        if (this.myModel.getComponents().size() != 1) {
            return null;
        }
        NlComponent component = this.myModel.getComponents().get(0);
        return component.getViewHandler() instanceof ViewGroupHandler ? new InsertSpecification(component, component.getChild(0)) : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "copyPasteManager";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/uibuilder/structure/NlComponentTree";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "components";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 4: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "insertionPoint";
                break;
            }
            case 7: 
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selection";
                break;
            }
            case 12: 
            case 14: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "surface";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newSelection";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/uibuilder/structure/NlComponentTree";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getCollapsedComponents";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "newTreePath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 5: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "collapseComponents";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "expandAll";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "newTreePath";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "markInsertionPoint";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "selectionChanged";
                break;
            }
            case 9: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "modelChanged";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "modelRendered";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "modelChangedOnLayout";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "componentSelectionChanged";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "screenChanged";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "activatePreferredEditor";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "isCopyEnabled";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "isCopyVisible";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "performCopy";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "isCutEnabled";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "isCutVisible";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "performCut";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "canDeleteElement";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "deleteElement";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "isPastePossible";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "isPasteEnabled";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "performPaste";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class InsertSpecification {
        private final NlComponent layout;
        private final NlComponent before;

        private InsertSpecification(@NotNull NlComponent layout, @Nullable NlComponent before) {
            if (layout == null) {
                InsertSpecification.$$$reportNull$$$0(0);
            }
            this.layout = layout;
            this.before = before;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "layout", "com/android/tools/idea/uibuilder/structure/NlComponentTree$InsertSpecification", "<init>"));
        }
    }

    private static final class StructureSpeedSearch
    extends TreeSpeedSearch {
        StructureSpeedSearch(@NotNull NlComponentTree tree) {
            if (tree == null) {
                StructureSpeedSearch.$$$reportNull$$$0(0);
            }
            super((JTree)((Object)tree));
        }

        protected boolean isMatchingElement(Object element, String pattern) {
            if (pattern == null) {
                return false;
            }
            Object component = ((TreePath)element).getLastPathComponent();
            return this.compare(component instanceof NlComponent ? StructureTreeDecorator.toString((NlComponent)component) : "", pattern);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/android/tools/idea/uibuilder/structure/NlComponentTree$StructureSpeedSearch", "<init>"));
        }
    }

    private class StructurePaneSelectionListener
    implements TreeSelectionListener {
        private StructurePaneSelectionListener() {
        }

        @Override
        public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
            if (!NlComponentTree.this.mySelectionIsUpdating.compareAndSet(false, true)) {
                return;
            }
            try {
                NlComponentTree.this.myModel.getSelectionModel().setSelection(NlComponentTree.this.getSelectedComponents());
            }
            finally {
                NlComponentTree.this.mySelectionIsUpdating.set(false);
            }
        }
    }

    private class StructurePaneMouseListener
    extends MouseAdapter {
        private StructurePaneMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            this.handlePopup(e);
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.handlePopup(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.handlePopup(e);
        }

        private void handlePopup(MouseEvent e) {
            Object component;
            TreePath path;
            if (e.isPopupTrigger() && (path = NlComponentTree.this.getPathForLocation(e.getX(), e.getY())) != null && (component = path.getLastPathComponent()) instanceof NlComponent) {
                NlComponentTree.this.myScreenView.getSurface().getActionManager().showPopup(e, NlComponentTree.this.myScreenView, (NlComponent)component);
            }
        }
    }

    public static enum InsertionPoint {
        INSERT_INTO,
        INSERT_BEFORE,
        INSERT_AFTER;

    }
}

