/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.welcome.wizard;

import com.android.repository.api.RemotePackage;
import com.android.repository.impl.meta.Archive;
import com.android.repository.io.FileOpUtils;
import com.android.tools.idea.welcome.SdkLocationUtils;
import com.android.tools.idea.welcome.wizard.FirstRunWizardStep;
import com.android.tools.idea.welcome.wizard.WelcomeUIUtils;
import com.android.tools.idea.wizard.WizardConstants;
import com.android.tools.idea.wizard.dynamic.ScopedStateStore;
import com.google.common.collect.ComparisonChain;
import com.google.common.collect.Sets;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.File;
import java.util.Collection;
import java.util.Comparator;
import java.util.TreeSet;
import java.util.function.Supplier;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.border.EmptyBorder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class InstallSummaryStep
extends FirstRunWizardStep {
    private final ScopedStateStore.Key<Boolean> myKeyCustomInstall;
    private final ScopedStateStore.Key<String> myKeySdkInstallLocation;
    private final Supplier<? extends Collection<RemotePackage>> myPackagesProvider;
    private JPanel myPanel;
    private JTextPane mySummaryText;

    public InstallSummaryStep(ScopedStateStore.Key<Boolean> keyCustomInstall, ScopedStateStore.Key<String> keySdkInstallLocation, Supplier<? extends Collection<RemotePackage>> packagesProvider) {
        super("Verify Settings");
        this.myKeyCustomInstall = keyCustomInstall;
        this.myKeySdkInstallLocation = keySdkInstallLocation;
        this.myPackagesProvider = packagesProvider;
        this.$$$setupUI$$$();
        this.mySummaryText.setContentType("text/html");
        this.mySummaryText.setBorder(new EmptyBorder(0, WizardConstants.STUDIO_WIZARD_INSET_SIZE, WizardConstants.STUDIO_WIZARD_INSET_SIZE, WizardConstants.STUDIO_WIZARD_INSET_SIZE));
        this.setComponent(this.myPanel);
    }

    private static Section getPackagesSection(@NotNull Collection<RemotePackage> remotePackages) {
        if (remotePackages == null) {
            InstallSummaryStep.$$$reportNull$$$0(0);
        }
        return new Section("SDK Components to Download", InstallSummaryStep.getPackagesTable(remotePackages));
    }

    @Nullable
    private static String getPackagesTable(@NotNull Collection<RemotePackage> remotePackages) {
        if (remotePackages == null) {
            InstallSummaryStep.$$$reportNull$$$0(1);
        }
        if (remotePackages.isEmpty()) {
            return null;
        }
        TreeSet sortedPackagesList = Sets.newTreeSet((Comparator)new PackageInfoComparator());
        sortedPackagesList.addAll(remotePackages);
        StringBuilder table = new StringBuilder("<table>");
        for (RemotePackage remotePkgInfo : sortedPackagesList) {
            Archive archive = remotePkgInfo.getArchive();
            assert (archive != null);
            table.append("<tr><td>").append(remotePkgInfo.getDisplayName()).append("</td><td>&nbsp;&nbsp;</td><td>").append(WelcomeUIUtils.getSizeLabel(archive.getComplete().getSize())).append("</td></tr>");
        }
        table.append("</table>");
        return table.toString();
    }

    private static Section getDownloadSizeSection(@NotNull Collection<RemotePackage> remotePackages) {
        if (remotePackages == null) {
            InstallSummaryStep.$$$reportNull$$$0(2);
        }
        long downloadSize = 0L;
        for (RemotePackage remotePackage : remotePackages) {
            Archive archive = remotePackage.getArchive();
            assert (archive != null);
            downloadSize += archive.getComplete().getSize();
        }
        return new Section("Total Download Size", downloadSize == 0L ? "" : WelcomeUIUtils.getSizeLabel(downloadSize));
    }

    @Override
    public void onEnterStep() {
        super.onEnterStep();
        this.generateSummary();
        this.invokeUpdate(null);
    }

    @Override
    public void init() {
    }

    private void generateSummary() {
        Collection<RemotePackage> packages = this.myPackagesProvider.get();
        if (packages == null) {
            this.mySummaryText.setText("An error occurred while trying to compute required packages.");
            return;
        }
        Section[] sections = new Section[]{this.getSetupTypeSection(), this.getSdkFolderSection(), InstallSummaryStep.getDownloadSizeSection(packages), InstallSummaryStep.getPackagesSection(packages)};
        StringBuilder builder = new StringBuilder("<html><head>");
        builder.append(UIUtil.getCssFontDeclaration((Font)UIUtil.getLabelFont(), (Color)UIUtil.getLabelForeground(), null, null)).append("</head><body>");
        for (Section section : sections) {
            if (section.isEmpty()) continue;
            builder.append(section.toHtml());
        }
        builder.append("</body></html>");
        this.mySummaryText.setText(builder.toString());
    }

    private Section getSdkFolderSection() {
        File location = this.getSdkDirectory();
        String text = SdkLocationUtils.isWritable(FileOpUtils.create(), location) ? location.getAbsolutePath() : location.getAbsolutePath() + " (read-only)";
        return new Section("SDK Folder", text);
    }

    private File getSdkDirectory() {
        String path = this.myState.get(this.myKeySdkInstallLocation);
        assert (path != null);
        return new File(path);
    }

    private Section getSetupTypeSection() {
        String setupType = this.myState.getNotNull(this.myKeyCustomInstall, false) != false ? "Custom" : "Standard";
        return new Section("Setup Type", setupType);
    }

    @Override
    @Nullable
    public JLabel getMessageLabel() {
        return null;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.mySummaryText;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "remotePackages";
        objectArray2[1] = "com/android/tools/idea/welcome/wizard/InstallSummaryStep";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getPackagesSection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getPackagesTable";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getDownloadSizeSection";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JTextPane jTextPane;
        JPanel jPanel;
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(4, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JLabel jLabel = new JLabel();
        jLabel.setText("If you want to review or change any of your installation settings, click Previous.");
        jPanel.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(1, 0, 1, 1, 0, 2, 1, 0, null, new Dimension(-1, 16), new Dimension(-1, 16)));
        JLabel jLabel2 = new JLabel();
        jLabel2.setText("Current Settings:");
        jPanel.add((Component)jLabel2, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JScrollPane jScrollPane = new JScrollPane();
        jPanel.add((Component)jScrollPane, new GridConstraints(3, 0, 1, 1, 0, 3, 7, 3, null, null, null));
        this.mySummaryText = jTextPane = new JTextPane();
        jTextPane.setEditable(false);
        jScrollPane.setViewportView(jTextPane);
        jLabel2.setLabelFor(jTextPane);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private static class PackageInfoComparator
    implements Comparator<RemotePackage> {
        private PackageInfoComparator() {
        }

        @Override
        public int compare(RemotePackage o1, RemotePackage o2) {
            if (o1 == o2) {
                return 0;
            }
            if (o1 == null) {
                return -1;
            }
            if (o2 == null) {
                return 1;
            }
            ComparisonChain comparisonChain = ComparisonChain.start();
            return comparisonChain.compare((Comparable)((Object)o1.getDisplayName()), (Comparable)((Object)o2.getDisplayName())).result();
        }
    }

    private static final class Section {
        @NotNull
        private final String myTitle;
        @NotNull
        private final String myText;

        public Section(@NotNull String title, @Nullable String text) {
            if (title == null) {
                Section.$$$reportNull$$$0(0);
            }
            this.myTitle = title;
            this.myText = StringUtil.notNullize((String)text);
        }

        public boolean isEmpty() {
            return StringUtil.isEmptyOrSpaces((String)this.myText);
        }

        public String toHtml() {
            return String.format("<p><strong>%1$s:</strong><br>%2$s</p>", this.myTitle, this.myText);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/android/tools/idea/welcome/wizard/InstallSummaryStep$Section", "<init>"));
        }
    }
}

