/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.klint.checks;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.tools.klint.client.api.JavaEvaluator;
import com.android.tools.klint.detector.api.Category;
import com.android.tools.klint.detector.api.ClassContext;
import com.android.tools.klint.detector.api.Detector;
import com.android.tools.klint.detector.api.Implementation;
import com.android.tools.klint.detector.api.Issue;
import com.android.tools.klint.detector.api.JavaContext;
import com.android.tools.klint.detector.api.Location;
import com.android.tools.klint.detector.api.Scope;
import com.android.tools.klint.detector.api.Severity;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.org.objectweb.asm.tree.AbstractInsnNode;
import org.jetbrains.org.objectweb.asm.tree.ClassNode;
import org.jetbrains.org.objectweb.asm.tree.InsnList;
import org.jetbrains.org.objectweb.asm.tree.MethodNode;
import org.jetbrains.uast.UBlockExpression;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UReturnExpression;
import org.jetbrains.uast.UastEmptyExpression;
import org.jetbrains.uast.visitor.AbstractUastVisitor;
import org.jetbrains.uast.visitor.UastVisitor;

public class TrustAllX509TrustManagerDetector
extends Detector
implements Detector.UastScanner,
Detector.ClassScanner {
    private static final Implementation IMPLEMENTATION = new Implementation(TrustAllX509TrustManagerDetector.class, EnumSet.of(Scope.JAVA_LIBRARIES, Scope.JAVA_FILE), Scope.JAVA_FILE_SCOPE);
    public static final Issue ISSUE = Issue.create("TrustAllX509TrustManager", "Insecure TLS/SSL trust manager", "This check looks for X509TrustManager implementations whose `checkServerTrusted` or `checkClientTrusted` methods do nothing (thus trusting any certificate chain) which could result in insecure network traffic caused by trusting arbitrary TLS/SSL certificates presented by peers.", Category.SECURITY, 6, Severity.WARNING, IMPLEMENTATION);

    @Override
    @Nullable
    public List<String> applicableSuperClasses() {
        return Collections.singletonList("javax.net.ssl.X509TrustManager");
    }

    @Override
    public void checkClass(@NonNull JavaContext context, @NonNull UClass cls) {
        TrustAllX509TrustManagerDetector.checkMethod(context, cls, "checkServerTrusted");
        TrustAllX509TrustManagerDetector.checkMethod(context, cls, "checkClientTrusted");
    }

    private static void checkMethod(@NonNull JavaContext context, @NonNull UClass cls, @NonNull String methodName2) {
        JavaEvaluator evaluator = context.getEvaluator();
        for (PsiMethod method : cls.findMethodsByName(methodName2, true)) {
            if (evaluator.isAbstract((PsiModifierListOwner)method)) continue;
            UExpression body2 = context.getUastContext().getMethodBody(method);
            ComplexBodyVisitor visitor = new ComplexBodyVisitor();
            body2.accept((UastVisitor)visitor);
            if (visitor.isComplex()) continue;
            Location location = context.getNameLocation((PsiElement)method);
            String message = TrustAllX509TrustManagerDetector.getErrorMessage(methodName2);
            context.report(ISSUE, (PsiElement)method, location, message);
        }
    }

    @NonNull
    private static String getErrorMessage(String methodName2) {
        return "`" + methodName2 + "` is empty, which could cause insecure network traffic due to trusting arbitrary TLS/SSL certificates presented by peers";
    }

    @Override
    public void checkClass(@NonNull ClassContext context, @NonNull ClassNode classNode) {
        if (!context.isFromClassLibrary()) {
            return;
        }
        if (!classNode.interfaces.contains("javax/net/ssl/X509TrustManager")) {
            return;
        }
        List methodList = classNode.methods;
        for (Object m : methodList) {
            MethodNode method = (MethodNode)m;
            if (!"checkServerTrusted".equals(method.name) && !"checkClientTrusted".equals(method.name)) continue;
            InsnList nodes = method.instructions;
            boolean emptyMethod = true;
            int n = nodes.size();
            for (int i = 0; i < n; ++i) {
                AbstractInsnNode instruction = nodes.get(i);
                int type2 = instruction.getType();
                if (type2 == 8 || type2 == 15 || type2 == 0 && instruction.getOpcode() == 177) continue;
                emptyMethod = false;
                break;
            }
            if (!emptyMethod) continue;
            Location location = context.getLocation(method, classNode);
            context.report(ISSUE, location, TrustAllX509TrustManagerDetector.getErrorMessage(method.name));
        }
    }

    private static class ComplexBodyVisitor
    extends AbstractUastVisitor {
        private boolean isComplex = false;

        private ComplexBodyVisitor() {
        }

        public boolean visitElement(@NotNull UElement node) {
            if (node instanceof UExpression && !(node instanceof UReturnExpression) && !(node instanceof UBlockExpression) && !(node instanceof UastEmptyExpression)) {
                this.isComplex = true;
            }
            return this.isComplex || super.visitElement(node);
        }

        boolean isComplex() {
            return this.isComplex;
        }
    }
}

