/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.sherpa.interaction;

import android.support.constraint.solver.widgets.Animator;
import android.support.constraint.solver.widgets.ConstraintAnchor;
import android.support.constraint.solver.widgets.ConstraintWidget;
import android.support.constraint.solver.widgets.Guideline;
import com.android.tools.sherpa.interaction.ConstraintHandle;
import com.android.tools.sherpa.interaction.ResizeHandle;
import com.android.tools.sherpa.interaction.SnapCandidate;
import com.android.tools.sherpa.interaction.SnapPlacement;
import com.android.tools.sherpa.interaction.WidgetInteractionTargets;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;

public class WidgetResize {
    private ArrayList<SnapCandidate> mSnapCandidates = new ArrayList();

    private static int clampX(int x, ConstraintWidget base) {
        if (x < base.getX()) {
            x = base.getX();
        } else if (x > base.getRight()) {
            x = base.getRight();
        }
        return x;
    }

    private static int clampY(int y, ConstraintWidget base) {
        if (y < base.getY()) {
            y = base.getY();
        } else if (y > base.getBottom()) {
            y = base.getBottom();
        }
        return y;
    }

    public void resizeWidget(Collection<ConstraintWidget> widgets, ConstraintWidget widget, ResizeHandle handle, Rectangle originalBounds, int posX, int posY) {
        boolean baselineIsConnected;
        if (widget == null) {
            return;
        }
        Animator.setAnimationEnabled((boolean)false);
        this.mSnapCandidates.clear();
        int x = widget.getDrawX();
        int y = widget.getDrawY();
        int w = widget.getDrawWidth();
        int h = widget.getDrawHeight();
        ResizeHandle.Type resize = handle.getType();
        ConstraintAnchor left = widget.getAnchor(ConstraintAnchor.Type.LEFT);
        ConstraintAnchor top = widget.getAnchor(ConstraintAnchor.Type.TOP);
        ConstraintAnchor right = widget.getAnchor(ConstraintAnchor.Type.RIGHT);
        ConstraintAnchor bottom = widget.getAnchor(ConstraintAnchor.Type.BOTTOM);
        ConstraintAnchor baseline = widget.getAnchor(ConstraintAnchor.Type.BASELINE);
        boolean leftIsConnected = left != null && left.isConnected();
        boolean rightIsConnected = right != null && right.isConnected();
        boolean topIsConnected = top != null && top.isConnected();
        boolean bottomIsConnected = bottom != null && bottom.isConnected();
        boolean bl = baselineIsConnected = baseline != null && baseline.isConnected();
        if (leftIsConnected && !rightIsConnected) {
            switch (resize) {
                case LEFT_TOP: {
                    resize = ResizeHandle.Type.TOP_SIDE;
                    break;
                }
                case LEFT_BOTTOM: {
                    resize = ResizeHandle.Type.BOTTOM_SIDE;
                }
            }
        }
        if (rightIsConnected && !leftIsConnected) {
            switch (resize) {
                case RIGHT_TOP: {
                    resize = ResizeHandle.Type.TOP_SIDE;
                    break;
                }
                case RIGHT_BOTTOM: {
                    resize = ResizeHandle.Type.BOTTOM_SIDE;
                }
            }
        }
        if ((topIsConnected || baselineIsConnected) && !bottomIsConnected) {
            switch (resize) {
                case LEFT_TOP: {
                    resize = ResizeHandle.Type.LEFT_SIDE;
                    break;
                }
                case RIGHT_TOP: {
                    resize = ResizeHandle.Type.RIGHT_SIDE;
                }
            }
        }
        if (bottomIsConnected && !topIsConnected) {
            switch (resize) {
                case LEFT_BOTTOM: {
                    resize = ResizeHandle.Type.LEFT_SIDE;
                    break;
                }
                case RIGHT_BOTTOM: {
                    resize = ResizeHandle.Type.RIGHT_SIDE;
                }
            }
        }
        ConstraintWidget base = widget.getParent();
        switch (resize) {
            case LEFT_TOP: {
                int newX = Math.min(originalBounds.x + originalBounds.width - widget.getMinWidth(), posX);
                newX = WidgetResize.clampX(newX, base);
                newX = WidgetResize.snapLeft(widgets, widget, newX, this.mSnapCandidates);
                int newY = Math.min(originalBounds.y + originalBounds.height - widget.getMinHeight(), posY);
                newY = WidgetResize.clampY(newY, base);
                newY = WidgetResize.snapTop(widgets, widget, newY, this.mSnapCandidates);
                int newWidth = originalBounds.x + originalBounds.width - newX;
                int newHeight = originalBounds.y + originalBounds.height - newY;
                WidgetResize.setNewFrame(widget, newX, newY, newWidth, newHeight);
                break;
            }
            case LEFT_BOTTOM: {
                int newX = Math.min(originalBounds.x + originalBounds.width - widget.getMinWidth(), posX);
                newX = WidgetResize.clampX(newX, base);
                newX = WidgetResize.snapLeft(widgets, widget, newX, this.mSnapCandidates);
                int newWidth = originalBounds.x + originalBounds.width - newX;
                int newHeight = posY - originalBounds.y;
                newHeight = WidgetResize.snapHeight(widgets, widget, newHeight, this.mSnapCandidates);
                WidgetResize.setNewFrame(widget, newX, y, newWidth, newHeight);
                break;
            }
            case RIGHT_TOP: {
                int newY = Math.min(originalBounds.y + originalBounds.height - widget.getMinHeight(), posY);
                newY = WidgetResize.clampY(newY, base);
                newY = WidgetResize.snapTop(widgets, widget, newY, this.mSnapCandidates);
                int newWidth = posX - originalBounds.x;
                newWidth = WidgetResize.snapWidth(widgets, widget, newWidth, this.mSnapCandidates);
                int newHeight = originalBounds.y + originalBounds.height - newY;
                WidgetResize.setNewFrame(widget, x, newY, newWidth, newHeight);
                break;
            }
            case RIGHT_BOTTOM: {
                int newWidth = posX - originalBounds.x;
                int newHeight = posY - originalBounds.y;
                newWidth = WidgetResize.snapWidth(widgets, widget, newWidth, this.mSnapCandidates);
                newHeight = WidgetResize.snapHeight(widgets, widget, newHeight, this.mSnapCandidates);
                WidgetResize.setNewFrame(widget, x, y, newWidth, newHeight);
                break;
            }
            case LEFT_SIDE: {
                int newX = Math.min(originalBounds.x + originalBounds.width - widget.getMinWidth(), posX);
                if (widget instanceof Guideline) {
                    newX = posX;
                }
                newX = WidgetResize.clampX(newX, base);
                newX = WidgetResize.snapLeft(widgets, widget, newX, this.mSnapCandidates);
                int newWidth = originalBounds.x + originalBounds.width - newX;
                WidgetResize.setNewFrame(widget, newX, y, newWidth, h);
                break;
            }
            case RIGHT_SIDE: {
                int newWidth = posX - originalBounds.x;
                newWidth = WidgetResize.snapWidth(widgets, widget, newWidth, this.mSnapCandidates);
                WidgetResize.setNewFrame(widget, x, y, newWidth, h);
                break;
            }
            case TOP_SIDE: {
                int newY = Math.min(originalBounds.y + originalBounds.height - widget.getMinHeight(), posY);
                if (widget instanceof Guideline) {
                    newY = posY;
                }
                newY = WidgetResize.clampY(newY, base);
                newY = WidgetResize.snapTop(widgets, widget, newY, this.mSnapCandidates);
                int newHeight = originalBounds.y + originalBounds.height - newY;
                WidgetResize.setNewFrame(widget, x, newY, w, newHeight);
                break;
            }
            case BOTTOM_SIDE: {
                int newHeight = posY - originalBounds.y;
                newHeight = WidgetResize.snapHeight(widgets, widget, newHeight, this.mSnapCandidates);
                WidgetResize.setNewFrame(widget, x, y, w, newHeight);
            }
        }
    }

    private static int snapLeft(Collection<ConstraintWidget> widgets, ConstraintWidget widget, int left, ArrayList<SnapCandidate> snapCandidates) {
        return WidgetResize.snapHorizontal(widgets, widget, widget.getAnchor(ConstraintAnchor.Type.LEFT), left, snapCandidates);
    }

    private static int snapTop(Collection<ConstraintWidget> widgets, ConstraintWidget widget, int top, ArrayList<SnapCandidate> snapCandidates) {
        return WidgetResize.snapVertical(widgets, widget, widget.getAnchor(ConstraintAnchor.Type.TOP), top, snapCandidates);
    }

    private static int snapWidth(Collection<ConstraintWidget> widgets, ConstraintWidget widget, int width, ArrayList<SnapCandidate> snapCandidates) {
        int rightPosition = widget.getDrawX() + width;
        rightPosition = WidgetResize.snapHorizontal(widgets, widget, widget.getAnchor(ConstraintAnchor.Type.RIGHT), rightPosition, snapCandidates);
        width = rightPosition - widget.getDrawX();
        return width;
    }

    private static int snapHeight(Collection<ConstraintWidget> widgets, ConstraintWidget widget, int height, ArrayList<SnapCandidate> snapCandidates) {
        int bottomPosition = widget.getDrawY() + height;
        bottomPosition = WidgetResize.snapVertical(widgets, widget, widget.getAnchor(ConstraintAnchor.Type.BOTTOM), bottomPosition, snapCandidates);
        height = bottomPosition - widget.getDrawY();
        return height;
    }

    private static int snapHorizontal(Collection<ConstraintWidget> widgets, ConstraintWidget widget, ConstraintAnchor anchor, int position, ArrayList<SnapCandidate> snapCandidates) {
        SnapCandidate candidate = new SnapCandidate();
        ConstraintHandle handle = WidgetInteractionTargets.constraintHandle(anchor);
        if (handle == null) {
            return position;
        }
        handle.setDrawX(position);
        SnapPlacement.snapAnchor(widgets, widget, anchor, candidate);
        if (candidate.target != null) {
            ConstraintHandle targetHandle = WidgetInteractionTargets.constraintHandle(candidate.target);
            int tx = candidate.x;
            if (targetHandle != null) {
                tx = targetHandle.getDrawX();
            }
            position = tx + candidate.margin;
            snapCandidates.add(candidate);
        }
        return position;
    }

    private static int snapVertical(Collection<ConstraintWidget> widgets, ConstraintWidget widget, ConstraintAnchor anchor, int position, ArrayList<SnapCandidate> snapCandidates) {
        SnapCandidate candidate = new SnapCandidate();
        ConstraintHandle handle = WidgetInteractionTargets.constraintHandle(anchor);
        if (handle == null) {
            return position;
        }
        handle.setDrawY(position);
        SnapPlacement.snapAnchor(widgets, widget, anchor, candidate);
        if (candidate.target != null) {
            ConstraintHandle targetHandle = WidgetInteractionTargets.constraintHandle(candidate.target);
            int ty = candidate.y;
            if (targetHandle != null) {
                ty = targetHandle.getDrawY();
            }
            position = ty + candidate.margin;
            snapCandidates.add(candidate);
        }
        return position;
    }

    private static void setNewFrame(ConstraintWidget widget, int newX, int newY, int newWidth, int newHeight) {
        if (newWidth < 0) {
            newWidth = 0;
        }
        if (newHeight < 0) {
            newHeight = 0;
        }
        widget.setDrawOrigin(newX, newY);
        widget.setDimension(newWidth, newHeight);
        widget.forceUpdateDrawPosition();
        if (widget.getWidth() == widget.getWrapWidth()) {
            widget.setHorizontalDimensionBehaviour(ConstraintWidget.DimensionBehaviour.WRAP_CONTENT);
        } else {
            widget.setHorizontalDimensionBehaviour(ConstraintWidget.DimensionBehaviour.FIXED);
        }
        if (widget.getHeight() == widget.getWrapHeight()) {
            widget.setVerticalDimensionBehaviour(ConstraintWidget.DimensionBehaviour.WRAP_CONTENT);
        } else {
            widget.setVerticalDimensionBehaviour(ConstraintWidget.DimensionBehaviour.FIXED);
        }
    }

    public ArrayList<SnapCandidate> getSnapCandidates() {
        return this.mSnapCandidates;
    }

    public void mouseReleased() {
        this.mSnapCandidates.clear();
    }
}

