/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.css;

import com.intellij.lang.css.CssDialect;
import com.intellij.lang.css.CssDialectMappings;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.impl.FilePropertyPusher;
import com.intellij.openapi.roots.impl.PushedFilePropertiesUpdater;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.FileAttribute;
import com.intellij.openapi.vfs.newvfs.persistent.VfsDependentEnum;
import com.intellij.psi.css.CssFileType;
import com.intellij.util.ObjectUtils;
import com.intellij.util.io.DataInputOutputUtil;
import com.intellij.util.io.EnumeratorStringDescriptor;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.messages.MessageBus;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CssDialectPusher
implements FilePropertyPusher<CssDialect> {
    private static final FileAttribute PERSISTENCE = new FileAttribute("css_dialect_persistence", 2, true);
    private static final VfsDependentEnum<String> CSS_DIALECT_ENUMERATOR = new VfsDependentEnum("css_dialects", (KeyDescriptor)EnumeratorStringDescriptor.INSTANCE, 1);
    private ThreadLocal<CssDialect> myModuleDefaultMapping = new ThreadLocal();

    @NotNull
    public Key<CssDialect> getFileDataKey() {
        Key<CssDialect> key = CssDialectMappings.CSS_DIALECT_KEY;
        if (key == null) {
            CssDialectPusher.$$$reportNull$$$0(0);
        }
        return key;
    }

    public void initExtra(@NotNull Project project, @NotNull MessageBus bus, @NotNull FilePropertyPusher.Engine languageLevelUpdater) {
        if (project == null) {
            CssDialectPusher.$$$reportNull$$$0(1);
        }
        if (bus == null) {
            CssDialectPusher.$$$reportNull$$$0(2);
        }
        if (languageLevelUpdater == null) {
            CssDialectPusher.$$$reportNull$$$0(3);
        }
    }

    public boolean pushDirectoriesOnly() {
        return false;
    }

    @NotNull
    public CssDialect getDefaultValue() {
        CssDialect cssDialect = (CssDialect)ObjectUtils.notNull((Object)this.myModuleDefaultMapping.get(), (Object)CssDialect.CLASSIC);
        if (cssDialect == null) {
            CssDialectPusher.$$$reportNull$$$0(4);
        }
        return cssDialect;
    }

    @Nullable
    public CssDialect getImmediateValue(@NotNull Project project, @Nullable VirtualFile file) {
        if (project == null) {
            CssDialectPusher.$$$reportNull$$$0(5);
        }
        return (CssDialect)CssDialectMappings.getInstance(project).getImmediateMapping(file);
    }

    @Nullable
    public CssDialect getImmediateValue(@NotNull Module module) {
        if (module == null) {
            CssDialectPusher.$$$reportNull$$$0(6);
        }
        this.myModuleDefaultMapping.set(CssDialect.getDefaultDialect((Module)module));
        return null;
    }

    public boolean acceptsFile(@NotNull VirtualFile file) {
        if (file == null) {
            CssDialectPusher.$$$reportNull$$$0(7);
        }
        return CssFileType.INSTANCE.equals(file.getFileType());
    }

    public boolean acceptsDirectory(@NotNull VirtualFile file, @NotNull Project project) {
        if (file == null) {
            CssDialectPusher.$$$reportNull$$$0(8);
        }
        if (project == null) {
            CssDialectPusher.$$$reportNull$$$0(9);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void persistAttribute(@NotNull Project project, @NotNull VirtualFile fileOrDir, @NotNull CssDialect dialect) throws IOException {
        DataInputStream iStream;
        if (project == null) {
            CssDialectPusher.$$$reportNull$$$0(10);
        }
        if (fileOrDir == null) {
            CssDialectPusher.$$$reportNull$$$0(11);
        }
        if (dialect == null) {
            CssDialectPusher.$$$reportNull$$$0(12);
        }
        if ((iStream = PERSISTENCE.readAttribute(fileOrDir)) != null) {
            try {
                String oldDialectName = (String)CSS_DIALECT_ENUMERATOR.getById(DataInputOutputUtil.readINT((DataInput)iStream));
                if (Comparing.equal((String)oldDialectName, (String)dialect.getName())) {
                    return;
                }
            }
            finally {
                iStream.close();
            }
        }
        DataOutputStream oStream = PERSISTENCE.writeAttribute(fileOrDir);
        DataInputOutputUtil.writeINT((DataOutput)oStream, (int)CSS_DIALECT_ENUMERATOR.getId((Object)dialect.getName()));
        oStream.close();
        PushedFilePropertiesUpdater.getInstance((Project)project).filePropertiesChanged(fileOrDir, this::acceptsFile);
    }

    public void afterRootsChanged(@NotNull Project project) {
        if (project == null) {
            CssDialectPusher.$$$reportNull$$$0(13);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/css/CssDialectPusher";
                break;
            }
            case 1: 
            case 5: 
            case 9: 
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bus";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "languageLevelUpdater";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileOrDir";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialect";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileDataKey";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/css/CssDialectPusher";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultValue";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "initExtra";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getImmediateValue";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "acceptsFile";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "acceptsDirectory";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "persistAttribute";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "afterRootsChanged";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

