/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.aop.jam;

import com.intellij.aop.AopAdvice;
import com.intellij.aop.AopAdvisedElementsSearcher;
import com.intellij.aop.AopAspect;
import com.intellij.aop.AopBundle;
import com.intellij.aop.AopIntroduction;
import com.intellij.aop.AopProvider;
import com.intellij.aop.jam.AopAdviceImpl;
import com.intellij.aop.jam.AopIntroductionImpl;
import com.intellij.aop.jam.AopLanguageInjector;
import com.intellij.aop.jam.JamAopModel;
import com.intellij.aop.psi.AopPointcutUtil;
import com.intellij.aop.psi.AopReferenceHolder;
import com.intellij.aop.psi.PointcutMatchDegree;
import com.intellij.aop.psi.PsiPointcutExpression;
import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.codeInsight.daemon.LineMarkerProviderDescriptor;
import com.intellij.codeInsight.navigation.JamNavigationGutterIconBuilder;
import com.intellij.codeInsight.navigation.NavigationGutterIconBuilder;
import com.intellij.ide.util.DefaultPsiElementCellRenderer;
import com.intellij.ide.util.PsiElementListCellRenderer;
import com.intellij.jam.model.common.CommonModelElement;
import com.intellij.jam.model.util.JamCommonUtil;
import com.intellij.openapi.application.ReadActionProcessor;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.ui.LayeredIcon;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import icons.AopCommonIcons;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AopJavaAnnotator
extends LineMarkerProviderDescriptor {
    @Nullable
    public String getName() {
        return "AOP (Java)";
    }

    @Nullable
    public Icon getIcon() {
        return AopCommonIcons.Abstract_advice;
    }

    private static Icon createFromIcon(@NotNull Icon icon) {
        if (icon == null) {
            AopJavaAnnotator.$$$reportNull$$$0(0);
        }
        LayeredIcon layeredIcon = new LayeredIcon(2);
        layeredIcon.setIcon(icon, 0);
        layeredIcon.setIcon(AopCommonIcons.From_arrow, 1);
        return layeredIcon;
    }

    private static Icon createToIcon(@NotNull Icon icon) {
        if (icon == null) {
            AopJavaAnnotator.$$$reportNull$$$0(1);
        }
        LayeredIcon layeredIcon = new LayeredIcon(2);
        layeredIcon.setIcon(icon, 0);
        layeredIcon.setIcon(AopCommonIcons.To_arrow, 1);
        return layeredIcon;
    }

    public LineMarkerInfo getLineMarkerInfo(@NotNull PsiElement element) {
        if (element == null) {
            AopJavaAnnotator.$$$reportNull$$$0(2);
        }
        return null;
    }

    public void collectSlowLineMarkers(@NotNull List<PsiElement> elements, @NotNull Collection<LineMarkerInfo> result) {
        if (elements == null) {
            AopJavaAnnotator.$$$reportNull$$$0(3);
        }
        if (result == null) {
            AopJavaAnnotator.$$$reportNull$$$0(4);
        }
        int size = elements.size();
        for (int i = 0; i < size; ++i) {
            PsiElement element = elements.get(i);
            AopJavaAnnotator.annotate(element, result);
        }
    }

    private static void annotate(PsiElement psiElement, Collection<LineMarkerInfo> result) {
        if (!(psiElement instanceof PsiIdentifier)) {
            return;
        }
        PsiElement parent = psiElement.getParent();
        if (parent instanceof PsiMethod) {
            PsiMethod method = (PsiMethod)parent;
            if (method.isConstructor()) {
                return;
            }
            List<AopProvider> providers = AopLanguageInjector.getAopProviders(psiElement);
            if (providers.isEmpty()) {
                return;
            }
            PsiIdentifier nameIdentifier = method.getNameIdentifier();
            if (nameIdentifier != psiElement) {
                return;
            }
            PsiClass psiClass = method.getContainingClass();
            Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)method);
            if (module != null && psiClass != null) {
                PsiPointcutExpression expression;
                AopAdviceImpl advice;
                if (AopJavaAnnotator.isAcceptableAdviceMethod(psiClass, providers) && (advice = JamAopModel.getAdvice(method)) != null && (expression = advice.getPointcutExpression()) != null) {
                    AopAdvisedElementsSearcher searcher = AopPointcutUtil.getHolder(expression).getAopModel().getAdvisedElementsSearcher();
                    result.add((LineMarkerInfo)AopJavaAnnotator.addNavigationToInterceptedMethods(advice, searcher).createLineMarkerInfo((PsiElement)nameIdentifier));
                    return;
                }
                Map<AopAdvice, Integer> boundAdvices = AopJavaAnnotator.addBoundAdvices(method, AopJavaAnnotator.getAspects(providers, module), providers);
                if (!boundAdvices.isEmpty()) {
                    result.add((LineMarkerInfo)AopJavaAnnotator.addNavigationToBoundAdvices(boundAdvices).createLineMarkerInfo((PsiElement)nameIdentifier));
                }
            }
        } else if (parent instanceof PsiClass) {
            PsiClass psiClass = (PsiClass)parent;
            if (psiClass.hasModifierProperty("abstract")) {
                return;
            }
            PsiIdentifier nameIdentifier = psiClass.getNameIdentifier();
            if (nameIdentifier != psiElement) {
                return;
            }
            List<AopIntroduction> boundIntros = AopJavaAnnotator.getBoundIntroductions(psiClass);
            if (!boundIntros.isEmpty()) {
                result.add((LineMarkerInfo)AopJavaAnnotator.addNavigationToBoundIntroductions(boundIntros).createLineMarkerInfo((PsiElement)nameIdentifier));
            }
        } else if (parent instanceof PsiField) {
            NavigationGutterIconBuilder<PsiElement> builder;
            AopIntroductionImpl introduction;
            PsiField field = (PsiField)parent;
            List<AopProvider> providers = AopLanguageInjector.getAopProviders(psiElement);
            if (providers.isEmpty()) {
                return;
            }
            PsiIdentifier nameIdentifier = field.getNameIdentifier();
            if (nameIdentifier != psiElement) {
                return;
            }
            PsiClass psiClass = field.getContainingClass();
            Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)field);
            if (module != null && psiClass != null && (introduction = JamAopModel.getIntroduction(field)) != null && (builder = AopJavaAnnotator.addNavigationToIntroducedClasses(introduction)) != null) {
                result.add((LineMarkerInfo)builder.createLineMarkerInfo((PsiElement)nameIdentifier));
            }
        }
    }

    @NotNull
    public static NavigationGutterIconBuilder<AopIntroduction> addNavigationToBoundIntroductions(List<AopIntroduction> boundIntros) {
        NavigationGutterIconBuilder navigationGutterIconBuilder = JamNavigationGutterIconBuilder.createJamGutterBuilder((Icon)AopJavaAnnotator.createToIcon(AopCommonIcons.Gutter.Introduction), AopIntroduction.class).setTargets(boundIntros).setTooltipText(AopBundle.message("tooltip.text.navigate.to.introductions", new Object[0])).setPopupTitle(AopBundle.message("tooltip.text.navigate.to.introductions", new Object[0])).setAlignment(GutterIconRenderer.Alignment.LEFT);
        if (navigationGutterIconBuilder == null) {
            AopJavaAnnotator.$$$reportNull$$$0(5);
        }
        return navigationGutterIconBuilder;
    }

    @NotNull
    public static NavigationGutterIconBuilder<AopAdvice> addNavigationToBoundAdvices(Map<AopAdvice, Integer> boundAdvices) {
        ArrayList<AopAdvice> adviceList = new ArrayList<AopAdvice>(boundAdvices.keySet());
        Collections.sort(adviceList, (o1, o2) -> {
            boolean onTheWayIn = o1.getAdviceType().isOnTheWayIn();
            if (onTheWayIn != o2.getAdviceType().isOnTheWayIn()) {
                return onTheWayIn ? -1 : 1;
            }
            int i1 = (Integer)boundAdvices.get(o1);
            int i2 = (Integer)boundAdvices.get(o2);
            int diff = i2 - i1;
            return onTheWayIn ? -diff : diff;
        });
        THashMap psi2Advice = new THashMap();
        NavigationGutterIconBuilder navigationGutterIconBuilder = NavigationGutterIconBuilder.create((Icon)AopJavaAnnotator.createToIcon(AopCommonIcons.Gutter.Abstract_advice), arg_0 -> AopJavaAnnotator.lambda$addNavigationToBoundAdvices$1((Map)psi2Advice, arg_0)).setTargets(adviceList).setTooltipText(AopBundle.message("tooltip.text.navigate.to.advices", new Object[0])).setPopupTitle(AopBundle.message("tooltip.text.navigate.to.advices", new Object[0])).setAlignment(GutterIconRenderer.Alignment.LEFT).setCellRenderer((PsiElementListCellRenderer)new DefaultPsiElementCellRenderer((Map)psi2Advice, boundAdvices){
            final /* synthetic */ Map val$psi2Advice;
            final /* synthetic */ Map val$boundAdvices;
            {
                this.val$psi2Advice = map;
                this.val$boundAdvices = map2;
            }

            public String getElementText(PsiElement element) {
                Integer integer;
                String superText = super.getElementText(element);
                AopAdvice advice = (AopAdvice)this.val$psi2Advice.get(element);
                if (advice != null && advice.isValid() && (integer = (Integer)this.val$boundAdvices.get(advice)) != null && integer < Integer.MAX_VALUE) {
                    return superText + " (order=" + integer + ")";
                }
                return superText;
            }

            public String getContainerText(PsiElement element, String name) {
                PsiFile file;
                String superText = super.getContainerText(element, name);
                if (StringUtil.isEmpty((String)superText) && (file = element.getContainingFile()) != null) {
                    return "(in " + file.getName() + ")";
                }
                return superText;
            }

            protected int getIconFlags() {
                return 0;
            }
        });
        if (navigationGutterIconBuilder == null) {
            AopJavaAnnotator.$$$reportNull$$$0(6);
        }
        return navigationGutterIconBuilder;
    }

    public static List<AopIntroduction> getBoundIntroductions(PsiClass psiClass) {
        Project project = psiClass.getProject();
        return DumbService.isDumb((Project)project) ? Collections.emptyList() : (List)CachedValuesManager.getCachedValue((PsiElement)psiClass, () -> CachedValueProvider.Result.create(AopJavaAnnotator.calcBoundIntroductions(psiClass, true), (Object[])new Object[]{PsiModificationTracker.OUT_OF_CODE_BLOCK_MODIFICATION_COUNT}));
    }

    public static List<AopIntroduction> getBoundIntroductionsForModelClass(PsiClass psiClass) {
        Project project = psiClass.getProject();
        return DumbService.isDumb((Project)project) ? Collections.emptyList() : (List)CachedValuesManager.getCachedValue((PsiElement)psiClass, () -> CachedValueProvider.Result.create(AopJavaAnnotator.calcBoundIntroductions(psiClass, false), (Object[])new Object[]{PsiModificationTracker.OUT_OF_CODE_BLOCK_MODIFICATION_COUNT}));
    }

    private static List<AopIntroduction> calcBoundIntroductions(PsiClass psiClass, boolean checkAdvisable) {
        if (psiClass.hasModifierProperty("abstract")) {
            return Collections.emptyList();
        }
        List<AopProvider> providers = AopLanguageInjector.getAopProviders((PsiElement)psiClass);
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)psiClass);
        if (module == null || providers.isEmpty()) {
            return Collections.emptyList();
        }
        SmartList boundIntros = new SmartList();
        PsiClassType type = AopJavaAnnotator.createPsiType(psiClass);
        for (AopAspect aspect : AopJavaAnnotator.getAspects(providers, module)) {
            for (AopIntroduction aopIntroduction : aspect.getIntroductions()) {
                AopAdvisedElementsSearcher searcher;
                AopReferenceHolder holder = (AopReferenceHolder)aopIntroduction.getTypesMatching().getValue();
                if (holder == null || holder.accepts((PsiType)type) != PointcutMatchDegree.TRUE || !(searcher = AopPointcutUtil.getHolder((PsiElement)holder).getAopModel().getAdvisedElementsSearcher()).isInherentlyAdvisable(psiClass) || checkAdvisable && !searcher.isAdvisableInModel(psiClass)) continue;
                boundIntros.add(aopIntroduction);
            }
        }
        return boundIntros;
    }

    private static Set<AopAspect> getAspects(List<AopProvider> providers, Module module) {
        return (Set)CachedValuesManager.getManager((Project)module.getProject()).getCachedValue((UserDataHolder)module, () -> {
            HashSet<AopAspect> set = new HashSet<AopAspect>();
            AopJavaAnnotator.collectAspects(providers, module, set);
            for (Module module1 : ModuleUtilCore.getAllDependentModules((Module)module)) {
                AopJavaAnnotator.collectAspects(providers, module1, set);
            }
            return CachedValueProvider.Result.create(set, (Object[])new Object[]{PsiModificationTracker.OUT_OF_CODE_BLOCK_MODIFICATION_COUNT});
        });
    }

    private static void collectAspects(List<AopProvider> providers, Module module, Set<AopAspect> aspects) {
        aspects.addAll(new JamAopModel(module).getAspects());
        for (AopProvider provider : providers) {
            aspects.addAll(provider.getAdditionalAspects(module));
        }
    }

    private static int getAdviceOrder(AopAdvice advice, List<AopProvider> providers) {
        for (AopProvider provider : providers) {
            Integer order = provider.getAdviceOrder(advice);
            if (order == null) continue;
            return order;
        }
        return Integer.MAX_VALUE;
    }

    private static boolean isAcceptableAdviceMethod(PsiClass psiClass, List<AopProvider> providers) {
        for (AopProvider provider : providers) {
            if (provider.getAdvisedElementsSearcher(psiClass) == null) continue;
            return true;
        }
        return false;
    }

    private static Map<AopAdvice, Integer> addBoundAdvices(PsiMethod method, Collection<? extends AopAspect> aspects, List<AopProvider> providers) {
        LinkedHashMap<AopAdvice, Integer> boundAdvices = new LinkedHashMap<AopAdvice, Integer>();
        for (AopAspect aopAspect : aspects) {
            for (AopAdvice aopAdvice : aopAspect.getAdvices()) {
                ProgressManager.checkCanceled();
                AopAdvisedElementsSearcher searcher = aopAdvice.getSearcher();
                if (searcher == null || !AopJavaAnnotator.isAdviceAcceptingMethod(aopAdvice, method, searcher, true)) continue;
                boundAdvices.put(aopAdvice, AopJavaAnnotator.getAdviceOrder(aopAdvice, providers));
            }
        }
        return boundAdvices;
    }

    private static PsiClassType createPsiType(PsiClass psiClass) {
        return JavaPsiFacade.getInstance((Project)psiClass.getProject()).getElementFactory().createType(psiClass);
    }

    @NotNull
    public static NavigationGutterIconBuilder<PsiElement> addNavigationToInterceptedMethods(final AopAdvice advice, final AopAdvisedElementsSearcher searcher) {
        NavigationGutterIconBuilder navigationGutterIconBuilder = NavigationGutterIconBuilder.create((Icon)AopJavaAnnotator.createFromIcon(advice.getAdviceType().getAdviceIcon())).setTargets((NotNullLazyValue)new NotNullLazyValue<Collection<? extends PsiElement>>(){

            @NotNull
            public Collection<? extends PsiElement> compute() {
                if (!advice.isValid()) {
                    List list = Collections.emptyList();
                    if (list == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    return list;
                }
                THashSet result = new THashSet();
                ContainerUtil.process(searcher.collectAdvisedClasses(), (Processor)new ReadActionProcessor<PsiClass>((Set)result){
                    final /* synthetic */ Set val$result;
                    {
                        this.val$result = set;
                    }

                    public boolean processInReadAction(PsiClass psiClass) {
                        if (advice.isValid()) {
                            for (PsiMethod psiMethod : psiClass.getMethods()) {
                                if (!AopJavaAnnotator.isAdviceAcceptingMethod(advice, psiMethod, searcher, false)) continue;
                                this.val$result.add(psiMethod);
                            }
                        }
                        return true;
                    }
                });
                THashSet tHashSet = result;
                if (tHashSet == null) {
                    2.$$$reportNull$$$0(1);
                }
                return tHashSet;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/aop/jam/AopJavaAnnotator$2", "compute"));
            }
        }).setPopupTitle(AopBundle.message("tooltip.text.navigate.to.methods", new Object[0])).setTooltipText(AopBundle.message("tooltip.text.navigate.to.methods", new Object[0])).setEmptyPopupText(AopBundle.message("empty.popup.text.navigate.to.methods", new Object[0]));
        if (navigationGutterIconBuilder == null) {
            AopJavaAnnotator.$$$reportNull$$$0(7);
        }
        return navigationGutterIconBuilder;
    }

    @Nullable
    public static NavigationGutterIconBuilder<PsiElement> addNavigationToIntroducedClasses(AopIntroduction introduction) {
        final AopReferenceHolder expression = (AopReferenceHolder)introduction.getTypesMatching().getValue();
        if (expression == null) {
            return null;
        }
        final AopAdvisedElementsSearcher searcher = AopPointcutUtil.getHolder((PsiElement)expression).getAopModel().getAdvisedElementsSearcher();
        NotNullLazyValue<Collection<? extends PsiElement>> targets = new NotNullLazyValue<Collection<? extends PsiElement>>(){

            @NotNull
            public Collection<? extends PsiElement> compute() {
                THashSet result = new THashSet();
                ContainerUtil.process(searcher.collectAdvisedClasses(), (Processor)new ReadActionProcessor<PsiClass>((Set)result){
                    final /* synthetic */ Set val$result;
                    {
                        this.val$result = set;
                    }

                    public boolean processInReadAction(PsiClass psiClass) {
                        if (expression.accepts((PsiType)AopJavaAnnotator.createPsiType(psiClass)) == PointcutMatchDegree.TRUE && searcher.isInherentlyAdvisable(psiClass) && searcher.isAdvisableInModel(psiClass)) {
                            this.val$result.add(psiClass);
                        }
                        return true;
                    }
                });
                THashSet tHashSet = result;
                if (tHashSet == null) {
                    3.$$$reportNull$$$0(0);
                }
                return tHashSet;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/aop/jam/AopJavaAnnotator$3", "compute"));
            }
        };
        return NavigationGutterIconBuilder.create((Icon)AopJavaAnnotator.createFromIcon(AopCommonIcons.Gutter.Introduction)).setTargets((NotNullLazyValue)targets).setPopupTitle(AopBundle.message("tooltip.text.navigate.to.classes", new Object[0])).setTooltipText(AopBundle.message("tooltip.text.navigate.to.classes", new Object[0])).setEmptyPopupText(AopBundle.message("empty.popup.text.navigate.to.classes", new Object[0]));
    }

    public static Map<AopAdvice, Integer> getBoundAdvices(PsiClass psiClass) {
        return (Map)CachedValuesManager.getCachedValue((PsiElement)psiClass, () -> {
            Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)psiClass);
            if (module == null) {
                return CachedValueProvider.Result.create(Collections.emptyMap(), (Object[])new Object[]{PsiModificationTracker.OUT_OF_CODE_BLOCK_MODIFICATION_COUNT});
            }
            THashMap result = new THashMap();
            List<AopProvider> providers = AopLanguageInjector.getAopProviders((PsiElement)psiClass);
            Set<AopAspect> aspects = AopJavaAnnotator.getAspects(providers, module);
            for (PsiMethod method : psiClass.getMethods()) {
                result.putAll(AopJavaAnnotator.addBoundAdvices(method, aspects, providers));
            }
            return CachedValueProvider.Result.create((Object)result, (Object[])new Object[]{PsiModificationTracker.OUT_OF_CODE_BLOCK_MODIFICATION_COUNT});
        });
    }

    public static boolean isAdviceAcceptingMethod(AopAdvice advice, PsiMethod method, AopAdvisedElementsSearcher searcher, boolean checkClass) {
        PsiClass containingClass;
        if (!searcher.canBeAdvised(method)) {
            return false;
        }
        if (!(!checkClass || (containingClass = method.getContainingClass()) != null && containingClass.getQualifiedName() != null && searcher.isInherentlyAdvisable(containingClass) && searcher.isAdvisableInModel(containingClass))) {
            return false;
        }
        return advice.accepts(method) == PointcutMatchDegree.TRUE && searcher.acceptsBoundMethodHeavy(method);
    }

    private static /* synthetic */ Collection lambda$addNavigationToBoundAdvices$1(Map psi2Advice, AopAdvice advice) {
        PsiElement[] psiElements;
        for (PsiElement element : psiElements = JamCommonUtil.getTargetPsiElements((CommonModelElement)advice)) {
            psi2Advice.put(element, advice);
        }
        return Arrays.asList(psiElements);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "icon";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/aop/jam/AopJavaAnnotator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/aop/jam/AopJavaAnnotator";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "addNavigationToBoundIntroductions";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "addNavigationToBoundAdvices";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "addNavigationToInterceptedMethods";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createFromIcon";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createToIcon";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getLineMarkerInfo";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "collectSlowLineMarkers";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

