/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.struts.psi;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.struts.NamedModelImpl;
import com.intellij.struts.TilesModel;
import com.intellij.struts.dom.tiles.Definition;
import com.intellij.struts.dom.tiles.Put;
import com.intellij.struts.dom.tiles.TilesDefinitions;
import com.intellij.struts.util.DomNamedElementsHashingStrategy;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomUtil;
import gnu.trove.THashSet;
import gnu.trove.TObjectHashingStrategy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TilesModelImpl
extends NamedModelImpl<TilesDefinitions>
implements TilesModel {
    private static final TObjectHashingStrategy<Put> putHashingStrategy = new DomNamedElementsHashingStrategy<Put>();

    public TilesModelImpl(@NotNull Set<XmlFile> configFiles, @NotNull DomFileElement<TilesDefinitions> mergedModel, String name) {
        if (configFiles == null) {
            TilesModelImpl.$$$reportNull$$$0(0);
        }
        if (mergedModel == null) {
            TilesModelImpl.$$$reportNull$$$0(1);
        }
        super(configFiles, mergedModel, name);
    }

    @Nullable
    public XmlTag getTileTag(String definitionName) {
        Definition def = this.findDefinition(definitionName);
        return def == null ? null : def.getName().getXmlTag();
    }

    @NotNull
    public List<Definition> getDefinitions() {
        List list = ((TilesDefinitions)this.getMergedModel()).getDefinitions();
        if (list == null) {
            TilesModelImpl.$$$reportNull$$$0(2);
        }
        return list;
    }

    @Nullable
    public Definition findDefinition(String definitionName) {
        List<Definition> defs = this.getDefinitions();
        Definition exactMatch = (Definition)DomUtil.findByName(defs, (String)definitionName);
        if (exactMatch != null) {
            return exactMatch;
        }
        for (Definition definition : defs) {
            String name = definition.getName().getStringValue();
            if (name == null || !StringUtil.containsChar((String)name, (char)'*') || !Pattern.matches(StringUtil.replace((String)name, (String)"*", (String)"[^/]*"), definitionName)) continue;
            return definition;
        }
        return null;
    }

    @Nullable
    public Set<Put> getPuts(String definitionName, boolean includingExtends) {
        THashSet set = new THashSet(putHashingStrategy);
        boolean found = TilesModelImpl.getPuts(this.findDefinition(definitionName), (Collection<Put>)set, new HashSet<Definition>(), includingExtends);
        if (!found) {
            return null;
        }
        return set;
    }

    @Nullable
    public Collection<Put> getAllPuts(String definitionName) {
        ArrayList<Put> set = new ArrayList<Put>();
        boolean found = TilesModelImpl.getPuts(this.findDefinition(definitionName), set, new HashSet<Definition>(), true);
        if (!found) {
            return null;
        }
        return set;
    }

    @Nullable
    public XmlTag getPutTag(String definitionName, String putName) {
        Definition def = this.findDefinition(definitionName);
        if (def == null) {
            return null;
        }
        Put put = TilesModelImpl.findPutDefinition(def, putName, new HashSet<Definition>());
        return put == null ? null : put.getName().getXmlTag();
    }

    @Nullable
    private static Put findPutDefinition(Definition def, String putName, Set<Definition> visited) {
        Definition extend = (Definition)def.getExtends().getValue();
        if (extend != null && !visited.contains(def)) {
            visited.add(extend);
            Put put = TilesModelImpl.findPutDefinition(extend, putName, visited);
            if (put != null) {
                return put;
            }
        }
        return (Put)DomUtil.findByName((Collection)def.getPuts(), (String)putName);
    }

    private static boolean getPuts(Definition definition, Collection<Put> puts, Set<Definition> visited, boolean includingExtends) {
        Definition extend;
        if (definition == null || visited.contains(definition)) {
            return false;
        }
        visited.add(definition);
        List result = definition.getPuts();
        if (result != null) {
            for (Put put : result) {
                if (put.getName().getValue() == null) continue;
                puts.add(put);
            }
        }
        if (includingExtends && (extend = (Definition)definition.getExtends().getValue()) != null) {
            TilesModelImpl.getPuts(extend, puts, visited, true);
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configFiles";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mergedModel";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/struts/psi/TilesModelImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/struts/psi/TilesModelImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefinitions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

