/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ejb;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.daemon.ImplicitUsageProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.util.PropertyUtilBase;
import java.util.Arrays;
import java.util.List;

public class EjbImplicitUsageProvider
implements ImplicitUsageProvider {
    private static final List<String> INJECTION_ANNOS = Arrays.asList("javax.annotation.Resource", "javax.ejb.EJB", "javax.xml.ws.WebServiceRef");
    private static final List<String> INTERCEPTOR_ANNOS = Arrays.asList("javax.interceptor.AroundInvoke", "javax.ejb.PostActivate", "javax.annotation.PostConstruct", "javax.annotation.PreDestroy", "javax.ejb.PrePassivate");

    public boolean isImplicitRead(PsiElement element) {
        return false;
    }

    public boolean isImplicitUsage(PsiElement element) {
        if (element instanceof PsiMethod) {
            return PropertyUtilBase.isSimplePropertySetter((PsiMethod)((PsiMethod)element)) && EjbImplicitUsageProvider.isAnnotated(element, INJECTION_ANNOS) || EjbImplicitUsageProvider.isAnnotated(element, INTERCEPTOR_ANNOS);
        }
        if (element instanceof PsiParameter) {
            PsiElement scope = ((PsiParameter)element).getDeclarationScope();
            return scope instanceof PsiMethod && EjbImplicitUsageProvider.isAnnotated(scope, INTERCEPTOR_ANNOS);
        }
        return false;
    }

    private static boolean isAnnotated(PsiElement owner, List<String> annos) {
        return owner instanceof PsiModifierListOwner && AnnotationUtil.isAnnotated((PsiModifierListOwner)((PsiModifierListOwner)owner), annos);
    }

    public boolean isImplicitWrite(PsiElement element) {
        return EjbImplicitUsageProvider.isAnnotated(element, INJECTION_ANNOS);
    }
}

