/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.module.view.ejb.moduleLevel;

import com.intellij.CommonBundle;
import com.intellij.javaee.ui.DialogCommittableTab;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.help.HelpManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Disposer;
import com.intellij.psi.PsiFile;
import com.intellij.ui.TabbedPaneWrapper;
import com.intellij.ui.UserActivityListener;
import com.intellij.ui.UserActivityWatcher;
import com.intellij.util.xml.ui.CommitablePanelUserActivityListener;
import com.intellij.util.xml.ui.Committable;
import com.intellij.util.xml.ui.CompositeCommittable;
import com.intellij.util.xml.ui.DomUIFactory;
import java.awt.Component;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JavaeeEditDialog
extends DialogWrapper
implements Disposable {
    private final UserActivityWatcher myUserActivityWatcher = DomUIFactory.getDomUIFactory().createEditorAwareUserActivityWatcher();
    private final CommitablePanelUserActivityListener myUserActivityListener;
    private DialogCommittableTab[] myTabs;
    private TabbedPaneWrapper myTabbedPane;
    private final Project myProject;
    private final CompositeCommittable myCompositeCommittable = new CompositeCommittable();

    public JavaeeEditDialog(Project project) {
        super(project, false);
        this.myProject = project;
        Disposer.register((Disposable)this.myDisposable, (Disposable)this);
        Disposer.register((Disposable)this, (Disposable)this.myCompositeCommittable);
        this.myUserActivityListener = new CommitablePanelUserActivityListener(project){

            protected void applyChanges() {
                for (DialogCommittableTab tab : JavaeeEditDialog.this.myTabs) {
                    this.commit((Committable)tab);
                }
            }
        };
    }

    public void dispose() {
        super.dispose();
    }

    @Nullable
    @NonNls
    protected String getHelpId() {
        return null;
    }

    protected abstract DialogCommittableTab[] createTabs();

    @Nullable
    protected final JComponent createCenterPanel() {
        JComponent component;
        for (DialogCommittableTab tab : this.myTabs = this.createTabs()) {
            this.myCompositeCommittable.addComponent((Committable)tab);
        }
        if (this.myTabs.length == 1) {
            component = this.myTabs[0].getComponent();
        } else {
            this.myTabbedPane = new TabbedPaneWrapper(this.myDisposable);
            for (DialogCommittableTab page : this.myTabs) {
                JavaeeEditDialog.addPage(this.myTabbedPane, page.getTabName(), page.getPanel().getComponent());
            }
            this.myTabbedPane.setSelectedIndex(0);
            this.myTabbedPane.addChangeListener(new ChangeListener(){
                int index = 0;

                @Override
                public void stateChanged(ChangeEvent e) {
                    JavaeeEditDialog.this.myTabs[this.index].commit();
                    this.index = JavaeeEditDialog.this.myTabbedPane.getSelectedIndex();
                    JavaeeEditDialog.this.myTabs[this.index].reset();
                }
            });
            component = this.myTabbedPane.getComponent();
        }
        this.myUserActivityWatcher.register((Component)component);
        this.myUserActivityWatcher.addUserActivityListener((UserActivityListener)this.myUserActivityListener, (Disposable)this);
        this.myTabs[0].reset();
        return component;
    }

    private static void addPage(TabbedPaneWrapper pane, String tabName, JComponent component) {
        component.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        pane.addTab(tabName, component);
    }

    protected void doOKAction() {
        for (DialogCommittableTab tab : this.myTabs) {
            if (tab.getErrorMessage() == null) continue;
            if (this.myTabbedPane != null) {
                this.myTabbedPane.setSelectedComponent(tab.getComponent());
            }
            Messages.showErrorDialog((String)tab.getErrorMessage(), (String)CommonBundle.message((String)"title.error", (Object[])new Object[0]));
            return;
        }
        new WriteCommandAction(this.myProject, new PsiFile[0]){

            protected void run(@NotNull Result result) throws Throwable {
                if (result == null) {
                    3.$$$reportNull$$$0(0);
                }
                for (DialogCommittableTab tab : JavaeeEditDialog.this.myTabs) {
                    tab.closeNotify();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/javaee/module/view/ejb/moduleLevel/JavaeeEditDialog$3", "run"));
            }
        }.execute();
        super.doOKAction();
    }

    protected void doHelpAction() {
        HelpManager.getInstance().invokeHelp(this.getHelpId());
    }

    @NotNull
    protected Action[] createActions() {
        Action[] actionArray;
        String helpId = this.getHelpId();
        if (helpId == null) {
            actionArray = super.createActions();
        } else {
            Action[] actionArray2 = new Action[3];
            actionArray2[0] = this.getOKAction();
            actionArray2[1] = this.getCancelAction();
            actionArray = actionArray2;
            actionArray2[2] = this.getHelpAction();
        }
        if (actionArray == null) {
            JavaeeEditDialog.$$$reportNull$$$0(0);
        }
        return actionArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/module/view/ejb/moduleLevel/JavaeeEditDialog", "createActions"));
    }
}

