/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.execution;

import com.intellij.execution.Location;
import com.intellij.execution.console.DuplexConsoleView;
import com.intellij.execution.junit.JUnitUtil;
import com.intellij.execution.junit2.PsiMemberParameterizedLocation;
import com.intellij.execution.junit2.info.MethodLocation;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.icons.AllIcons;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.execution.ExternalTaskExecutionInfo;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationEvent;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationListener;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationListenerAdapter;
import com.intellij.openapi.externalSystem.model.task.event.ExternalSystemProgressEventUnsupported;
import com.intellij.openapi.externalSystem.model.task.event.ExternalSystemTaskExecutionEvent;
import com.intellij.openapi.externalSystem.model.task.event.OperationDescriptor;
import com.intellij.openapi.externalSystem.model.task.event.TaskOperationDescriptor;
import com.intellij.openapi.externalSystem.model.task.event.TestOperationDescriptor;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemTaskLocation;
import com.intellij.openapi.externalSystem.service.notification.ExternalSystemProgressNotificationManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.testIntegration.TestLocator;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.execution.ExecutionInfo;
import org.jetbrains.plugins.gradle.execution.TaskExecutionView;
import org.jetbrains.plugins.gradle.util.GradleBundle;
import org.jetbrains.plugins.gradle.util.GradleConstants;

public class GradleRunnerUtil {
    public static DuplexConsoleView attachTaskExecutionView(@NotNull Project project, final @NotNull ConsoleView consoleView, boolean isTaskConsoleEnabledByDefault, final @Nullable String stateStorageKey, @NotNull ProcessHandler processHandler, @NotNull ExternalSystemTaskId taskId) {
        String tripleStateStorageKey;
        if (project == null) {
            GradleRunnerUtil.$$$reportNull$$$0(0);
        }
        if (consoleView == null) {
            GradleRunnerUtil.$$$reportNull$$$0(1);
        }
        if (processHandler == null) {
            GradleRunnerUtil.$$$reportNull$$$0(2);
        }
        if (taskId == null) {
            GradleRunnerUtil.$$$reportNull$$$0(3);
        }
        String string = tripleStateStorageKey = stateStorageKey != null ? stateStorageKey + "_str" : null;
        if (stateStorageKey != null && isTaskConsoleEnabledByDefault && !PropertiesComponent.getInstance().isValueSet(tripleStateStorageKey)) {
            PropertiesComponent.getInstance().setValue(tripleStateStorageKey, Boolean.TRUE.toString());
            PropertiesComponent.getInstance().setValue(stateStorageKey, Boolean.TRUE.booleanValue());
        }
        TaskExecutionView gradleExecutionConsole = new TaskExecutionView(project);
        final Ref duplexConsoleViewRef = Ref.create();
        DuplexConsoleView<ConsoleView, ConsoleView> duplexConsoleView = new DuplexConsoleView<ConsoleView, ConsoleView>((ConsoleView)gradleExecutionConsole, consoleView, stateStorageKey){

            public void enableConsole(boolean primary) {
                super.enableConsole(primary);
                if (stateStorageKey != null) {
                    PropertiesComponent.getInstance().setValue(tripleStateStorageKey, Boolean.toString(primary));
                }
            }

            @NotNull
            public AnAction[] createConsoleActions() {
                AnAction[] consoleActions;
                DefaultActionGroup textActionGroup = new DefaultActionGroup(){

                    public void update(AnActionEvent e) {
                        super.update(e);
                        if (duplexConsoleViewRef.get() != null) {
                            e.getPresentation().setVisible(!((DuplexConsoleView)duplexConsoleViewRef.get()).isPrimaryConsoleEnabled());
                        }
                    }
                };
                for (AnAction anAction : consoleActions = consoleView.createConsoleActions()) {
                    textActionGroup.add(anAction);
                }
                ArrayList anActions = ContainerUtil.newArrayList((Object[])super.createConsoleActions());
                anActions.add(textActionGroup);
                AnAction[] anActionArray = (AnAction[])ArrayUtil.toObjectArray((Collection)anActions, AnAction.class);
                if (anActionArray == null) {
                    1.$$$reportNull$$$0(0);
                }
                return anActionArray;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/execution/GradleRunnerUtil$1", "createConsoleActions"));
            }
        };
        duplexConsoleViewRef.set((Object)duplexConsoleView);
        duplexConsoleView.setDisableSwitchConsoleActionOnProcessEnd(false);
        duplexConsoleView.getSwitchConsoleActionPresentation().setIcon(AllIcons.Actions.ChangeView);
        duplexConsoleView.getSwitchConsoleActionPresentation().setText(GradleBundle.message("gradle.runner.toggle.tree.text.action.name", new Object[0]));
        ExternalSystemProgressNotificationManager progressManager = (ExternalSystemProgressNotificationManager)ServiceManager.getService(ExternalSystemProgressNotificationManager.class);
        ExternalSystemTaskNotificationListenerAdapter taskListener = new ExternalSystemTaskNotificationListenerAdapter((DuplexConsoleView)duplexConsoleView, gradleExecutionConsole, progressManager){
            final /* synthetic */ DuplexConsoleView val$duplexConsoleView;
            final /* synthetic */ TaskExecutionView val$gradleExecutionConsole;
            final /* synthetic */ ExternalSystemProgressNotificationManager val$progressManager;
            {
                this.val$duplexConsoleView = duplexConsoleView;
                this.val$gradleExecutionConsole = taskExecutionView;
                this.val$progressManager = externalSystemProgressNotificationManager;
            }

            public void onStatusChange(@NotNull ExternalSystemTaskNotificationEvent event) {
                if (event == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (event instanceof ExternalSystemTaskExecutionEvent) {
                    UIUtil.invokeLaterIfNeeded(() -> {
                        if (event == null) {
                            2.$$$reportNull$$$0(6);
                        }
                        if (((ExternalSystemTaskExecutionEvent)event).getProgressEvent() instanceof ExternalSystemProgressEventUnsupported) {
                            this.val$duplexConsoleView.enableConsole(false);
                        }
                        this.val$gradleExecutionConsole.onStatusChange((ExternalSystemTaskExecutionEvent)event);
                    });
                }
            }

            public void onStart(@NotNull ExternalSystemTaskId id, String workingDir) {
                if (id == null) {
                    2.$$$reportNull$$$0(1);
                }
                UIUtil.invokeLaterIfNeeded(() -> this.val$gradleExecutionConsole.setWorkingDir(workingDir));
            }

            public void onFailure(@NotNull ExternalSystemTaskId id, @NotNull Exception e) {
                if (id == null) {
                    2.$$$reportNull$$$0(2);
                }
                if (e == null) {
                    2.$$$reportNull$$$0(3);
                }
                UIUtil.invokeLaterIfNeeded(() -> {
                    if (e == null) {
                        2.$$$reportNull$$$0(5);
                    }
                    this.val$gradleExecutionConsole.onFailure(e);
                });
            }

            public void onEnd(@NotNull ExternalSystemTaskId id) {
                if (id == null) {
                    2.$$$reportNull$$$0(4);
                }
                this.val$progressManager.removeNotificationListener((ExternalSystemTaskNotificationListener)this);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "event";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "id";
                        break;
                    }
                    case 3: 
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "e";
                        break;
                    }
                }
                objectArray2[1] = "org/jetbrains/plugins/gradle/execution/GradleRunnerUtil$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onStatusChange";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onStart";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onFailure";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onEnd";
                        break;
                    }
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[2] = "lambda$onFailure$2";
                        break;
                    }
                    case 6: {
                        objectArray = objectArray2;
                        objectArray2[2] = "lambda$onStatusChange$0";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        progressManager.addNotificationListener(taskId, (ExternalSystemTaskNotificationListener)taskListener);
        return duplexConsoleView;
    }

    @Nullable
    public static Location<PsiMethod> getMethodLocation(@NotNull Location contextLocation) {
        PsiClass containingClass;
        MethodLocation methodLocation;
        if (contextLocation == null) {
            GradleRunnerUtil.$$$reportNull$$$0(4);
        }
        if ((methodLocation = GradleRunnerUtil.getTestMethod(contextLocation)) == null) {
            return null;
        }
        if (contextLocation instanceof PsiMemberParameterizedLocation && (containingClass = ((PsiMemberParameterizedLocation)contextLocation).getContainingClass()) != null) {
            methodLocation = MethodLocation.elementInClass((PsiMethod)((PsiMethod)methodLocation.getPsiElement()), (PsiClass)containingClass);
        }
        return methodLocation;
    }

    @Nullable
    public static Location<PsiMethod> getTestMethod(Location<?> location) {
        Iterator iterator = location.getAncestors(PsiMethod.class, false);
        while (iterator.hasNext()) {
            Location methodLocation = (Location)iterator.next();
            if (!JUnitUtil.isTestMethod((Location)methodLocation, (boolean)false)) continue;
            return methodLocation;
        }
        return null;
    }

    @NotNull
    public static String getTestLocationUrl(@Nullable String testName, @NotNull String fqClassName) {
        if (fqClassName == null) {
            GradleRunnerUtil.$$$reportNull$$$0(5);
        }
        String string = testName == null ? "java:test://" + fqClassName : "java:test://" + StringUtil.getQualifiedName((String)fqClassName, (String)testName);
        if (string == null) {
            GradleRunnerUtil.$$$reportNull$$$0(6);
        }
        return string;
    }

    public static Object getData(@NotNull Project project, @NonNls String dataId, @NotNull ExecutionInfo executionInfo) {
        Location location;
        if (project == null) {
            GradleRunnerUtil.$$$reportNull$$$0(7);
        }
        if (executionInfo == null) {
            GradleRunnerUtil.$$$reportNull$$$0(8);
        }
        if (CommonDataKeys.NAVIGATABLE.is(dataId)) {
            OpenFileDescriptor openFileDescriptor;
            location = GradleRunnerUtil.getLocation(project, executionInfo);
            OpenFileDescriptor openFileDescriptor2 = openFileDescriptor = location == null ? null : location.getOpenFileDescriptor();
            if (openFileDescriptor != null && openFileDescriptor.getFile().isValid()) {
                return openFileDescriptor;
            }
        }
        if (CommonDataKeys.PSI_ELEMENT.is(dataId)) {
            location = GradleRunnerUtil.getLocation(project, executionInfo);
            if (location != null) {
                PsiElement element = location.getPsiElement();
                return element.isValid() ? element : null;
            }
            return null;
        }
        if (Location.DATA_KEY.is(dataId)) {
            return GradleRunnerUtil.getLocation(project, executionInfo);
        }
        return null;
    }

    @Nullable
    public static ExternalSystemTaskLocation getTaskLocation(Project project, ExecutionInfo ... executionInfos) {
        ExternalTaskExecutionInfo taskExecutionInfo = new ExternalTaskExecutionInfo();
        String projectPath = null;
        List taskNames = taskExecutionInfo.getSettings().getTaskNames();
        for (ExecutionInfo executionInfo : executionInfos) {
            String taskName;
            OperationDescriptor descriptor = executionInfo.getDescriptor();
            if (descriptor instanceof TaskOperationDescriptor) {
                taskName = ((TaskOperationDescriptor)descriptor).getTaskName();
                if (projectPath == null) {
                    projectPath = executionInfo.getWorkingDir();
                } else if (!projectPath.equals(executionInfo.getWorkingDir())) {
                    return null;
                }
            } else {
                return null;
            }
            taskNames.add(taskName);
        }
        if (!taskNames.isEmpty()) {
            taskExecutionInfo.getSettings().setExternalSystemIdString(GradleConstants.SYSTEM_ID.toString());
            taskExecutionInfo.getSettings().setExternalProjectPath(projectPath);
            return ExternalSystemTaskLocation.create((Project)project, (ProjectSystemId)GradleConstants.SYSTEM_ID, projectPath, (ExternalTaskExecutionInfo)taskExecutionInfo);
        }
        return null;
    }

    @Nullable
    private static Location getLocation(@NotNull Project project, @NotNull ExecutionInfo executionInfo) {
        OperationDescriptor descriptor;
        if (project == null) {
            GradleRunnerUtil.$$$reportNull$$$0(9);
        }
        if (executionInfo == null) {
            GradleRunnerUtil.$$$reportNull$$$0(10);
        }
        if ((descriptor = executionInfo.getDescriptor()) instanceof TestOperationDescriptor) {
            if (DumbService.isDumb((Project)project)) {
                return null;
            }
            String suiteName = ((TestOperationDescriptor)descriptor).getSuiteName();
            if (StringUtil.isNotEmpty((String)suiteName)) {
                return TestLocator.getLocation((String)("java:suite://" + suiteName), (Project)project);
            }
            String className = ((TestOperationDescriptor)descriptor).getClassName();
            if (className == null) {
                return null;
            }
            String methodName = ((TestOperationDescriptor)descriptor).getMethodName();
            return TestLocator.getLocation((String)("java:test://" + StringUtil.getQualifiedName((String)className, (String)methodName)), (Project)project);
        }
        return GradleRunnerUtil.getTaskLocation(project, executionInfo);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consoleView";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processHandler";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "taskId";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextLocation";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fqClassName";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/gradle/execution/GradleRunnerUtil";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executionInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/gradle/execution/GradleRunnerUtil";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getTestLocationUrl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "attachTaskExecutionView";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getMethodLocation";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getTestLocationUrl";
                break;
            }
            case 6: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getLocation";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

