/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.util;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.externalSystem.model.ExternalSystemException;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.util.io.FileFilters;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtilRt;
import com.intellij.util.containers.Stack;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Properties;
import org.gradle.tooling.model.GradleProject;
import org.gradle.tooling.model.gradle.GradleScript;
import org.gradle.wrapper.WrapperConfiguration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.util.GradleLog;

public class GradleUtil {
    private static final String LAST_USED_GRADLE_HOME_KEY = "last.used.gradle.home";

    private GradleUtil() {
    }

    @NotNull
    public static FileChooserDescriptor getGradleProjectFileChooserDescriptor() {
        FileChooserDescriptor fileChooserDescriptor = FileChooserDescriptorFactory.createSingleFileDescriptor((String)"gradle");
        if (fileChooserDescriptor == null) {
            GradleUtil.$$$reportNull$$$0(0);
        }
        return fileChooserDescriptor;
    }

    @NotNull
    public static FileChooserDescriptor getGradleHomeFileChooserDescriptor() {
        FileChooserDescriptor fileChooserDescriptor = FileChooserDescriptorFactory.createSingleFolderDescriptor();
        if (fileChooserDescriptor == null) {
            GradleUtil.$$$reportNull$$$0(1);
        }
        return fileChooserDescriptor;
    }

    public static boolean isGradleDefaultWrapperFilesExist(@Nullable String gradleProjectPath) {
        return GradleUtil.getWrapperConfiguration(gradleProjectPath) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static WrapperConfiguration getWrapperConfiguration(@Nullable String gradleProjectPath) {
        File wrapperPropertiesFile = GradleUtil.findDefaultWrapperPropertiesFile(gradleProjectPath);
        if (wrapperPropertiesFile == null) {
            return null;
        }
        WrapperConfiguration wrapperConfiguration = new WrapperConfiguration();
        Properties props = new Properties();
        BufferedReader reader = null;
        try {
            String distPathBase;
            reader = new BufferedReader(new FileReader(wrapperPropertiesFile));
            props.load(reader);
            String distributionUrl = props.getProperty("distributionUrl");
            if (StringUtil.isEmpty((String)distributionUrl)) {
                throw new ExternalSystemException("Wrapper 'distributionUrl' property does not exist!");
            }
            wrapperConfiguration.setDistribution(GradleUtil.prepareDistributionUri(distributionUrl, wrapperPropertiesFile));
            String distributionPath = props.getProperty("distributionPath");
            if (!StringUtil.isEmpty((String)distributionPath)) {
                wrapperConfiguration.setDistributionPath(distributionPath);
            }
            if (!StringUtil.isEmpty((String)(distPathBase = props.getProperty("distributionBase")))) {
                wrapperConfiguration.setDistributionBase(distPathBase);
            }
            WrapperConfiguration wrapperConfiguration2 = wrapperConfiguration;
            return wrapperConfiguration2;
        }
        catch (Exception e) {
            GradleLog.LOG.warn(String.format("I/O exception on reading gradle wrapper properties file at '%s'", wrapperPropertiesFile.getAbsolutePath()), (Throwable)e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
        return null;
    }

    private static URI prepareDistributionUri(String distributionUrl, File propertiesFile) throws URISyntaxException {
        URI source = new URI(distributionUrl);
        return source.getScheme() != null ? source : new File(propertiesFile.getParentFile(), source.getSchemeSpecificPart()).toURI();
    }

    @NotNull
    public static String getConfigPath(@NotNull GradleProject subProject, @NotNull String rootProjectPath) {
        block9: {
            String string;
            if (subProject == null) {
                GradleUtil.$$$reportNull$$$0(2);
            }
            if (rootProjectPath == null) {
                GradleUtil.$$$reportNull$$$0(3);
            }
            try {
                File file;
                GradleScript script = subProject.getBuildScript();
                if (script == null || (file = script.getSourceFile()) == null) break block9;
                if (!file.isDirectory()) {
                    file = file.getParentFile();
                }
                string = ExternalSystemApiUtil.toCanonicalPath((String)file.getCanonicalPath());
            }
            catch (Exception script) {
                // empty catch block
            }
            if (string == null) {
                GradleUtil.$$$reportNull$$$0(4);
            }
            return string;
        }
        File rootProjectParent = new File(rootProjectPath);
        StringBuilder buffer = new StringBuilder(FileUtil.toCanonicalPath((String)rootProjectParent.getAbsolutePath()));
        Stack stack = ContainerUtilRt.newStack();
        for (GradleProject p = subProject; p != null; p = p.getParent()) {
            stack.push((Object)p.getName());
        }
        stack.pop();
        while (!stack.isEmpty()) {
            buffer.append('/').append((String)stack.pop());
        }
        String string = buffer.toString();
        if (string == null) {
            GradleUtil.$$$reportNull$$$0(5);
        }
        return string;
    }

    @NotNull
    public static String getLastUsedGradleHome() {
        String string = PropertiesComponent.getInstance().getValue(LAST_USED_GRADLE_HOME_KEY, "");
        if (string == null) {
            GradleUtil.$$$reportNull$$$0(6);
        }
        return string;
    }

    public static void storeLastUsedGradleHome(@Nullable String gradleHomePath) {
        PropertiesComponent.getInstance().setValue(LAST_USED_GRADLE_HOME_KEY, gradleHomePath, null);
    }

    @Nullable
    public static File findDefaultWrapperPropertiesFile(@Nullable String gradleProjectPath) {
        if (gradleProjectPath == null) {
            return null;
        }
        File file = new File(gradleProjectPath);
        File gradleDir = file.isFile() ? new File(file.getParentFile(), "gradle") : new File(file, "gradle");
        if (!gradleDir.isDirectory()) {
            return null;
        }
        File wrapperDir = new File(gradleDir, "wrapper");
        if (!wrapperDir.isDirectory()) {
            return null;
        }
        Object[] candidates = wrapperDir.listFiles(FileFilters.filesWithExtension((String)"properties"));
        if (candidates == null) {
            GradleLog.LOG.warn("No *.properties file is found at the gradle wrapper directory " + wrapperDir.getAbsolutePath());
            return null;
        }
        if (candidates.length != 1) {
            GradleLog.LOG.warn(String.format("%d *.properties files instead of one have been found at the wrapper directory (%s): %s", candidates.length, wrapperDir.getAbsolutePath(), Arrays.toString(candidates)));
            return null;
        }
        return candidates[0];
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/gradle/util/GradleUtil";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "subProject";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootProjectPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getGradleProjectFileChooserDescriptor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getGradleHomeFileChooserDescriptor";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/gradle/util/GradleUtil";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigPath";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getLastUsedGradleHome";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getConfigPath";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

