/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.fd.client;

import com.android.tools.fd.client.InstantRunArtifact;
import com.android.tools.fd.client.InstantRunArtifactType;
import com.android.utils.XmlUtils;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class InstantRunBuildInfo {
    private static final String FULL_BUILD_MODE = "FULL";
    private static final String COLD_SWAP_BUILD_MODE = "COLD";
    private static final boolean BUILDS_ARE_SORTED = false;
    private static final String ATTR_TIMESTAMP = "timestamp";
    public static final String ATTR_API_LEVEL = "api-level";
    private static final String ATTR_FORMAT = "format";
    private static final String ATTR_VERIFIER_STATUS = "verifier";
    public static final String VALUE_VERIFIER_STATUS_COMPATIBLE = "COMPATIBLE";
    private static final String TAG_ARTIFACT = "artifact";
    private static final String TAG_BUILD = "build";
    private static final String ATTR_ARTIFACT_LOCATION = "location";
    private static final String ATTR_ARTIFACT_TYPE = "type";
    private static final String ATTR_TOKEN = "token";
    private static final String ATTR_BUILD_MODE = "build-mode";
    private final String myXml;
    private final Element mRoot;
    private List<InstantRunArtifact> mArtifacts;

    public InstantRunBuildInfo(String xml, Element root) {
        this.myXml = xml;
        this.mRoot = root;
    }

    public String getTimeStamp() {
        return this.mRoot.getAttribute(ATTR_TIMESTAMP);
    }

    public long getSecretToken() {
        String tokenString = this.mRoot.getAttribute(ATTR_TOKEN);
        assert (!Strings.isNullOrEmpty((String)tokenString)) : "Application authorization token was not generated";
        return Long.parseLong(tokenString);
    }

    public String getVerifierStatus() {
        return this.mRoot.getAttribute(ATTR_VERIFIER_STATUS);
    }

    public String getBuildMode() {
        return this.mRoot.getAttribute(ATTR_BUILD_MODE);
    }

    public boolean isPatchBuild() {
        String buildMode = this.mRoot.getAttribute(ATTR_BUILD_MODE);
        if (FULL_BUILD_MODE.equals(buildMode)) {
            return false;
        }
        if (COLD_SWAP_BUILD_MODE.equals(buildMode)) {
            return this.getArtifacts().size() < 12;
        }
        return true;
    }

    public boolean canHotswap() {
        return VALUE_VERIFIER_STATUS_COMPATIBLE.equals(this.getVerifierStatus());
    }

    public boolean hasNoChanges() {
        return this.getArtifacts().isEmpty();
    }

    public int getFeatureLevel() {
        String attribute = this.mRoot.getAttribute(ATTR_API_LEVEL);
        if (attribute != null && !attribute.isEmpty()) {
            try {
                return Integer.parseInt(attribute);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return -1;
    }

    public List<InstantRunArtifact> getArtifacts() {
        if (this.mArtifacts == null) {
            ArrayList artifacts = Lists.newArrayList();
            NodeList children = this.mRoot.getChildNodes();
            String currentBuildTimestamp = this.mRoot.getAttribute(ATTR_TIMESTAMP);
            int n = children.getLength();
            for (int i = 0; i < n; ++i) {
                Node child = children.item(i);
                if (child.getNodeType() != 1) continue;
                Element element = (Element)child;
                String tagName = element.getTagName();
                if (!TAG_ARTIFACT.equals(tagName)) {
                    if (!TAG_BUILD.equals(tagName)) continue;
                    currentBuildTimestamp = element.getAttribute(ATTR_TIMESTAMP);
                    continue;
                }
                String location = element.getAttribute(ATTR_ARTIFACT_LOCATION);
                String typeAttribute = element.getAttribute(ATTR_ARTIFACT_TYPE);
                try {
                    InstantRunArtifactType type = InstantRunArtifactType.valueOf(typeAttribute);
                    artifacts.add(new InstantRunArtifact(type, new File(location), currentBuildTimestamp));
                    continue;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            this.mArtifacts = artifacts;
        }
        return this.mArtifacts;
    }

    public boolean hasOneOf(InstantRunArtifactType ... types) {
        for (InstantRunArtifact artifact : this.getArtifacts()) {
            for (InstantRunArtifactType type : types) {
                if (artifact.type != type) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasMainApk() {
        return this.hasOneOf(InstantRunArtifactType.MAIN) || this.hasOneOf(InstantRunArtifactType.SPLIT_MAIN);
    }

    public static InstantRunBuildInfo get(String xml) {
        Document doc = XmlUtils.parseDocumentSilently((String)xml, (boolean)false);
        if (doc == null) {
            return null;
        }
        return new InstantRunBuildInfo(xml, doc.getDocumentElement());
    }

    public boolean isCompatibleFormat() {
        return this.getFormat() == 10;
    }

    public int getFormat() {
        String attribute = this.mRoot.getAttribute(ATTR_FORMAT);
        if (Strings.isNullOrEmpty((String)attribute)) {
            return -1;
        }
        try {
            return Integer.parseInt(attribute);
        }
        catch (NumberFormatException nfe) {
            return -1;
        }
    }

    public void serializeTo(Writer writer) throws IOException {
        writer.write(this.myXml);
    }
}

