/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.LayoutDetector;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.XmlContext;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;

public class AccessibilityDetector
extends LayoutDetector {
    public static final Issue ISSUE = Issue.create("ContentDescription", "Image without `contentDescription`", "Non-textual widgets like ImageViews and ImageButtons should use the `contentDescription` attribute to specify a textual description of the widget such that screen readers and other accessibility tools can adequately describe the user interface.\n\nNote that elements in application screens that are purely decorative and do not provide any content or enable a user action should not have accessibility content descriptions. In this case, just suppress the lint warning with a tools:ignore=\"ContentDescription\" attribute.\n\nNote that for text fields, you should not set both the `hint` and the `contentDescription` attributes since the hint will never be shown. Just set the `hint`. See http://developer.android.com/guide/topics/ui/accessibility/checklist.html#special-cases.", Category.A11Y, 3, Severity.WARNING, new Implementation(AccessibilityDetector.class, Scope.RESOURCE_FILE_SCOPE));

    @Override
    public Collection<String> getApplicableElements() {
        return Arrays.asList("ImageButton", "ImageView");
    }

    @Override
    public Collection<String> getApplicableAttributes() {
        return Collections.singletonList("contentDescription");
    }

    @Override
    public void visitAttribute(XmlContext context, Attr attribute) {
        Element element = attribute.getOwnerElement();
        if (element.hasAttributeNS("http://schemas.android.com/apk/res/android", "hint")) {
            context.report(ISSUE, element, context.getLocation(attribute), "Do not set both `contentDescription` and `hint`: the `contentDescription` will mask the `hint`");
        }
    }

    @Override
    public void visitElement(XmlContext context, Element element) {
        if (!element.hasAttributeNS("http://schemas.android.com/apk/res/android", "contentDescription")) {
            if ("no".equals(element.getAttributeNS("http://schemas.android.com/apk/res/android", "importantForAccessibility"))) {
                return;
            }
            context.report(ISSUE, element, context.getLocation(element), "[Accessibility] Missing `contentDescription` attribute on image");
        } else {
            Attr attributeNode = element.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "contentDescription");
            String attribute = attributeNode.getValue();
            if (attribute.isEmpty() || attribute.equals("TODO")) {
                context.report(ISSUE, attributeNode, context.getLocation(attributeNode), "[Accessibility] Empty `contentDescription` attribute on image");
            }
        }
    }
}

