/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gwt.facet;

import com.intellij.facet.Facet;
import com.intellij.facet.FacetConfiguration;
import com.intellij.facet.FacetManager;
import com.intellij.facet.FacetType;
import com.intellij.facet.ModifiableFacetModel;
import com.intellij.facet.ProjectFacetManager;
import com.intellij.gwt.facet.GwtFacetConfiguration;
import com.intellij.gwt.facet.GwtFacetType;
import com.intellij.gwt.maven.GwtLtgtModuleWatcher;
import com.intellij.gwt.module.model.GwtModule;
import com.intellij.gwt.sdk.GwtSdk;
import com.intellij.gwt.sdk.GwtSdkManager;
import com.intellij.gwt.sdk.GwtSdkUtil;
import com.intellij.gwt.sdk.GwtVersion;
import com.intellij.gwt.sdk.impl.GwtVersionImpl;
import com.intellij.javaee.web.facet.WebFacet;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.roots.impl.OrderEntryUtil;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.ui.configuration.projectRoot.LibrariesContainer;
import com.intellij.openapi.roots.ui.configuration.projectRoot.LibrariesContainerFactory;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.Comparator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GwtFacet
extends Facet<GwtFacetConfiguration> {
    public GwtFacet(@NotNull FacetType facetType, @NotNull Module module, String name, @NotNull GwtFacetConfiguration configuration) {
        if (facetType == null) {
            GwtFacet.$$$reportNull$$$0(0);
        }
        if (module == null) {
            GwtFacet.$$$reportNull$$$0(1);
        }
        if (configuration == null) {
            GwtFacet.$$$reportNull$$$0(2);
        }
        super(facetType, module, name, (FacetConfiguration)configuration, null);
    }

    @Nullable
    public static GwtFacet getInstance(@NotNull Module module) {
        if (module == null) {
            GwtFacet.$$$reportNull$$$0(3);
        }
        return (GwtFacet)FacetManager.getInstance((Module)module).getFacetByType(GwtFacetType.ID);
    }

    @Nullable
    public static GwtFacet findFacetByPsiElement(@Nullable PsiElement element) {
        if (element == null) {
            return null;
        }
        PsiFile containingFile = element.getContainingFile();
        if (containingFile == null) {
            return null;
        }
        return GwtFacet.findFacetBySourceFile(element.getProject(), containingFile.getOriginalFile().getVirtualFile());
    }

    @Nullable
    public static GwtFacet findFacetBySourceFile(@NotNull Project project, @Nullable VirtualFile file) {
        if (project == null) {
            GwtFacet.$$$reportNull$$$0(4);
        }
        if (file == null) {
            return null;
        }
        Module module = ModuleUtilCore.findModuleForFile((VirtualFile)file, (Project)project);
        if (module == null || module.isDisposed()) {
            return null;
        }
        return GwtFacet.getInstance(module);
    }

    public static boolean isInModuleWithGwtFacet(@NotNull Project project, @Nullable VirtualFile file) {
        if (project == null) {
            GwtFacet.$$$reportNull$$$0(5);
        }
        return GwtFacet.findFacetBySourceFile(project, file) != null;
    }

    @Nullable
    public WebFacet getWebFacet() {
        String webFacetName = ((GwtFacetConfiguration)this.getConfiguration()).getWebFacetName();
        return webFacetName != null ? (WebFacet)FacetManager.getInstance((Module)this.getModule()).findFacet(WebFacet.ID, webFacetName) : null;
    }

    @NotNull
    public GwtVersion getSdkVersion() {
        GwtVersion gwtVersion = ((GwtFacetConfiguration)this.getConfiguration()).getSdk().getVersion();
        if (gwtVersion == null) {
            GwtFacet.$$$reportNull$$$0(6);
        }
        return gwtVersion;
    }

    public void initFacet() {
        GwtFacetConfiguration configuration = (GwtFacetConfiguration)this.getConfiguration();
        GwtSdkManager.getInstance().registerGwtSdk(configuration.getSdk());
        GwtLtgtModuleWatcher.getInstance(this.getModule().getProject());
    }

    public static GwtFacet createNewFacet(@NotNull Module module, GwtSdk sdk) {
        FacetManager facetManager;
        ModifiableFacetModel model;
        GwtFacet facet;
        if (module == null) {
            GwtFacet.$$$reportNull$$$0(7);
        }
        if ((facet = (GwtFacet)(model = (facetManager = FacetManager.getInstance((Module)module)).createModifiableModel()).getFacetByType(GwtFacetType.ID)) != null) {
            return facet;
        }
        GwtFacetType type = GwtFacetType.getInstance();
        GwtFacetConfiguration configuration = (GwtFacetConfiguration)ProjectFacetManager.getInstance((Project)module.getProject()).createDefaultConfiguration((FacetType)type);
        facet = (GwtFacet)facetManager.createFacet((FacetType)type, type.getDefaultFacetName(), (FacetConfiguration)configuration, null);
        model.addFacet((Facet)facet);
        ModifiableRootModel rootModel = ModuleRootManager.getInstance((Module)module).getModifiableModel();
        GwtFacet.setupGwtSdkAndLibraries(configuration, rootModel, sdk);
        WriteAction.run(() -> {
            model.commit();
            rootModel.commit();
        });
        return facet;
    }

    public static void setupGwtSdkAndLibraries(GwtFacetConfiguration configuration, ModifiableRootModel rootModel, @Nullable GwtSdk gwtSdk) {
        GwtFacet.setupGwtSdkAndLibraries(configuration, rootModel, gwtSdk, LibrariesContainerFactory.createContainer((Project)rootModel.getProject()));
    }

    public static void setupGwtSdkAndLibraries(GwtFacetConfiguration configuration, ModifiableRootModel rootModel, @Nullable GwtSdk gwtSdk, @NotNull LibrariesContainer container) {
        if (container == null) {
            GwtFacet.$$$reportNull$$$0(8);
        }
        if (gwtSdk == null || !gwtSdk.isValid()) {
            ProjectFacetManager facetManager = ProjectFacetManager.getInstance((Project)rootModel.getProject());
            gwtSdk = facetManager.getFacets(GwtFacetType.ID).stream().map(Facet::getConfiguration).map(GwtFacetConfiguration::getSdk).filter(GwtSdk::isValid).max(Comparator.comparing(sdk -> (GwtVersionImpl)sdk.getVersion())).orElseGet(GwtSdkManager.getInstance()::suggestGwtSdk);
        }
        if (gwtSdk != null) {
            Library library;
            configuration.setGwtSdkUrlAndType(gwtSdk.getHomeDirectoryUrl());
            GwtSdkManager.getInstance().moveToTop(gwtSdk);
            VirtualFile userJar = gwtSdk.getUserJar();
            if (userJar != null && OrderEntryUtil.findLibraryOrderEntry((ModuleRootModel)rootModel, (Library)(library = GwtSdkUtil.findOrCreateGwtUserLibrary(container, userJar))) == null) {
                rootModel.addLibraryEntry(library);
            }
        }
    }

    @NotNull
    public static GwtVersion getGwtVersion(@Nullable GwtFacet gwtFacet) {
        GwtVersion gwtVersion = gwtFacet != null ? gwtFacet.getSdkVersion() : GwtVersionImpl.getDefaultVersion();
        if (gwtVersion == null) {
            GwtFacet.$$$reportNull$$$0(9);
        }
        return gwtVersion;
    }

    @NotNull
    public static GwtVersion getGwtVersion(@Nullable Module module) {
        GwtFacet facet = module != null ? GwtFacet.getInstance(module) : null;
        GwtVersion gwtVersion = GwtFacet.getGwtVersion(facet);
        if (gwtVersion == null) {
            GwtFacet.$$$reportNull$$$0(10);
        }
        return gwtVersion;
    }

    @Nullable
    public static GwtFacet getInstance(GwtModule gwtModule) {
        Module module = gwtModule.getModule();
        return module != null ? GwtFacet.getInstance(module) : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 9: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facetType";
                break;
            }
            case 1: 
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/gwt/facet/GwtFacet";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "container";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/gwt/facet/GwtFacet";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getSdkVersion";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getGwtVersion";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findFacetBySourceFile";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isInModuleWithGwtFacet";
                break;
            }
            case 6: 
            case 9: 
            case 10: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createNewFacet";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "setupGwtSdkAndLibraries";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

