/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gwt.make.report;

import com.intellij.gwt.build.GwtBuildTargetScopeProvider;
import com.intellij.gwt.facet.GwtFacet;
import com.intellij.gwt.make.report.CompileReportSource;
import com.intellij.gwt.make.report.CompileReportsHistory;
import com.intellij.gwt.module.model.GwtModule;
import com.intellij.ide.BrowserUtil;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompileScope;
import com.intellij.openapi.compiler.CompileStatusNotification;
import com.intellij.openapi.compiler.CompilerManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.ui.ListCellRendererWrapper;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.text.DateFormatUtil;
import icons.GwtStudioIcons;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.URI;
import java.util.List;
import javax.swing.Action;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GenerateCompilerReportDialog
extends DialogWrapper {
    private JPanel myMainPanel;
    private JComboBox myModuleComboBox;
    private JLabel myInfoLabel;
    private final Project myProject;
    private static final String REPORT_FILE_PATH = "soycReport/compile-report/index.html";
    private final ViewReportAction myViewReportAction;
    private final CompileReportsHistory myReportsHistory;
    @NonNls
    public static final String MODULE_PROPERTY_KEY = "GWT.GenerateCompileReport.Module";

    public GenerateCompilerReportDialog(@NotNull Project project, List<GwtModule> modules) {
        if (project == null) {
            GenerateCompilerReportDialog.$$$reportNull$$$0(0);
        }
        super(project);
        this.$$$setupUI$$$();
        this.myReportsHistory = CompileReportsHistory.getInstance(project);
        this.myProject = project;
        this.setTitle("Generate GWT Compile Report");
        this.myViewReportAction = new ViewReportAction();
        DefaultComboBoxModel<GwtModule> model = new DefaultComboBoxModel<GwtModule>();
        String selectedModuleName = PropertiesComponent.getInstance((Project)project).getValue(MODULE_PROPERTY_KEY);
        GwtModule toSelect = null;
        for (GwtModule gwtModule : modules) {
            model.addElement(gwtModule);
            if (selectedModuleName == null || !selectedModuleName.equals(gwtModule.getQualifiedName())) continue;
            toSelect = gwtModule;
        }
        this.myModuleComboBox.setModel(model);
        this.myModuleComboBox.setRenderer(new ListCellRendererWrapper<GwtModule>(){

            public void customize(JList list, GwtModule value, int index, boolean selected, boolean hasFocus) {
                if (value != null) {
                    this.setText(value.getQualifiedName());
                    this.setIcon(GwtStudioIcons.Google_small);
                }
            }
        });
        this.myModuleComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GenerateCompilerReportDialog.this.updateView();
            }
        });
        if (toSelect != null) {
            this.myModuleComboBox.setSelectedItem(toSelect);
        } else {
            this.myModuleComboBox.setSelectedItem(0);
        }
        this.setOKButtonText("Generate");
        this.init();
        this.updateView();
    }

    @Nullable
    private CompileReportSource getSelectedSource() {
        GwtModule module = (GwtModule)this.myModuleComboBox.getSelectedItem();
        if (module == null) {
            return null;
        }
        GwtFacet facet = GwtFacet.getInstance(module);
        return facet != null ? new CompileReportSource(facet, module) : null;
    }

    @NotNull
    protected Action[] createActions() {
        Action[] actionArray = new Action[]{this.getCancelAction()};
        if (actionArray == null) {
            GenerateCompilerReportDialog.$$$reportNull$$$0(1);
        }
        return actionArray;
    }

    @NotNull
    protected Action[] createLeftSideActions() {
        Action[] actionArray = new Action[]{this.getOKAction(), this.myViewReportAction};
        if (actionArray == null) {
            GenerateCompilerReportDialog.$$$reportNull$$$0(2);
        }
        return actionArray;
    }

    protected void dispose() {
        CompileReportSource source = this.getSelectedSource();
        if (source != null) {
            PropertiesComponent.getInstance((Project)this.myProject).setValue(MODULE_PROPERTY_KEY, source.getGwtModule().getQualifiedName());
        }
        super.dispose();
    }

    private void updateView() {
        CompileReportSource source = this.getSelectedSource();
        this.setOKActionEnabled(source != null);
        this.myViewReportAction.setEnabled(source != null);
        if (source == null) {
            this.myInfoLabel.setText(" ");
            return;
        }
        CompileReportsHistory.GwtModuleCompileReport report = this.myReportsHistory.getCompileReport(source.getGwtModule().getQualifiedName());
        if (report == null || !GenerateCompilerReportDialog.getResultsFile(report).exists()) {
            this.myViewReportAction.setEnabled(false);
            this.myInfoLabel.setText(" ");
            return;
        }
        long delta = System.currentTimeMillis() - report.getGenerationTime();
        this.myInfoLabel.setText("Compile report was generated " + DateFormatUtil.formatDuration((long)delta) + " ago");
    }

    protected void doOKAction() {
        final CompileReportSource source = this.getSelectedSource();
        if (source != null) {
            CompilerManager manager = CompilerManager.getInstance((Project)this.myProject);
            CompileScope scope = manager.createModuleCompileScope(source.getFacet().getModule(), true);
            GwtBuildTargetScopeProvider.setGenerateCompileReportOption(scope, source);
            CompilerManager.getInstance((Project)this.myProject).make(scope, new CompileStatusNotification(){

                public void finished(boolean aborted, int errors, int warnings, CompileContext compileContext) {
                    if (!aborted && errors == 0) {
                        GenerateCompilerReportDialog.this.openCompileReport(source);
                    }
                }
            });
        }
        super.doOKAction();
    }

    private void openCompileReport(CompileReportSource source) {
        File indexFilePath;
        CompileReportsHistory.GwtModuleCompileReport report = this.myReportsHistory.getCompileReport(source.getGwtModule().getQualifiedName());
        if (report != null && (indexFilePath = GenerateCompilerReportDialog.getResultsFile(report)).exists()) {
            BrowserUtil.browse((URI)indexFilePath.toURI());
        }
    }

    private static File getResultsFile(CompileReportsHistory.GwtModuleCompileReport report) {
        File root = new File(report.getPath());
        return new File(root.getAbsolutePath(), FileUtil.toSystemDependentName((String)REPORT_FILE_PATH));
    }

    protected JComponent createCenterPanel() {
        return this.myMainPanel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/gwt/make/report/GenerateCompilerReportDialog";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/gwt/make/report/GenerateCompilerReportDialog";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createActions";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createLeftSideActions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JLabel jLabel;
        JComboBox jComboBox;
        JPanel jPanel;
        this.myMainPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(4, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myModuleComboBox = jComboBox = new JComboBox();
        jPanel.add(jComboBox, new GridConstraints(1, 0, 1, 1, 8, 1, 2, 0, null, null, null, 1));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(3, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JLabel jLabel2 = new JLabel();
        jLabel2.setText("GWT Module:");
        jLabel2.setDisplayedMnemonic('G');
        jLabel2.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myInfoLabel = jLabel = new JLabel();
        jLabel.setText(" ");
        jPanel.add((Component)jLabel, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        jLabel2.setLabelFor(jComboBox);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private class ViewReportAction
    extends DialogWrapper.DialogWrapperAction {
        public ViewReportAction() {
            super((DialogWrapper)GenerateCompilerReportDialog.this, "View Report");
        }

        protected void doAction(ActionEvent e) {
            CompileReportSource source = GenerateCompilerReportDialog.this.getSelectedSource();
            if (source != null) {
                GenerateCompilerReportDialog.this.openCompileReport(source);
                GenerateCompilerReportDialog.this.close(0);
            }
        }
    }
}

