/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gwt.uiBinder;

import com.intellij.gwt.uiBinder.UiBinderUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.XmlElementFactory;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xml.XmlSchemaProvider;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GwtUiXmlSchemaProvider
extends XmlSchemaProvider {
    private static final Key<XmlFile> UI_BINDER_PATCHED_SCHEMA_KEY = Key.create((String)"GWT_UI_BINDER_PATCHED_SCHEMA");
    private static final Key<XmlFile> CLIENT_UI_PATCHED_SCHEMA_KEY = Key.create((String)"GWT_CLIENT_UI_PATCHED_SCHEMA");
    private static final Set<String> RESERVED_PREFIXES = ContainerUtil.newTroveSet((Object[])new String[]{"client", "g", "ui"});
    private static final Map<String, Couple<String>> DEFAULT_SCHEMES = new HashMap<String, Couple<String>>();
    public static final String CLIENT_UI_NAMESPACE = "urn:import:com.google.gwt.user.client.ui";

    public XmlFile getSchema(@NotNull @NonNls String url, @Nullable Module module, @NotNull PsiFile baseFile) {
        if (url == null) {
            GwtUiXmlSchemaProvider.$$$reportNull$$$0(0);
        }
        if (baseFile == null) {
            GwtUiXmlSchemaProvider.$$$reportNull$$$0(1);
        }
        if (module == null) {
            return null;
        }
        return GwtUiXmlSchemaProvider.findDefaultSchema(url, module);
    }

    public static boolean isDefaultSchema(String namespace) {
        return DEFAULT_SCHEMES.containsKey(namespace);
    }

    @Nullable
    public static XmlFile findDefaultSchema(String url, Module module) {
        Couple<String> pair = DEFAULT_SCHEMES.get(url);
        if (pair != null) {
            String schemaPath = (String)pair.getSecond();
            PsiPackage psiPackage = JavaPsiFacade.getInstance((Project)module.getProject()).findPackage(PathUtil.getParentPath((String)schemaPath).replace('/', '.'));
            if (psiPackage != null) {
                GlobalSearchScope scope = GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module);
                String fileName = PathUtil.getFileName((String)schemaPath);
                for (PsiDirectory directory : psiPackage.getDirectories(scope)) {
                    PsiFile file = directory.findFile(fileName);
                    if (!(file instanceof XmlFile)) continue;
                    XmlFile xmlFile = (XmlFile)file;
                    if (url.equals("urn:ui:com.google.gwt.uibinder")) {
                        return GwtUiXmlSchemaProvider.getOrCreatePatchedUiBinderCopy(xmlFile);
                    }
                    if (url.equals(CLIENT_UI_NAMESPACE)) {
                        return GwtUiXmlSchemaProvider.getOrCreatePatchedClientUiCopy(xmlFile);
                    }
                    return xmlFile;
                }
            }
        }
        return null;
    }

    private static XmlFile getOrCreatePatchedUiBinderCopy(XmlFile xmlFile) {
        XmlFile patched = (XmlFile)xmlFile.getUserData(UI_BINDER_PATCHED_SCHEMA_KEY);
        if (patched == null) {
            XmlTag rootTag;
            patched = (XmlFile)xmlFile.copy();
            XmlDocument document = patched.getDocument();
            if (document != null && (rootTag = document.getRootTag()) != null) {
                for (XmlTag tag : rootTag.getSubTags()) {
                    if (!"UiBinder".equals(tag.getAttributeValue("name", "http://www.w3.org/2001/XMLSchema"))) continue;
                    for (XmlTag typeTag : tag.getSubTags()) {
                        if (!"complexType".equals(typeTag.getLocalName())) continue;
                        boolean baseMessagesInterfaceFound = false;
                        for (XmlTag attributeTag : typeTag.getSubTags()) {
                            if (!"attribute".equals(attributeTag.getLocalName())) continue;
                            attributeTag.setAttribute("form", "qualified");
                            if (baseMessagesInterfaceFound || !"baseMessagesInterface".equals(attributeTag.getAttributeValue("name"))) continue;
                            baseMessagesInterfaceFound = true;
                        }
                        if (baseMessagesInterfaceFound) continue;
                        XmlTag baseMessagesInterface = typeTag.createChildTag("attribute", rootTag.getNamespace(), null, false);
                        baseMessagesInterface.setAttribute("name", "baseMessagesInterface");
                        baseMessagesInterface.setAttribute("type", rootTag.getNamespacePrefix() + ":string");
                        baseMessagesInterface.setAttribute("form", "qualified");
                        typeTag.addSubTag(baseMessagesInterface, false);
                    }
                }
            }
            xmlFile.putUserData(UI_BINDER_PATCHED_SCHEMA_KEY, (Object)patched);
        }
        return patched;
    }

    private static XmlFile getOrCreatePatchedClientUiCopy(XmlFile xmlFile) {
        XmlFile patchedFile = (XmlFile)xmlFile.getUserData(CLIENT_UI_PATCHED_SCHEMA_KEY);
        if (patchedFile == null) {
            patchedFile = xmlFile;
            XmlTag originalRootTag = patchedFile.getRootTag();
            if (originalRootTag != null) {
                XmlTag rootTag;
                String namespace = originalRootTag.getNamespace();
                String namespacePrefix = originalRootTag.getNamespacePrefix();
                boolean appendListBox = true;
                for (XmlTag subTag : originalRootTag.getSubTags()) {
                    String nameAttributeValue = subTag.getAttributeValue("name", namespace);
                    if (!"ListBox".equals(nameAttributeValue)) continue;
                    appendListBox = false;
                }
                if (appendListBox && (rootTag = (patchedFile = (XmlFile)xmlFile.copy()).getRootTag()) != null) {
                    XmlElementFactory elementFactory = XmlElementFactory.getInstance((Project)xmlFile.getProject());
                    XmlTag subTag = elementFactory.createTagFromText((CharSequence)MessageFormat.format("<{0}:element name=\"ListBox\">  <{0}:complexType mixed=\"true\">    <{0}:anyAttribute processContents=\"lax\"/>    <{0}:choice minOccurs=\"0\" maxOccurs=\"unbounded\">      <{0}:element name=\"item\">        <{0}:complexType>          <{0}:attribute name=\"value\" type=\"{0}:string\"/>        </{0}:complexType>      </{0}:element>    </{0}:choice>  </{0}:complexType></{0}:element>", namespacePrefix));
                    rootTag.addSubTag(subTag, false);
                }
            }
            xmlFile.putUserData(CLIENT_UI_PATCHED_SCHEMA_KEY, (Object)patchedFile);
        }
        return patchedFile;
    }

    @NotNull
    public Set<String> getAvailableNamespaces(@NotNull XmlFile file, @Nullable String tagName) {
        if (file == null) {
            GwtUiXmlSchemaProvider.$$$reportNull$$$0(2);
        }
        if (tagName == null) {
            Set<String> set = DEFAULT_SCHEMES.keySet();
            if (set == null) {
                GwtUiXmlSchemaProvider.$$$reportNull$$$0(3);
            }
            return set;
        }
        for (Map.Entry<String, Couple<String>> entry : DEFAULT_SCHEMES.entrySet()) {
            if (!tagName.equals(entry.getValue().getFirst())) continue;
            Set<String> set = Collections.singleton(entry.getKey());
            if (set == null) {
                GwtUiXmlSchemaProvider.$$$reportNull$$$0(4);
            }
            return set;
        }
        Set<String> set = Collections.emptySet();
        if (set == null) {
            GwtUiXmlSchemaProvider.$$$reportNull$$$0(5);
        }
        return set;
    }

    public String getDefaultPrefix(@NotNull @NonNls String namespace, @NotNull XmlFile context) {
        Couple<String> pair;
        if (namespace == null) {
            GwtUiXmlSchemaProvider.$$$reportNull$$$0(6);
        }
        if (context == null) {
            GwtUiXmlSchemaProvider.$$$reportNull$$$0(7);
        }
        if ((pair = DEFAULT_SCHEMES.get(namespace)) != null) {
            return (String)pair.getFirst();
        }
        if (namespace.startsWith("urn:import:")) {
            return GwtUiXmlSchemaProvider.suggestPrefix(StringUtil.trimStart((String)namespace, (String)"urn:import:"));
        }
        return null;
    }

    private static String suggestPrefix(String packageName) {
        List names = StringUtil.split((String)packageName, (String)".");
        for (int i = names.size() - 1; i >= 0; --i) {
            String name = (String)names.get(i);
            if (RESERVED_PREFIXES.contains(name)) continue;
            return name;
        }
        return "x";
    }

    public boolean isAvailable(@NotNull XmlFile file) {
        if (file == null) {
            GwtUiXmlSchemaProvider.$$$reportNull$$$0(8);
        }
        return UiBinderUtil.isUiXmlFile(file);
    }

    static {
        DEFAULT_SCHEMES.put("urn:ui:com.google.gwt.uibinder", (Couple<String>)Couple.of((Object)"ui", (Object)"com/google/gwt/uibinder/resources/UiBinder.xsd"));
        DEFAULT_SCHEMES.put(CLIENT_UI_NAMESPACE, (Couple<String>)Couple.of((Object)"g", (Object)"com/google/gwt/uibinder/resources/com.google.gwt.user.client.ui.xsd"));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseFile";
                break;
            }
            case 2: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/gwt/uiBinder/GwtUiXmlSchemaProvider";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namespace";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/gwt/uiBinder/GwtUiXmlSchemaProvider";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getAvailableNamespaces";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getSchema";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getAvailableNamespaces";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultPrefix";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

