/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.android;

import com.android.repository.api.ProgressIndicator;
import com.android.repository.api.ProgressIndicatorAdapter;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Processor;
import com.intellij.util.containers.HashSet;
import com.intellij.util.containers.OrderedSet;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import net.n3.nanoxml.IXMLBuilder;
import org.jetbrains.android.compiler.artifact.AndroidArtifactSigningMode;
import org.jetbrains.android.util.AndroidCommonUtils;
import org.jetbrains.android.util.AndroidCompilerMessageKind;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.ModuleChunk;
import org.jetbrains.jps.android.AndroidBuildDataCache;
import org.jetbrains.jps.android.AndroidDependencyProcessor;
import org.jetbrains.jps.android.AndroidDependencyType;
import org.jetbrains.jps.android.AndroidJpsBundle;
import org.jetbrains.jps.android.AndroidPlatform;
import org.jetbrains.jps.android.ProGuardOptions;
import org.jetbrains.jps.android.builder.AndroidAarDepsBuildTarget;
import org.jetbrains.jps.android.model.AndroidApplicationArtifactType;
import org.jetbrains.jps.android.model.JpsAndroidApplicationArtifactProperties;
import org.jetbrains.jps.android.model.JpsAndroidModuleExtension;
import org.jetbrains.jps.android.model.JpsAndroidSdkProperties;
import org.jetbrains.jps.android.model.JpsAndroidSdkType;
import org.jetbrains.jps.android.model.impl.JpsAndroidFinalPackageElement;
import org.jetbrains.jps.android.model.impl.JpsAndroidModuleExtensionImpl;
import org.jetbrains.jps.builders.BuildTarget;
import org.jetbrains.jps.builders.java.JavaModuleBuildTargetType;
import org.jetbrains.jps.builders.storage.BuildDataPaths;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.incremental.ModuleBuildTarget;
import org.jetbrains.jps.incremental.ModuleLevelBuilder;
import org.jetbrains.jps.incremental.ProjectBuildException;
import org.jetbrains.jps.incremental.StopBuildException;
import org.jetbrains.jps.incremental.artifacts.ArtifactBuildTarget;
import org.jetbrains.jps.incremental.artifacts.impl.JpsArtifactUtil;
import org.jetbrains.jps.incremental.java.FormsParsing;
import org.jetbrains.jps.incremental.messages.BuildMessage;
import org.jetbrains.jps.incremental.messages.CompilerMessage;
import org.jetbrains.jps.incremental.storage.BuildDataManager;
import org.jetbrains.jps.model.JpsElement;
import org.jetbrains.jps.model.JpsProject;
import org.jetbrains.jps.model.JpsSimpleElement;
import org.jetbrains.jps.model.artifact.JpsArtifact;
import org.jetbrains.jps.model.artifact.JpsArtifactService;
import org.jetbrains.jps.model.artifact.elements.JpsPackagingElement;
import org.jetbrains.jps.model.java.JavaSourceRootType;
import org.jetbrains.jps.model.java.JpsJavaClasspathKind;
import org.jetbrains.jps.model.java.JpsJavaDependencyExtension;
import org.jetbrains.jps.model.java.JpsJavaDependencyScope;
import org.jetbrains.jps.model.java.JpsJavaExtensionService;
import org.jetbrains.jps.model.java.impl.JpsJavaDependenciesEnumerationHandler;
import org.jetbrains.jps.model.library.JpsLibrary;
import org.jetbrains.jps.model.library.JpsLibraryRoot;
import org.jetbrains.jps.model.library.JpsOrderRootType;
import org.jetbrains.jps.model.library.sdk.JpsSdk;
import org.jetbrains.jps.model.library.sdk.JpsSdkType;
import org.jetbrains.jps.model.module.JpsDependencyElement;
import org.jetbrains.jps.model.module.JpsLibraryDependency;
import org.jetbrains.jps.model.module.JpsModule;
import org.jetbrains.jps.model.module.JpsModuleDependency;
import org.jetbrains.jps.model.module.JpsModuleReference;
import org.jetbrains.jps.model.module.JpsModuleSourceRoot;
import org.jetbrains.jps.model.serialization.JpsModelSerializationDataService;
import org.jetbrains.jps.util.JpsPathUtil;

public class AndroidJpsUtil {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.jps.android.AndroidJpsUtil");
    @NonNls
    public static final String ANDROID_FACET_TYPE_ID = "android";
    @NonNls
    public static final String ANDROID_FACET_NAME = "Android";
    @NonNls
    public static final String ANDROID_STORAGE_DIR = "android";
    @NonNls
    private static final String RESOURCE_CACHE_STORAGE = "res_cache";
    @NonNls
    private static final String INTERMEDIATE_ARTIFACTS_STORAGE = "intermediate_artifacts";
    @NonNls
    public static final String GENERATED_RESOURCES_DIR_NAME = "generated_resources";
    @NonNls
    public static final String AAPT_GENERATED_SOURCE_ROOT_NAME = "aapt";
    @NonNls
    public static final String AIDL_GENERATED_SOURCE_ROOT_NAME = "aidl";
    @NonNls
    public static final String RENDERSCRIPT_GENERATED_SOURCE_ROOT_NAME = "rs";
    @NonNls
    public static final String BUILD_CONFIG_GENERATED_SOURCE_ROOT_NAME = "build_config";
    @NonNls
    private static final String GENERATED_SOURCES_FOLDER_NAME = "generated_sources";
    @NonNls
    private static final String PREPROCESSED_MANIFEST_FOLDER_NAME = "preprocessed_manifest";
    @NonNls
    private static final String COPIED_SOURCES_FOLDER_NAME = "copied_sources";
    @NonNls
    private static final String MANIFEST_TAG = "manifest";

    private AndroidJpsUtil() {
    }

    public static boolean shouldProcessDependenciesRecursively(JpsModule module) {
        return JpsJavaDependenciesEnumerationHandler.shouldProcessDependenciesRecursively((List)JpsJavaDependenciesEnumerationHandler.createHandlers(Collections.singletonList(module)));
    }

    @Nullable
    public static File getMainContentRoot(@NotNull JpsAndroidModuleExtension extension) throws IOException {
        JpsModule module;
        List contentRoots;
        if (extension == null) {
            AndroidJpsUtil.$$$reportNull$$$0(0);
        }
        if ((contentRoots = (module = extension.getModule()).getContentRootsList().getUrls()).size() == 0) {
            return null;
        }
        File manifestFile = extension.getManifestFile();
        if (manifestFile != null) {
            for (String rootUrl : contentRoots) {
                File root = JpsPathUtil.urlToFile((String)rootUrl);
                if (!FileUtil.isAncestor((File)root, (File)manifestFile, (boolean)true)) continue;
                return root;
            }
        }
        return JpsPathUtil.urlToFile((String)((String)contentRoots.get(0)));
    }

    public static void addMessages(@NotNull CompileContext context, @NotNull Map<AndroidCompilerMessageKind, List<String>> messages, @NotNull String builderName, @NotNull String entryName) {
        if (context == null) {
            AndroidJpsUtil.$$$reportNull$$$0(1);
        }
        if (messages == null) {
            AndroidJpsUtil.$$$reportNull$$$0(2);
        }
        if (builderName == null) {
            AndroidJpsUtil.$$$reportNull$$$0(3);
        }
        if (entryName == null) {
            AndroidJpsUtil.$$$reportNull$$$0(4);
        }
        for (Map.Entry<AndroidCompilerMessageKind, List<String>> entry : messages.entrySet()) {
            for (String message : entry.getValue()) {
                BuildMessage.Kind category;
                String filePath = null;
                int line = -1;
                Matcher matcher = AndroidCommonUtils.COMPILER_MESSAGE_PATTERN.matcher(message);
                if (matcher.matches()) {
                    filePath = matcher.group(1);
                    line = Integer.parseInt(matcher.group(2));
                }
                if ((category = AndroidJpsUtil.toBuildMessageKind(entry.getKey())) == null) continue;
                context.processMessage((BuildMessage)new CompilerMessage(builderName, category, '[' + entryName + "] " + message, filePath, -1L, -1L, -1L, (long)line, -1L));
            }
        }
    }

    @Nullable
    public static JpsAndroidModuleExtension getExtension(@NotNull JpsModule module) {
        if (module == null) {
            AndroidJpsUtil.$$$reportNull$$$0(5);
        }
        return (JpsAndroidModuleExtension)module.getContainer().getChild(JpsAndroidModuleExtensionImpl.KIND);
    }

    @NotNull
    public static String[] toPaths(@NotNull File[] files) {
        if (files == null) {
            AndroidJpsUtil.$$$reportNull$$$0(6);
        }
        String[] result = new String[files.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = files[i].getPath();
        }
        if (result == null) {
            AndroidJpsUtil.$$$reportNull$$$0(7);
        }
        return result;
    }

    @NotNull
    public static List<String> toPaths(@NotNull Collection<File> files) {
        if (files == null) {
            AndroidJpsUtil.$$$reportNull$$$0(8);
        }
        if (files.size() == 0) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                AndroidJpsUtil.$$$reportNull$$$0(9);
            }
            return list;
        }
        ArrayList<String> result = new ArrayList<String>(files.size());
        for (File file : files) {
            result.add(file.getPath());
        }
        ArrayList<String> arrayList = result;
        if (arrayList == null) {
            AndroidJpsUtil.$$$reportNull$$$0(10);
        }
        return arrayList;
    }

    @NotNull
    public static File getDirectoryForIntermediateArtifacts(@NotNull CompileContext context, @NotNull JpsModule module) {
        if (context == null) {
            AndroidJpsUtil.$$$reportNull$$$0(11);
        }
        if (module == null) {
            AndroidJpsUtil.$$$reportNull$$$0(12);
        }
        File file = AndroidJpsUtil.getDirectoryForIntermediateArtifacts(context.getProjectDescriptor().dataManager.getDataPaths(), module);
        if (file == null) {
            AndroidJpsUtil.$$$reportNull$$$0(13);
        }
        return file;
    }

    @NotNull
    public static File getDirectoryForIntermediateArtifacts(@NotNull BuildDataPaths dataPaths, @NotNull JpsModule module) {
        if (dataPaths == null) {
            AndroidJpsUtil.$$$reportNull$$$0(14);
        }
        if (module == null) {
            AndroidJpsUtil.$$$reportNull$$$0(15);
        }
        File file = new File(AndroidJpsUtil.getDirectoryForIntermediateArtifacts(dataPaths), module.getName());
        if (file == null) {
            AndroidJpsUtil.$$$reportNull$$$0(16);
        }
        return file;
    }

    @NotNull
    public static File getDirectoryForIntermediateArtifacts(@NotNull BuildDataPaths dataPaths) {
        if (dataPaths == null) {
            AndroidJpsUtil.$$$reportNull$$$0(17);
        }
        File androidStorage = new File(dataPaths.getDataStorageRoot(), "android");
        File file = new File(androidStorage, INTERMEDIATE_ARTIFACTS_STORAGE);
        if (file == null) {
            AndroidJpsUtil.$$$reportNull$$$0(18);
        }
        return file;
    }

    @Nullable
    public static File createDirIfNotExist(@NotNull File dir, @NotNull CompileContext context, @NotNull String compilerName) {
        if (dir == null) {
            AndroidJpsUtil.$$$reportNull$$$0(19);
        }
        if (context == null) {
            AndroidJpsUtil.$$$reportNull$$$0(20);
        }
        if (compilerName == null) {
            AndroidJpsUtil.$$$reportNull$$$0(21);
        }
        if (!dir.exists() && !dir.mkdirs()) {
            context.processMessage((BuildMessage)new CompilerMessage(compilerName, BuildMessage.Kind.ERROR, AndroidJpsBundle.message("android.jps.cannot.create.directory", dir.getPath())));
            return null;
        }
        return dir;
    }

    public static void addSubdirectories(@NotNull File baseDir, @NotNull Collection<String> result) {
        File[] children;
        if (baseDir == null) {
            AndroidJpsUtil.$$$reportNull$$$0(22);
        }
        if (result == null) {
            AndroidJpsUtil.$$$reportNull$$$0(23);
        }
        if ((children = baseDir.listFiles()) != null) {
            for (File child : children) {
                if (!child.isDirectory()) continue;
                result.add(child.getPath());
            }
        }
    }

    @NotNull
    public static Set<String> getExternalLibraries(@NotNull CompileContext context, @NotNull JpsModule module, @NotNull AndroidPlatform platform) {
        if (context == null) {
            AndroidJpsUtil.$$$reportNull$$$0(24);
        }
        if (module == null) {
            AndroidJpsUtil.$$$reportNull$$$0(25);
        }
        if (platform == null) {
            AndroidJpsUtil.$$$reportNull$$$0(26);
        }
        BuildDataPaths paths = context.getProjectDescriptor().dataManager.getDataPaths();
        Set<String> set = AndroidJpsUtil.getExternalLibraries(paths, module, platform, true, true, false);
        if (set == null) {
            AndroidJpsUtil.$$$reportNull$$$0(27);
        }
        return set;
    }

    @NotNull
    public static Set<String> getExternalLibraries(@NotNull BuildDataPaths paths, @NotNull JpsModule module, @Nullable AndroidPlatform platform, boolean resolveJars, boolean withAarDeps, boolean withPackagedAarDepsJar) {
        if (paths == null) {
            AndroidJpsUtil.$$$reportNull$$$0(28);
        }
        if (module == null) {
            AndroidJpsUtil.$$$reportNull$$$0(29);
        }
        HashSet result = new HashSet();
        AndroidDependencyProcessor processor = new AndroidDependencyProcessor((Set)result){
            final /* synthetic */ Set val$result;
            {
                this.val$result = set;
            }

            @Override
            public void processExternalLibrary(@NotNull File file) {
                if (file == null) {
                    1.$$$reportNull$$$0(0);
                }
                this.val$result.add(file.getPath());
            }

            @Override
            public boolean isToProcess(@NotNull AndroidDependencyType type) {
                if (type == null) {
                    1.$$$reportNull$$$0(1);
                }
                return type == AndroidDependencyType.EXTERNAL_LIBRARY;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "file";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "type";
                        break;
                    }
                }
                objectArray2[1] = "org/jetbrains/jps/android/AndroidJpsUtil$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "processExternalLibrary";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "isToProcess";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        AndroidJpsUtil.processClasspath(paths, module, processor, resolveJars, withAarDeps);
        if (platform != null) {
            AndroidJpsUtil.addAnnotationsJarIfNecessary(platform, (Set<String>)result);
        }
        if (withPackagedAarDepsJar) {
            result.add(AndroidAarDepsBuildTarget.getOutputFile(module, paths).getPath());
        }
        HashSet hashSet = result;
        if (hashSet == null) {
            AndroidJpsUtil.$$$reportNull$$$0(30);
        }
        return hashSet;
    }

    @NotNull
    public static Set<String> getProvidedLibraries(@NotNull BuildDataPaths paths, @NotNull JpsModule module) {
        if (paths == null) {
            AndroidJpsUtil.$$$reportNull$$$0(31);
        }
        if (module == null) {
            AndroidJpsUtil.$$$reportNull$$$0(32);
        }
        HashSet result = new HashSet();
        AndroidJpsUtil.processClasspath(paths, module, new AndroidDependencyProcessor((Set)result){
            final /* synthetic */ Set val$result;
            {
                this.val$result = set;
            }

            @Override
            public void processProvidedLibrary(@NotNull File file) {
                if (file == null) {
                    2.$$$reportNull$$$0(0);
                }
                this.val$result.add(file.getPath());
            }

            @Override
            public boolean isToProcess(@NotNull AndroidDependencyType type) {
                if (type == null) {
                    2.$$$reportNull$$$0(1);
                }
                return type == AndroidDependencyType.PROVIDED_LIBRARY;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "file";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "type";
                        break;
                    }
                }
                objectArray2[1] = "org/jetbrains/jps/android/AndroidJpsUtil$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "processProvidedLibrary";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "isToProcess";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, false, false);
        HashSet hashSet = result;
        if (hashSet == null) {
            AndroidJpsUtil.$$$reportNull$$$0(33);
        }
        return hashSet;
    }

    private static void addAnnotationsJarIfNecessary(@NotNull AndroidPlatform platform, @NotNull Set<String> libs) {
        if (platform == null) {
            AndroidJpsUtil.$$$reportNull$$$0(34);
        }
        if (libs == null) {
            AndroidJpsUtil.$$$reportNull$$$0(35);
        }
        if (platform.needToAddAnnotationsJarToClasspath()) {
            String sdkHomePath = platform.getSdk().getHomePath();
            String annotationsJarPath = FileUtil.toSystemIndependentName((String)sdkHomePath) + "/tools/support/annotations.jar";
            libs.add(annotationsJarPath);
        }
    }

    public static void processClasspath(@NotNull BuildDataPaths paths, @NotNull JpsModule module, @NotNull AndroidDependencyProcessor processor, boolean resolveJars, boolean withAarDeps) {
        if (paths == null) {
            AndroidJpsUtil.$$$reportNull$$$0(36);
        }
        if (module == null) {
            AndroidJpsUtil.$$$reportNull$$$0(37);
        }
        if (processor == null) {
            AndroidJpsUtil.$$$reportNull$$$0(38);
        }
        boolean recursive = AndroidJpsUtil.shouldProcessDependenciesRecursively(module);
        AndroidJpsUtil.processClasspath(paths, module, processor, (Set<String>)new HashSet(), false, recursive, resolveJars, withAarDeps);
    }

    private static void processClasspath(@NotNull BuildDataPaths paths, @NotNull JpsModule module, final @NotNull AndroidDependencyProcessor processor, @NotNull Set<String> visitedModules, boolean exportedLibrariesOnly, boolean recursive, boolean resolveJars, boolean withAarDeps) {
        JpsLibrary library;
        if (paths == null) {
            AndroidJpsUtil.$$$reportNull$$$0(39);
        }
        if (module == null) {
            AndroidJpsUtil.$$$reportNull$$$0(40);
        }
        if (processor == null) {
            AndroidJpsUtil.$$$reportNull$$$0(41);
        }
        if (visitedModules == null) {
            AndroidJpsUtil.$$$reportNull$$$0(42);
        }
        if (!visitedModules.add(module.getName())) {
            return;
        }
        if (processor.isToProcess(AndroidDependencyType.EXTERNAL_LIBRARY)) {
            for (JpsDependencyElement item : JpsJavaExtensionService.getInstance().getDependencies(module, JpsJavaClasspathKind.PRODUCTION_RUNTIME, exportedLibrariesOnly)) {
                if (!(item instanceof JpsLibraryDependency) || (library = ((JpsLibraryDependency)item).getLibrary()) == null || !withAarDeps && AndroidJpsUtil.getResDirAndJarsIfAar(library) != null) continue;
                for (Object root : library.getRoots(JpsOrderRootType.COMPILED)) {
                    File file = JpsPathUtil.urlToFile((String)root.getUrl());
                    if (resolveJars) {
                        AndroidJpsUtil.processClassFilesAndJarsRecursively(file, new Processor<File>(){

                            public boolean process(File file) {
                                processor.processExternalLibrary(file);
                                return true;
                            }
                        });
                        continue;
                    }
                    processor.processExternalLibrary(file);
                }
            }
        }
        if (processor.isToProcess(AndroidDependencyType.PROVIDED_LIBRARY)) {
            for (JpsDependencyElement item : module.getDependenciesList().getDependencies()) {
                if (!(item instanceof JpsLibraryDependency)) continue;
                library = ((JpsLibraryDependency)item).getLibrary();
                JpsJavaDependencyExtension extension = JpsJavaExtensionService.getInstance().getDependencyExtension(item);
                if (library == null || extension == null || extension.getScope() != JpsJavaDependencyScope.PROVIDED) continue;
                for (JpsLibraryRoot root : library.getRoots(JpsOrderRootType.COMPILED)) {
                    processor.processProvidedLibrary(JpsPathUtil.urlToFile((String)root.getUrl()));
                }
            }
        }
        for (JpsDependencyElement item : JpsJavaExtensionService.getInstance().getDependencies(module, JpsJavaClasspathKind.PRODUCTION_RUNTIME, false)) {
            JpsModule depModule;
            if (!(item instanceof JpsModuleDependency) || (depModule = ((JpsModuleDependency)item).getModule()) == null) continue;
            JpsAndroidModuleExtension depExtension = AndroidJpsUtil.getExtension(depModule);
            boolean depLibrary = depExtension != null && depExtension.isLibrary();
            File depClassDir = new ModuleBuildTarget(depModule, JavaModuleBuildTargetType.PRODUCTION).getOutputDir();
            if (depLibrary) {
                if (processor.isToProcess(AndroidDependencyType.ANDROID_LIBRARY_PACKAGE)) {
                    File intArtifactsDir = AndroidJpsUtil.getDirectoryForIntermediateArtifacts(paths, depModule);
                    File packagedClassesJar = new File(intArtifactsDir, "classes.jar");
                    processor.processAndroidLibraryPackage(packagedClassesJar, depModule);
                }
                if (processor.isToProcess(AndroidDependencyType.ANDROID_LIBRARY_OUTPUT_DIRECTORY) && depClassDir != null) {
                    processor.processAndroidLibraryOutputDirectory(depClassDir);
                }
            } else if (processor.isToProcess(AndroidDependencyType.JAVA_MODULE_OUTPUT_DIR) && depExtension == null && depClassDir != null) {
                processor.processJavaModuleOutputDirectory(depClassDir);
            }
            if (!recursive) continue;
            boolean newRecursive = AndroidJpsUtil.shouldProcessDependenciesRecursively(depModule);
            AndroidJpsUtil.processClasspath(paths, depModule, processor, visitedModules, !depLibrary || exportedLibrariesOnly, newRecursive, resolveJars, withAarDeps);
        }
    }

    public static void processClassFilesAndJarsRecursively(@NotNull File root, final @NotNull Processor<File> processor) {
        if (root == null) {
            AndroidJpsUtil.$$$reportNull$$$0(43);
        }
        if (processor == null) {
            AndroidJpsUtil.$$$reportNull$$$0(44);
        }
        FileUtil.processFilesRecursively((File)root, (Processor)new Processor<File>(){

            public boolean process(File file) {
                String fileName;
                return !file.isFile() || !FileUtilRt.extensionEquals((String)(fileName = file.getName()), (String)"jar") && !FileUtilRt.extensionEquals((String)fileName, (String)"class") || processor.process((Object)file);
            }
        });
    }

    @Nullable
    public static Pair<IAndroidTarget, AndroidSdkHandler> getAndroidTarget(@NotNull JpsSdk<JpsSimpleElement<JpsAndroidSdkProperties>> sdk, @Nullable CompileContext context, String builderName) {
        RepoLogger log;
        JpsAndroidSdkProperties sdkProperties;
        String targetHashString;
        if (sdk == null) {
            AndroidJpsUtil.$$$reportNull$$$0(45);
        }
        if ((targetHashString = (sdkProperties = (JpsAndroidSdkProperties)((JpsSimpleElement)sdk.getSdkProperties()).getData()).getBuildTargetHashString()) == null) {
            if (context != null) {
                context.processMessage((BuildMessage)new CompilerMessage(builderName, BuildMessage.Kind.ERROR, "Cannot parse SDK " + sdk.getParent().getName() + ": build target is not specified"));
            }
            return null;
        }
        AndroidSdkHandler sdkHandler = AndroidSdkHandler.getInstance((File)new File(sdk.getHomePath()));
        IAndroidTarget target = sdkHandler.getAndroidTargetManager((ProgressIndicator)(log = new RepoLogger())).getTargetFromHashString(targetHashString, (ProgressIndicator)log);
        if (target == null) {
            if (context != null) {
                context.processMessage((BuildMessage)new CompilerMessage(builderName, BuildMessage.Kind.ERROR, "Cannot parse SDK '" + sdk.getParent().getName() + "': unknown target " + targetHashString));
            }
            return null;
        }
        return Pair.create((Object)target, (Object)sdkHandler);
    }

    @Nullable
    public static BuildMessage.Kind toBuildMessageKind(@NotNull AndroidCompilerMessageKind kind) {
        if (kind == null) {
            AndroidJpsUtil.$$$reportNull$$$0(46);
        }
        switch (kind) {
            case ERROR: {
                return BuildMessage.Kind.ERROR;
            }
            case INFORMATION: {
                return BuildMessage.Kind.INFO;
            }
            case WARNING: {
                return BuildMessage.Kind.WARNING;
            }
        }
        LOG.error("unknown AndroidCompilerMessageKind object " + kind);
        return null;
    }

    public static void reportExceptionError(@NotNull CompileContext context, @Nullable String filePath, @NotNull Exception exception, @NotNull String builderName) {
        String message;
        if (context == null) {
            AndroidJpsUtil.$$$reportNull$$$0(47);
        }
        if (exception == null) {
            AndroidJpsUtil.$$$reportNull$$$0(48);
        }
        if (builderName == null) {
            AndroidJpsUtil.$$$reportNull$$$0(49);
        }
        if ((message = exception.getMessage()) != null) {
            context.processMessage((BuildMessage)new CompilerMessage(builderName, BuildMessage.Kind.ERROR, message, filePath));
            LOG.debug((Throwable)exception);
        } else {
            context.processMessage((BuildMessage)new CompilerMessage(builderName, (Throwable)exception));
        }
    }

    public static ModuleLevelBuilder.ExitCode handleException(@NotNull CompileContext context, @NotNull Exception e, @NotNull String builderName, @Nullable Logger logger) throws ProjectBuildException {
        if (context == null) {
            AndroidJpsUtil.$$$reportNull$$$0(50);
        }
        if (e == null) {
            AndroidJpsUtil.$$$reportNull$$$0(51);
        }
        if (builderName == null) {
            AndroidJpsUtil.$$$reportNull$$$0(52);
        }
        if (logger != null) {
            logger.info((Throwable)e);
        }
        context.processMessage((BuildMessage)new CompilerMessage(builderName, (Throwable)e));
        throw new StopBuildException();
    }

    @Nullable
    public static File getManifestFileForCompilationPath(@NotNull JpsAndroidModuleExtension extension) {
        if (extension == null) {
            AndroidJpsUtil.$$$reportNull$$$0(53);
        }
        return extension.useCustomManifestForCompilation() ? extension.getManifestFileForCompilation() : extension.getManifestFile();
    }

    @Nullable
    public static AndroidPlatform getAndroidPlatform(@NotNull JpsModule module, @Nullable CompileContext context, String builderName) {
        JpsSdk sdk;
        if (module == null) {
            AndroidJpsUtil.$$$reportNull$$$0(54);
        }
        if ((sdk = module.getSdk((JpsSdkType)JpsAndroidSdkType.INSTANCE)) == null) {
            if (context != null) {
                context.processMessage((BuildMessage)new CompilerMessage(builderName, BuildMessage.Kind.ERROR, AndroidJpsBundle.message("android.jps.errors.sdk.not.specified", module.getName())));
            }
            return null;
        }
        Pair<IAndroidTarget, AndroidSdkHandler> pair = AndroidJpsUtil.getAndroidTarget((JpsSdk<JpsSimpleElement<JpsAndroidSdkProperties>>)sdk, context, builderName);
        if (pair == null) {
            if (context != null) {
                context.processMessage((BuildMessage)new CompilerMessage(builderName, BuildMessage.Kind.ERROR, AndroidJpsBundle.message("android.jps.errors.sdk.invalid", module.getName())));
            }
            return null;
        }
        return new AndroidPlatform((JpsSdk<JpsSimpleElement<JpsAndroidSdkProperties>>)sdk, (IAndroidTarget)pair.getFirst(), (AndroidSdkHandler)pair.getSecond());
    }

    @NotNull
    public static String[] collectResourceDirsForCompilation(@NotNull JpsAndroidModuleExtension extension, boolean withCacheDirs, @NotNull CompileContext context, boolean checkExistence) {
        if (extension == null) {
            AndroidJpsUtil.$$$reportNull$$$0(55);
        }
        if (context == null) {
            AndroidJpsUtil.$$$reportNull$$$0(56);
        }
        BuildDataPaths dataPaths = context.getProjectDescriptor().dataManager.getDataPaths();
        String[] stringArray = AndroidJpsUtil.collectResourceDirsForCompilation(extension, withCacheDirs, dataPaths, checkExistence);
        if (stringArray == null) {
            AndroidJpsUtil.$$$reportNull$$$0(57);
        }
        return stringArray;
    }

    @NotNull
    public static String[] collectResourceDirsForCompilation(@NotNull JpsAndroidModuleExtension extension, boolean withCacheDirs, @NotNull BuildDataPaths dataPaths, boolean checkExistence) {
        if (extension == null) {
            AndroidJpsUtil.$$$reportNull$$$0(58);
        }
        if (dataPaths == null) {
            AndroidJpsUtil.$$$reportNull$$$0(59);
        }
        OrderedSet result = new OrderedSet();
        AndroidJpsUtil.addCompilableResourceDirsForModule(extension, withCacheDirs, dataPaths, (Collection<String>)result, checkExistence);
        for (JpsAndroidModuleExtension depExtension : AndroidJpsUtil.getAllAndroidDependencies(extension.getModule(), true)) {
            AndroidJpsUtil.addCompilableResourceDirsForModule(depExtension, withCacheDirs, dataPaths, (Collection<String>)result, checkExistence);
        }
        String[] stringArray = ArrayUtil.toStringArray((Collection)result);
        if (stringArray == null) {
            AndroidJpsUtil.$$$reportNull$$$0(60);
        }
        return stringArray;
    }

    private static void addCompilableResourceDirsForModule(JpsAndroidModuleExtension extension, boolean withCacheDirs, BuildDataPaths dataPaths, Collection<String> result, boolean checkExistence) {
        if (withCacheDirs) {
            File resourcesCacheDir = AndroidJpsUtil.getResourcesCacheDir(extension.getModule(), dataPaths);
            if (!checkExistence || resourcesCacheDir.exists()) {
                result.add(resourcesCacheDir.getPath());
            }
        }
        for (File resOverlayDir : extension.getResourceOverlayDirs()) {
            if (resOverlayDir == null || checkExistence && !resOverlayDir.exists()) continue;
            result.add(resOverlayDir.getPath());
        }
        File resDir = AndroidJpsUtil.getResourceDirForCompilationPath(extension);
        if (resDir != null && (!checkExistence || resDir.exists())) {
            result.add(resDir.getPath());
        }
        File generatedResourcesStorage = AndroidJpsUtil.getGeneratedResourcesStorage(extension.getModule(), dataPaths);
        if (!checkExistence || generatedResourcesStorage.exists()) {
            result.add(generatedResourcesStorage.getPath());
        }
        AndroidJpsUtil.collectResDirectoriesFromAarDeps(extension.getModule(), result);
    }

    @Nullable
    public static File getResourceDirForCompilationPath(@NotNull JpsAndroidModuleExtension extension) {
        if (extension == null) {
            AndroidJpsUtil.$$$reportNull$$$0(61);
        }
        return extension.useCustomResFolderForCompilation() ? extension.getResourceDirForCompilation() : extension.getResourceDir();
    }

    @NotNull
    public static List<JpsAndroidModuleExtension> getAllAndroidDependencies(@NotNull JpsModule module, boolean librariesOnly) {
        if (module == null) {
            AndroidJpsUtil.$$$reportNull$$$0(62);
        }
        List<JpsAndroidModuleExtension> list = AndroidBuildDataCache.getInstance().getAllAndroidDependencies(module, librariesOnly);
        if (list == null) {
            AndroidJpsUtil.$$$reportNull$$$0(63);
        }
        return list;
    }

    public static boolean isLightBuild(@NotNull CompileContext context) {
        String typeId;
        if (context == null) {
            AndroidJpsUtil.$$$reportNull$$$0(64);
        }
        return (typeId = AndroidJpsUtil.getRunConfigurationTypeId(context)) != null && AndroidCommonUtils.isTestConfiguration((String)typeId);
    }

    @Nullable
    public static String getRunConfigurationTypeId(@NotNull CompileContext context) {
        if (context == null) {
            AndroidJpsUtil.$$$reportNull$$$0(65);
        }
        return context.getBuilderParameter("RUN_CONFIGURATION_TYPE_ID");
    }

    public static boolean isReleaseBuild(@NotNull CompileContext context) {
        if (context == null) {
            AndroidJpsUtil.$$$reportNull$$$0(66);
        }
        if (Boolean.parseBoolean(context.getBuilderParameter("RELEASE_BUILD_KEY"))) {
            return true;
        }
        for (JpsArtifact artifact : AndroidJpsUtil.getAndroidArtifactsToBuild(context)) {
            AndroidArtifactSigningMode signingMode;
            JpsElement props = artifact.getProperties();
            if (!(props instanceof JpsAndroidApplicationArtifactProperties) || (signingMode = ((JpsAndroidApplicationArtifactProperties)props).getSigningMode()) == AndroidArtifactSigningMode.DEBUG || signingMode == AndroidArtifactSigningMode.DEBUG_WITH_CUSTOM_CERTIFICATE) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public static List<JpsArtifact> getAndroidArtifactsToBuild(@NotNull CompileContext context) {
        if (context == null) {
            AndroidJpsUtil.$$$reportNull$$$0(67);
        }
        List artifacts = JpsArtifactService.getInstance().getArtifacts(context.getProjectDescriptor().getProject());
        ArrayList<JpsArtifact> result = new ArrayList<JpsArtifact>();
        for (JpsArtifact artifact : artifacts) {
            if (!(artifact.getArtifactType() instanceof AndroidApplicationArtifactType) || !context.getScope().isAffected((BuildTarget)new ArtifactBuildTarget(artifact))) continue;
            result.add(artifact);
        }
        ArrayList<JpsArtifact> arrayList = result;
        if (arrayList == null) {
            AndroidJpsUtil.$$$reportNull$$$0(68);
        }
        return arrayList;
    }

    @NotNull
    public static File getResourcesCacheDir(@NotNull JpsModule module, @NotNull BuildDataPaths dataPaths) {
        if (module == null) {
            AndroidJpsUtil.$$$reportNull$$$0(69);
        }
        if (dataPaths == null) {
            AndroidJpsUtil.$$$reportNull$$$0(70);
        }
        File androidStorage = new File(dataPaths.getDataStorageRoot(), "android");
        File file = new File(new File(androidStorage, RESOURCE_CACHE_STORAGE), module.getName());
        if (file == null) {
            AndroidJpsUtil.$$$reportNull$$$0(71);
        }
        return file;
    }

    @NotNull
    public static File[] getSourceRootsForModuleAndDependencies(@NotNull JpsModule rootModule) {
        if (rootModule == null) {
            AndroidJpsUtil.$$$reportNull$$$0(72);
        }
        HashSet result = new HashSet();
        for (JpsModule module : AndroidJpsUtil.getRuntimeModuleDeps(rootModule)) {
            JpsAndroidModuleExtension extension = AndroidJpsUtil.getExtension(module);
            File resDir = null;
            File resDirForCompilation = null;
            if (extension != null) {
                resDir = extension.getResourceDir();
                resDirForCompilation = extension.getResourceDirForCompilation();
            }
            for (JpsModuleSourceRoot root : module.getSourceRoots()) {
                File rootDir = JpsPathUtil.urlToFile((String)root.getUrl());
                if (!JavaSourceRootType.SOURCE.equals(root.getRootType()) && (!JavaSourceRootType.TEST_SOURCE.equals(root.getRootType()) || extension == null || !extension.isPackTestCode()) || FileUtil.filesEqual((File)rootDir, (File)resDir) || rootDir.equals(resDirForCompilation)) continue;
                result.add(rootDir);
            }
        }
        File[] fileArray = result.toArray(new File[result.size()]);
        if (fileArray == null) {
            AndroidJpsUtil.$$$reportNull$$$0(73);
        }
        return fileArray;
    }

    @NotNull
    public static File[] getJavaOutputRootsForModuleAndDependencies(@NotNull JpsModule rootModule) {
        if (rootModule == null) {
            AndroidJpsUtil.$$$reportNull$$$0(74);
        }
        HashSet result = new HashSet();
        for (JpsModule module : AndroidJpsUtil.getRuntimeModuleDeps(rootModule)) {
            File testOutputDir;
            JpsAndroidModuleExtension extension = AndroidJpsUtil.getExtension(module);
            File outputDir = JpsJavaExtensionService.getInstance().getOutputDirectory(module, false);
            if (outputDir != null) {
                result.add(outputDir);
            }
            if (extension == null || !extension.isPackTestCode() || (testOutputDir = JpsJavaExtensionService.getInstance().getOutputDirectory(module, true)) == null) continue;
            result.add(testOutputDir);
        }
        File[] fileArray = result.toArray(new File[result.size()]);
        if (fileArray == null) {
            AndroidJpsUtil.$$$reportNull$$$0(75);
        }
        return fileArray;
    }

    private static Set<JpsModule> getRuntimeModuleDeps(JpsModule rootModule) {
        return JpsJavaExtensionService.getInstance().enumerateDependencies(Collections.singletonList(rootModule)).recursively().runtimeOnly().getModules();
    }

    @Nullable
    public static String getApkPath(@NotNull JpsAndroidModuleExtension extension, @NotNull File outputDirForPackagedArtifacts) {
        if (extension == null) {
            AndroidJpsUtil.$$$reportNull$$$0(76);
        }
        if (outputDirForPackagedArtifacts == null) {
            AndroidJpsUtil.$$$reportNull$$$0(77);
        }
        String apkRelativePath = extension.getApkRelativePath();
        JpsModule module = extension.getModule();
        if (apkRelativePath == null || apkRelativePath.length() == 0) {
            return new File(outputDirForPackagedArtifacts, AndroidJpsUtil.getApkName(module)).getPath();
        }
        File moduleBaseDirectory = JpsModelSerializationDataService.getBaseDirectory((JpsModule)module);
        return moduleBaseDirectory != null ? FileUtil.toSystemDependentName((String)(moduleBaseDirectory.getAbsolutePath() + apkRelativePath)) : null;
    }

    @NotNull
    public static String getApkName(@NotNull JpsModule module) {
        if (module == null) {
            AndroidJpsUtil.$$$reportNull$$$0(78);
        }
        String string = module.getName() + ".apk";
        if (string == null) {
            AndroidJpsUtil.$$$reportNull$$$0(79);
        }
        return string;
    }

    @NotNull
    public static File getGeneratedSourcesStorage(@NotNull JpsModule module, BuildDataManager dataManager) {
        if (module == null) {
            AndroidJpsUtil.$$$reportNull$$$0(80);
        }
        File file = AndroidJpsUtil.getGeneratedSourcesStorage(module, dataManager.getDataPaths());
        if (file == null) {
            AndroidJpsUtil.$$$reportNull$$$0(81);
        }
        return file;
    }

    @NotNull
    public static File getGeneratedSourcesStorage(@NotNull JpsModule module, BuildDataPaths dataPaths) {
        if (module == null) {
            AndroidJpsUtil.$$$reportNull$$$0(82);
        }
        File targetDataRoot = dataPaths.getTargetDataRoot((BuildTarget)new ModuleBuildTarget(module, JavaModuleBuildTargetType.PRODUCTION));
        File file = AndroidJpsUtil.getStorageDir(targetDataRoot, GENERATED_SOURCES_FOLDER_NAME);
        if (file == null) {
            AndroidJpsUtil.$$$reportNull$$$0(83);
        }
        return file;
    }

    @NotNull
    public static File getPreprocessedManifestDirectory(@NotNull JpsModule module, @NotNull BuildDataPaths dataPaths) {
        if (module == null) {
            AndroidJpsUtil.$$$reportNull$$$0(84);
        }
        if (dataPaths == null) {
            AndroidJpsUtil.$$$reportNull$$$0(85);
        }
        File androidStorage = new File(dataPaths.getDataStorageRoot(), "android");
        File file = new File(new File(androidStorage, PREPROCESSED_MANIFEST_FOLDER_NAME), module.getName());
        if (file == null) {
            AndroidJpsUtil.$$$reportNull$$$0(86);
        }
        return file;
    }

    @Nullable
    public static File getPreprocessedManifestFile(@NotNull JpsAndroidModuleExtension extension, @NotNull BuildDataPaths dataPaths) {
        if (extension == null) {
            AndroidJpsUtil.$$$reportNull$$$0(87);
        }
        if (dataPaths == null) {
            AndroidJpsUtil.$$$reportNull$$$0(88);
        }
        if (extension.isLibrary() || !extension.isManifestMergingEnabled()) {
            return AndroidJpsUtil.getManifestFileForCompilationPath(extension);
        }
        File dir = AndroidJpsUtil.getPreprocessedManifestDirectory(extension.getModule(), dataPaths);
        return new File(dir, "AndroidManifest.xml");
    }

    @NotNull
    public static File getCopiedSourcesStorage(@NotNull JpsModule module, @NotNull BuildDataPaths dataPaths) {
        if (module == null) {
            AndroidJpsUtil.$$$reportNull$$$0(89);
        }
        if (dataPaths == null) {
            AndroidJpsUtil.$$$reportNull$$$0(90);
        }
        File targetDataRoot = dataPaths.getTargetDataRoot((BuildTarget)new ModuleBuildTarget(module, JavaModuleBuildTargetType.PRODUCTION));
        File file = AndroidJpsUtil.getStorageDir(targetDataRoot, COPIED_SOURCES_FOLDER_NAME);
        if (file == null) {
            AndroidJpsUtil.$$$reportNull$$$0(91);
        }
        return file;
    }

    @NotNull
    public static File getGeneratedResourcesStorage(@NotNull JpsModule module, BuildDataManager dataManager) {
        if (module == null) {
            AndroidJpsUtil.$$$reportNull$$$0(92);
        }
        File file = AndroidJpsUtil.getGeneratedResourcesStorage(module, dataManager.getDataPaths());
        if (file == null) {
            AndroidJpsUtil.$$$reportNull$$$0(93);
        }
        return file;
    }

    @NotNull
    private static File getGeneratedResourcesStorage(@NotNull JpsModule module, @NotNull BuildDataPaths dataPaths) {
        if (module == null) {
            AndroidJpsUtil.$$$reportNull$$$0(94);
        }
        if (dataPaths == null) {
            AndroidJpsUtil.$$$reportNull$$$0(95);
        }
        File targetDataRoot = dataPaths.getTargetDataRoot((BuildTarget)new ModuleBuildTarget(module, JavaModuleBuildTargetType.PRODUCTION));
        File file = AndroidJpsUtil.getStorageDir(targetDataRoot, GENERATED_RESOURCES_DIR_NAME);
        if (file == null) {
            AndroidJpsUtil.$$$reportNull$$$0(96);
        }
        return file;
    }

    @NotNull
    public static File getStorageFile(@NotNull File dataStorageRoot, @NotNull String storageName) {
        if (dataStorageRoot == null) {
            AndroidJpsUtil.$$$reportNull$$$0(97);
        }
        if (storageName == null) {
            AndroidJpsUtil.$$$reportNull$$$0(98);
        }
        File file = new File(AndroidJpsUtil.getStorageDir(dataStorageRoot, storageName), storageName);
        if (file == null) {
            AndroidJpsUtil.$$$reportNull$$$0(99);
        }
        return file;
    }

    @NotNull
    public static File getStorageDir(@NotNull File dataStorageRoot, @NotNull String storageName) {
        if (dataStorageRoot == null) {
            AndroidJpsUtil.$$$reportNull$$$0(100);
        }
        if (storageName == null) {
            AndroidJpsUtil.$$$reportNull$$$0(101);
        }
        File file = new File(new File(dataStorageRoot, "android"), storageName);
        if (file == null) {
            AndroidJpsUtil.$$$reportNull$$$0(102);
        }
        return file;
    }

    @Nullable
    private static Properties readPropertyFile(@NotNull File file) {
        if (file == null) {
            AndroidJpsUtil.$$$reportNull$$$0(103);
        }
        Properties properties = new Properties();
        try {
            properties.load(new FileInputStream(file));
            return properties;
        }
        catch (IOException e) {
            LOG.info((Throwable)e);
            return null;
        }
    }

    @Nullable
    public static Pair<String, File> getProjectPropertyValue(@NotNull JpsAndroidModuleExtension extension, @NotNull String propertyKey) {
        String value;
        Properties properties;
        File root;
        if (extension == null) {
            AndroidJpsUtil.$$$reportNull$$$0(104);
        }
        if (propertyKey == null) {
            AndroidJpsUtil.$$$reportNull$$$0(105);
        }
        try {
            root = AndroidJpsUtil.getMainContentRoot(extension);
        }
        catch (IOException e) {
            return null;
        }
        if (root == null) {
            return null;
        }
        File projectProperties = new File(root, "project.properties");
        if (projectProperties.exists() && (properties = AndroidJpsUtil.readPropertyFile(projectProperties)) != null && (value = properties.getProperty(propertyKey)) != null) {
            return Pair.create((Object)value, (Object)projectProperties);
        }
        return null;
    }

    @NotNull
    public static Set<String> getGenDirs(@NotNull JpsAndroidModuleExtension extension) throws IOException {
        if (extension == null) {
            AndroidJpsUtil.$$$reportNull$$$0(106);
        }
        HashSet result = new HashSet();
        File dir = extension.getAaptGenDir();
        if (dir != null) {
            result.add(dir.getPath());
        }
        if ((dir = extension.getAidlGenDir()) != null) {
            result.add(dir.getPath());
        }
        HashSet hashSet = result;
        if (hashSet == null) {
            AndroidJpsUtil.$$$reportNull$$$0(107);
        }
        return hashSet;
    }

    @Nullable
    public static JpsAndroidModuleExtension getPackagedFacet(@NotNull JpsArtifact artifact) {
        List<JpsAndroidModuleExtension> facets;
        if (artifact == null) {
            AndroidJpsUtil.$$$reportNull$$$0(108);
        }
        return (facets = AndroidJpsUtil.getAllPackagedFacets(artifact)).size() == 1 ? facets.get(0) : null;
    }

    @NotNull
    public static List<JpsAndroidModuleExtension> getAllPackagedFacets(JpsArtifact artifact) {
        final ArrayList<JpsAndroidModuleExtension> extensions = new ArrayList<JpsAndroidModuleExtension>();
        JpsArtifactUtil.processPackagingElements((JpsPackagingElement)artifact.getRootElement(), (Processor)new Processor<JpsPackagingElement>(){

            public boolean process(JpsPackagingElement element) {
                if (element instanceof JpsAndroidFinalPackageElement) {
                    JpsAndroidModuleExtension extension;
                    JpsModuleReference reference = ((JpsAndroidFinalPackageElement)element).getModuleReference();
                    JpsModule module = reference != null ? (JpsModule)reference.resolve() : null;
                    JpsAndroidModuleExtension jpsAndroidModuleExtension = extension = module != null ? AndroidJpsUtil.getExtension(module) : null;
                    if (extension != null) {
                        extensions.add(extension);
                    }
                }
                return true;
            }
        });
        ArrayList<JpsAndroidModuleExtension> arrayList = extensions;
        if (arrayList == null) {
            AndroidJpsUtil.$$$reportNull$$$0(109);
        }
        return arrayList;
    }

    @NotNull
    private static File[] toFiles(@NotNull String[] paths) {
        if (paths == null) {
            AndroidJpsUtil.$$$reportNull$$$0(110);
        }
        File[] files = new File[paths.length];
        for (int i = 0; i < paths.length; ++i) {
            files[i] = new File(paths[i]);
        }
        if (files == null) {
            AndroidJpsUtil.$$$reportNull$$$0(111);
        }
        return files;
    }

    public static ProGuardOptions getProGuardConfigIfShouldRun(@NotNull CompileContext context, @NotNull JpsAndroidModuleExtension extension) throws IOException {
        String[] paths;
        if (context == null) {
            AndroidJpsUtil.$$$reportNull$$$0(112);
        }
        if (extension == null) {
            AndroidJpsUtil.$$$reportNull$$$0(113);
        }
        if (extension.isRunProguard()) {
            return new ProGuardOptions(extension.getProguardConfigFiles(extension.getModule()));
        }
        String cfgPathsStrFromContext = context.getBuilderParameter("ANDROID_PROGUARD_CFG_PATHS");
        if (cfgPathsStrFromContext != null && cfgPathsStrFromContext.length() > 0 && (paths = cfgPathsStrFromContext.split(File.pathSeparator)).length > 0) {
            File[] files = AndroidJpsUtil.toFiles(paths);
            return new ProGuardOptions(Arrays.asList(files));
        }
        for (JpsArtifact artifact : AndroidJpsUtil.getAndroidArtifactsToBuild(context)) {
            JpsAndroidApplicationArtifactProperties androidProps;
            JpsElement props;
            JpsAndroidModuleExtension facetFromArtifact = AndroidJpsUtil.getPackagedFacet(artifact);
            JpsModule moduleFromArtifact = facetFromArtifact != null ? facetFromArtifact.getModule() : null;
            if (moduleFromArtifact == null || !moduleFromArtifact.equals(extension.getModule()) || !((props = artifact.getProperties()) instanceof JpsAndroidApplicationArtifactProperties) || !(androidProps = (JpsAndroidApplicationArtifactProperties)props).isRunProGuard()) continue;
            List<String> cfgFileUrls = androidProps.getProGuardCfgFiles(moduleFromArtifact);
            List<File> cfgPaths = cfgFileUrls != null ? AndroidJpsUtil.urlsToFiles(cfgFileUrls) : null;
            return new ProGuardOptions(cfgPaths);
        }
        return null;
    }

    @NotNull
    public static List<File> urlsToFiles(@NotNull List<String> urls) {
        if (urls == null) {
            AndroidJpsUtil.$$$reportNull$$$0(114);
        }
        if (urls.isEmpty()) {
            List<File> list = Collections.emptyList();
            if (list == null) {
                AndroidJpsUtil.$$$reportNull$$$0(115);
            }
            return list;
        }
        ArrayList<File> result = new ArrayList<File>();
        for (String path : urls) {
            result.add(JpsPathUtil.urlToFile((String)path));
        }
        ArrayList<File> arrayList = result;
        if (arrayList == null) {
            AndroidJpsUtil.$$$reportNull$$$0(116);
        }
        return arrayList;
    }

    public static boolean isAndroidProjectWithoutGradleFacet(@NotNull JpsProject project) {
        if (project == null) {
            AndroidJpsUtil.$$$reportNull$$$0(117);
        }
        return AndroidJpsUtil.isAndroidProjectWithoutGradleFacet(project.getModules());
    }

    public static boolean isAndroidProjectWithoutGradleFacet(@NotNull ModuleChunk chunk) {
        if (chunk == null) {
            AndroidJpsUtil.$$$reportNull$$$0(118);
        }
        return AndroidJpsUtil.isAndroidProjectWithoutGradleFacet(chunk.getModules());
    }

    private static boolean isAndroidProjectWithoutGradleFacet(@NotNull Collection<JpsModule> modules) {
        if (modules == null) {
            AndroidJpsUtil.$$$reportNull$$$0(119);
        }
        boolean hasAndroidFacet = false;
        for (JpsModule module : modules) {
            JpsAndroidModuleExtension androidFacet = AndroidJpsUtil.getExtension(module);
            if (androidFacet == null) continue;
            hasAndroidFacet = true;
            if (!androidFacet.isGradleProject()) continue;
            return false;
        }
        return hasAndroidFacet;
    }

    public static void collectRTextFilesFromAarDeps(@NotNull JpsModule module, @NotNull Collection<Pair<String, String>> result) {
        if (module == null) {
            AndroidJpsUtil.$$$reportNull$$$0(120);
        }
        if (result == null) {
            AndroidJpsUtil.$$$reportNull$$$0(121);
        }
        ArrayList<String> resDirs = new ArrayList<String>();
        AndroidJpsUtil.collectResDirectoriesFromAarDeps(module, resDirs);
        for (String dir : resDirs) {
            File parent = new File(dir).getParentFile();
            File manifestFile = new File(parent, "AndroidManifest.xml");
            File rTxt = new File(parent, "R.txt");
            if (!manifestFile.exists() || !rTxt.exists()) continue;
            try {
                String packageName = AndroidJpsUtil.parsePackageNameFromManifestFile(manifestFile);
                if (packageName == null || packageName.length() <= 0) continue;
                result.add((Pair<String, String>)Pair.create((Object)rTxt.getPath(), (Object)packageName));
            }
            catch (IOException e) {
                LOG.debug((Throwable)e);
            }
        }
    }

    public static void collectResDirectoriesFromAarDeps(@NotNull JpsModule module, @NotNull Collection<String> result) {
        if (module == null) {
            AndroidJpsUtil.$$$reportNull$$$0(122);
        }
        if (result == null) {
            AndroidJpsUtil.$$$reportNull$$$0(123);
        }
        Set libs = JpsJavaExtensionService.getInstance().enumerateDependencies(Collections.singletonList(module)).runtimeOnly().productionOnly().getLibraries();
        for (JpsLibrary lib : libs) {
            Pair<File, List<File>> pair = AndroidJpsUtil.getResDirAndJarsIfAar(lib);
            File resDir = pair != null ? (File)pair.getFirst() : null;
            if (resDir == null) continue;
            result.add(resDir.getPath());
        }
    }

    @Nullable
    public static Pair<File, List<File>> getResDirAndJarsIfAar(@NotNull JpsLibrary lib) {
        List files;
        if (lib == null) {
            AndroidJpsUtil.$$$reportNull$$$0(124);
        }
        if ((files = lib.getFiles(JpsOrderRootType.COMPILED)).size() == 1) {
            File file = (File)files.get(0);
            if (file.isDirectory() && "res".equals(file.getName())) {
                return Pair.create((Object)file, null);
            }
        } else if (files.size() >= 2) {
            File resDir = null;
            File classesJar = null;
            ArrayList<File> allJars = new ArrayList<File>();
            for (File file : files) {
                if (file.isDirectory()) {
                    if ("res".equals(file.getName())) {
                        resDir = file;
                        continue;
                    }
                    return null;
                }
                if (!file.isFile()) continue;
                if ("classes.jar".equals(file.getName())) {
                    classesJar = file;
                }
                if (FileUtilRt.extensionEquals((String)file.getName(), (String)"jar")) {
                    allJars.add(file);
                    continue;
                }
                return null;
            }
            if (resDir != null && classesJar != null && FileUtil.pathsEqual((String)resDir.getParent(), (String)classesJar.getParent())) {
                return Pair.create((Object)resDir, allJars);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static String parsePackageNameFromManifestFile(@NotNull File manifestFile) throws IOException {
        if (manifestFile == null) {
            AndroidJpsUtil.$$$reportNull$$$0(125);
        }
        try (BufferedInputStream inputStream = new BufferedInputStream(new FileInputStream(manifestFile));){
            final Ref packageName = new Ref(null);
            FormsParsing.parse((InputStream)inputStream, (IXMLBuilder)new FormsParsing.IXMLBuilderAdapter(){
                boolean processingManifestTagAttrs = false;

                public void startElement(String name, String nsPrefix, String nsURI, String systemID, int lineNr) throws Exception {
                    if (AndroidJpsUtil.MANIFEST_TAG.equals(name)) {
                        this.processingManifestTagAttrs = true;
                    }
                }

                public void addAttribute(String key, String nsPrefix, String nsURI, String value, String type) throws Exception {
                    if (value != null && "package".equals(key)) {
                        packageName.set((Object)value.trim());
                    }
                }

                public void elementAttributesProcessed(String name, String nsPrefix, String nsURI) throws Exception {
                    6.stop();
                }
            });
            String string = (String)packageName.get();
            return string;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 9: 
            case 10: 
            case 13: 
            case 16: 
            case 18: 
            case 27: 
            case 30: 
            case 33: 
            case 57: 
            case 60: 
            case 63: 
            case 68: 
            case 71: 
            case 73: 
            case 75: 
            case 79: 
            case 81: 
            case 83: 
            case 86: 
            case 91: 
            case 93: 
            case 96: 
            case 99: 
            case 102: 
            case 107: 
            case 109: 
            case 111: 
            case 115: 
            case 116: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 9: 
            case 10: 
            case 13: 
            case 16: 
            case 18: 
            case 27: 
            case 30: 
            case 33: 
            case 57: 
            case 60: 
            case 63: 
            case 68: 
            case 71: 
            case 73: 
            case 75: 
            case 79: 
            case 81: 
            case 83: 
            case 86: 
            case 91: 
            case 93: 
            case 96: 
            case 99: 
            case 102: 
            case 107: 
            case 109: 
            case 111: 
            case 115: 
            case 116: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extension";
                break;
            }
            case 1: 
            case 11: 
            case 20: 
            case 24: 
            case 47: 
            case 50: 
            case 56: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 112: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "messages";
                break;
            }
            case 3: 
            case 49: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builderName";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entryName";
                break;
            }
            case 5: 
            case 12: 
            case 15: 
            case 25: 
            case 29: 
            case 32: 
            case 37: 
            case 40: 
            case 54: 
            case 62: 
            case 69: 
            case 78: 
            case 80: 
            case 82: 
            case 84: 
            case 89: 
            case 92: 
            case 94: 
            case 120: 
            case 122: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 7: 
            case 9: 
            case 10: 
            case 13: 
            case 16: 
            case 18: 
            case 27: 
            case 30: 
            case 33: 
            case 57: 
            case 60: 
            case 63: 
            case 68: 
            case 71: 
            case 73: 
            case 75: 
            case 79: 
            case 81: 
            case 83: 
            case 86: 
            case 91: 
            case 93: 
            case 96: 
            case 99: 
            case 102: 
            case 107: 
            case 109: 
            case 111: 
            case 115: 
            case 116: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/jps/android/AndroidJpsUtil";
                break;
            }
            case 14: 
            case 17: 
            case 59: 
            case 70: 
            case 85: 
            case 88: 
            case 90: 
            case 95: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataPaths";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "compilerName";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseDir";
                break;
            }
            case 23: 
            case 121: 
            case 123: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 26: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "platform";
                break;
            }
            case 28: 
            case 31: 
            case 36: 
            case 39: 
            case 110: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paths";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libs";
                break;
            }
            case 38: 
            case 41: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitedModules";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exception";
                break;
            }
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 72: 
            case 74: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootModule";
                break;
            }
            case 77: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputDirForPackagedArtifacts";
                break;
            }
            case 97: 
            case 100: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataStorageRoot";
                break;
            }
            case 98: 
            case 101: {
                objectArray2 = objectArray3;
                objectArray3[0] = "storageName";
                break;
            }
            case 103: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 105: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyKey";
                break;
            }
            case 108: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifact";
                break;
            }
            case 114: {
                objectArray2 = objectArray3;
                objectArray3[0] = "urls";
                break;
            }
            case 117: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 118: {
                objectArray2 = objectArray3;
                objectArray3[0] = "chunk";
                break;
            }
            case 119: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modules";
                break;
            }
            case 124: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lib";
                break;
            }
            case 125: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manifestFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/jps/android/AndroidJpsUtil";
                break;
            }
            case 7: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "toPaths";
                break;
            }
            case 13: 
            case 16: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getDirectoryForIntermediateArtifacts";
                break;
            }
            case 27: 
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getExternalLibraries";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getProvidedLibraries";
                break;
            }
            case 57: 
            case 60: {
                objectArray = objectArray2;
                objectArray2[1] = "collectResourceDirsForCompilation";
                break;
            }
            case 63: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllAndroidDependencies";
                break;
            }
            case 68: {
                objectArray = objectArray2;
                objectArray2[1] = "getAndroidArtifactsToBuild";
                break;
            }
            case 71: {
                objectArray = objectArray2;
                objectArray2[1] = "getResourcesCacheDir";
                break;
            }
            case 73: {
                objectArray = objectArray2;
                objectArray2[1] = "getSourceRootsForModuleAndDependencies";
                break;
            }
            case 75: {
                objectArray = objectArray2;
                objectArray2[1] = "getJavaOutputRootsForModuleAndDependencies";
                break;
            }
            case 79: {
                objectArray = objectArray2;
                objectArray2[1] = "getApkName";
                break;
            }
            case 81: 
            case 83: {
                objectArray = objectArray2;
                objectArray2[1] = "getGeneratedSourcesStorage";
                break;
            }
            case 86: {
                objectArray = objectArray2;
                objectArray2[1] = "getPreprocessedManifestDirectory";
                break;
            }
            case 91: {
                objectArray = objectArray2;
                objectArray2[1] = "getCopiedSourcesStorage";
                break;
            }
            case 93: 
            case 96: {
                objectArray = objectArray2;
                objectArray2[1] = "getGeneratedResourcesStorage";
                break;
            }
            case 99: {
                objectArray = objectArray2;
                objectArray2[1] = "getStorageFile";
                break;
            }
            case 102: {
                objectArray = objectArray2;
                objectArray2[1] = "getStorageDir";
                break;
            }
            case 107: {
                objectArray = objectArray2;
                objectArray2[1] = "getGenDirs";
                break;
            }
            case 109: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllPackagedFacets";
                break;
            }
            case 111: {
                objectArray = objectArray2;
                objectArray2[1] = "toFiles";
                break;
            }
            case 115: 
            case 116: {
                objectArray = objectArray2;
                objectArray2[1] = "urlsToFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getMainContentRoot";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addMessages";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getExtension";
                break;
            }
            case 6: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "toPaths";
                break;
            }
            case 7: 
            case 9: 
            case 10: 
            case 13: 
            case 16: 
            case 18: 
            case 27: 
            case 30: 
            case 33: 
            case 57: 
            case 60: 
            case 63: 
            case 68: 
            case 71: 
            case 73: 
            case 75: 
            case 79: 
            case 81: 
            case 83: 
            case 86: 
            case 91: 
            case 93: 
            case 96: 
            case 99: 
            case 102: 
            case 107: 
            case 109: 
            case 111: 
            case 115: 
            case 116: {
                break;
            }
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getDirectoryForIntermediateArtifacts";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "createDirIfNotExist";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "addSubdirectories";
                break;
            }
            case 24: 
            case 25: 
            case 26: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getExternalLibraries";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getProvidedLibraries";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "addAnnotationsJarIfNecessary";
                break;
            }
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "processClasspath";
                break;
            }
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "processClassFilesAndJarsRecursively";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "getAndroidTarget";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "toBuildMessageKind";
                break;
            }
            case 47: 
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "reportExceptionError";
                break;
            }
            case 50: 
            case 51: 
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "handleException";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "getManifestFileForCompilationPath";
                break;
            }
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "getAndroidPlatform";
                break;
            }
            case 55: 
            case 56: 
            case 58: 
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "collectResourceDirsForCompilation";
                break;
            }
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "getResourceDirForCompilationPath";
                break;
            }
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "getAllAndroidDependencies";
                break;
            }
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "isLightBuild";
                break;
            }
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "getRunConfigurationTypeId";
                break;
            }
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "isReleaseBuild";
                break;
            }
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "getAndroidArtifactsToBuild";
                break;
            }
            case 69: 
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "getResourcesCacheDir";
                break;
            }
            case 72: {
                objectArray = objectArray;
                objectArray[2] = "getSourceRootsForModuleAndDependencies";
                break;
            }
            case 74: {
                objectArray = objectArray;
                objectArray[2] = "getJavaOutputRootsForModuleAndDependencies";
                break;
            }
            case 76: 
            case 77: {
                objectArray = objectArray;
                objectArray[2] = "getApkPath";
                break;
            }
            case 78: {
                objectArray = objectArray;
                objectArray[2] = "getApkName";
                break;
            }
            case 80: 
            case 82: {
                objectArray = objectArray;
                objectArray[2] = "getGeneratedSourcesStorage";
                break;
            }
            case 84: 
            case 85: {
                objectArray = objectArray;
                objectArray[2] = "getPreprocessedManifestDirectory";
                break;
            }
            case 87: 
            case 88: {
                objectArray = objectArray;
                objectArray[2] = "getPreprocessedManifestFile";
                break;
            }
            case 89: 
            case 90: {
                objectArray = objectArray;
                objectArray[2] = "getCopiedSourcesStorage";
                break;
            }
            case 92: 
            case 94: 
            case 95: {
                objectArray = objectArray;
                objectArray[2] = "getGeneratedResourcesStorage";
                break;
            }
            case 97: 
            case 98: {
                objectArray = objectArray;
                objectArray[2] = "getStorageFile";
                break;
            }
            case 100: 
            case 101: {
                objectArray = objectArray;
                objectArray[2] = "getStorageDir";
                break;
            }
            case 103: {
                objectArray = objectArray;
                objectArray[2] = "readPropertyFile";
                break;
            }
            case 104: 
            case 105: {
                objectArray = objectArray;
                objectArray[2] = "getProjectPropertyValue";
                break;
            }
            case 106: {
                objectArray = objectArray;
                objectArray[2] = "getGenDirs";
                break;
            }
            case 108: {
                objectArray = objectArray;
                objectArray[2] = "getPackagedFacet";
                break;
            }
            case 110: {
                objectArray = objectArray;
                objectArray[2] = "toFiles";
                break;
            }
            case 112: 
            case 113: {
                objectArray = objectArray;
                objectArray[2] = "getProGuardConfigIfShouldRun";
                break;
            }
            case 114: {
                objectArray = objectArray;
                objectArray[2] = "urlsToFiles";
                break;
            }
            case 117: 
            case 118: 
            case 119: {
                objectArray = objectArray;
                objectArray[2] = "isAndroidProjectWithoutGradleFacet";
                break;
            }
            case 120: 
            case 121: {
                objectArray = objectArray;
                objectArray[2] = "collectRTextFilesFromAarDeps";
                break;
            }
            case 122: 
            case 123: {
                objectArray = objectArray;
                objectArray[2] = "collectResDirectoriesFromAarDeps";
                break;
            }
            case 124: {
                objectArray = objectArray;
                objectArray[2] = "getResDirAndJarsIfAar";
                break;
            }
            case 125: {
                objectArray = objectArray;
                objectArray[2] = "parsePackageNameFromManifestFile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 9: 
            case 10: 
            case 13: 
            case 16: 
            case 18: 
            case 27: 
            case 30: 
            case 33: 
            case 57: 
            case 60: 
            case 63: 
            case 68: 
            case 71: 
            case 73: 
            case 75: 
            case 79: 
            case 81: 
            case 83: 
            case 86: 
            case 91: 
            case 93: 
            case 96: 
            case 99: 
            case 102: 
            case 107: 
            case 109: 
            case 111: 
            case 115: 
            case 116: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class RepoLogger
    extends ProgressIndicatorAdapter {
        private final Logger myLogger = Logger.getInstance(AndroidJpsUtil.class);

        public void logWarning(@NotNull String s) {
            if (s == null) {
                RepoLogger.$$$reportNull$$$0(0);
            }
            this.myLogger.warn(s);
        }

        public void logWarning(@NotNull String s, @Nullable Throwable e) {
            if (s == null) {
                RepoLogger.$$$reportNull$$$0(1);
            }
            this.myLogger.warn(s, e);
        }

        public void logError(@NotNull String s) {
            if (s == null) {
                RepoLogger.$$$reportNull$$$0(2);
            }
            this.myLogger.error(s);
        }

        public void logError(@NotNull String s, @Nullable Throwable e) {
            if (s == null) {
                RepoLogger.$$$reportNull$$$0(3);
            }
            this.myLogger.error(s, e);
        }

        public void logInfo(@NotNull String s) {
            if (s == null) {
                RepoLogger.$$$reportNull$$$0(4);
            }
            this.myLogger.info(s);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "s";
            objectArray2[1] = "org/jetbrains/jps/android/AndroidJpsUtil$RepoLogger";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "logWarning";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "logError";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "logInfo";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

