/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.android.builder;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.containers.HashSet;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.android.AndroidJpsUtil;
import org.jetbrains.jps.android.AndroidPlatform;
import org.jetbrains.jps.android.builder.AndroidAarDepsBuildTarget;
import org.jetbrains.jps.android.builder.AndroidLibraryPackagingTarget;
import org.jetbrains.jps.android.model.JpsAndroidModuleExtension;
import org.jetbrains.jps.builders.BuildRootIndex;
import org.jetbrains.jps.builders.BuildTarget;
import org.jetbrains.jps.builders.BuildTargetLoader;
import org.jetbrains.jps.builders.BuildTargetRegistry;
import org.jetbrains.jps.builders.BuildTargetType;
import org.jetbrains.jps.builders.TargetOutputIndex;
import org.jetbrains.jps.builders.impl.BuildRootDescriptorImpl;
import org.jetbrains.jps.builders.storage.BuildDataPaths;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.indices.IgnoredFileIndex;
import org.jetbrains.jps.indices.ModuleExcludeIndex;
import org.jetbrains.jps.model.JpsModel;
import org.jetbrains.jps.model.JpsProject;
import org.jetbrains.jps.model.module.JpsDependencyElement;
import org.jetbrains.jps.model.module.JpsModule;
import org.jetbrains.jps.model.module.JpsModuleDependency;

public class AndroidPreDexBuildTarget
extends BuildTarget<MyRootDescriptor> {
    private static final String ID = "only";
    private final JpsProject myProject;
    public static final String PRE_DEXED_LIBS_DIRECTORY_NAME = "pre_dexed_libs";

    public AndroidPreDexBuildTarget(@NotNull JpsProject project) {
        if (project == null) {
            AndroidPreDexBuildTarget.$$$reportNull$$$0(0);
        }
        super((BuildTargetType)MyTargetType.INSTANCE);
        this.myProject = project;
    }

    public String getId() {
        return ID;
    }

    public Collection<BuildTarget<?>> computeDependencies(BuildTargetRegistry targetRegistry, TargetOutputIndex outputIndex) {
        ArrayList result = new ArrayList();
        for (JpsModule module : this.myProject.getModules()) {
            JpsAndroidModuleExtension extension = AndroidJpsUtil.getExtension(module);
            if (extension == null) continue;
            if (extension.isLibrary()) {
                result.add(new AndroidLibraryPackagingTarget(module));
                continue;
            }
            result.add(new AndroidAarDepsBuildTarget(module));
        }
        return result;
    }

    private static void fillDepsRecursively(@NotNull JpsModule root, @NotNull Set<JpsModule> libModules, @NotNull Set<String> externalJars, @NotNull BuildDataPaths dataPaths, @NotNull AndroidPlatform platform) {
        if (root == null) {
            AndroidPreDexBuildTarget.$$$reportNull$$$0(1);
        }
        if (libModules == null) {
            AndroidPreDexBuildTarget.$$$reportNull$$$0(2);
        }
        if (externalJars == null) {
            AndroidPreDexBuildTarget.$$$reportNull$$$0(3);
        }
        if (dataPaths == null) {
            AndroidPreDexBuildTarget.$$$reportNull$$$0(4);
        }
        if (platform == null) {
            AndroidPreDexBuildTarget.$$$reportNull$$$0(5);
        }
        for (String jarOrLibDirPath : AndroidJpsUtil.getExternalLibraries(dataPaths, root, platform, false, false, true)) {
            String path = FileUtil.toCanonicalPath((String)jarOrLibDirPath);
            if (path == null) continue;
            externalJars.add(path);
        }
        for (JpsDependencyElement dependencyElement : root.getDependenciesList().getDependencies()) {
            JpsAndroidModuleExtension depExtension;
            JpsModule depModule;
            if (!(dependencyElement instanceof JpsModuleDependency) || (depModule = ((JpsModuleDependency)dependencyElement).getModule()) == null || (depExtension = AndroidJpsUtil.getExtension(depModule)) == null || !depExtension.isLibrary() || !libModules.add(depModule)) continue;
            AndroidPreDexBuildTarget.fillDepsRecursively(depModule, libModules, externalJars, dataPaths, platform);
        }
    }

    @NotNull
    public List<MyRootDescriptor> computeRootDescriptors(JpsModel model, ModuleExcludeIndex index, IgnoredFileIndex ignoredFileIndex, BuildDataPaths dataPaths) {
        ArrayList<MyRootDescriptor> result = new ArrayList<MyRootDescriptor>();
        HashSet libModules = new HashSet();
        HashSet externalJars = new HashSet();
        for (JpsModule module : this.myProject.getModules()) {
            AndroidPlatform platform;
            JpsAndroidModuleExtension extension = AndroidJpsUtil.getExtension(module);
            if (extension == null || extension.isLibrary() || !extension.isPreDexingEnabled() || (platform = AndroidJpsUtil.getAndroidPlatform(module, null, null)) == null) continue;
            AndroidPreDexBuildTarget.fillDepsRecursively(module, (Set<JpsModule>)libModules, (Set<String>)externalJars, dataPaths, platform);
        }
        for (JpsModule libModule : libModules) {
            File classesJarFile = new AndroidLibraryPackagingTarget(libModule).getOutputFile(dataPaths);
            result.add(new MyRootDescriptor(this, classesJarFile, libModule.getName()));
        }
        for (String externalJarPath : externalJars) {
            result.add(new MyRootDescriptor(this, new File(externalJarPath), null));
        }
        ArrayList<MyRootDescriptor> arrayList = result;
        if (arrayList == null) {
            AndroidPreDexBuildTarget.$$$reportNull$$$0(6);
        }
        return arrayList;
    }

    @Nullable
    public MyRootDescriptor findRootDescriptor(String rootId, BuildRootIndex rootIndex) {
        for (MyRootDescriptor descriptor : rootIndex.getTargetRoots((BuildTarget)this, null)) {
            if (!descriptor.getRootId().equals(rootId)) continue;
            return descriptor;
        }
        return null;
    }

    @NotNull
    public String getPresentableName() {
        if ("Android Pre-DEX" == null) {
            AndroidPreDexBuildTarget.$$$reportNull$$$0(7);
        }
        return "Android Pre-DEX";
    }

    @NotNull
    public Collection<File> getOutputRoots(CompileContext context) {
        List<File> list = Collections.singletonList(this.getOutputFile(context));
        if (list == null) {
            AndroidPreDexBuildTarget.$$$reportNull$$$0(8);
        }
        return list;
    }

    @NotNull
    public File getOutputFile(CompileContext context) {
        File file = AndroidPreDexBuildTarget.getOutputDir(context.getProjectDescriptor().dataManager.getDataPaths());
        if (file == null) {
            AndroidPreDexBuildTarget.$$$reportNull$$$0(9);
        }
        return file;
    }

    @NotNull
    public static File getOutputDir(@NotNull BuildDataPaths dataPaths) {
        if (dataPaths == null) {
            AndroidPreDexBuildTarget.$$$reportNull$$$0(10);
        }
        File dir = AndroidJpsUtil.getDirectoryForIntermediateArtifacts(dataPaths);
        File file = new File(dir, PRE_DEXED_LIBS_DIRECTORY_NAME);
        if (file == null) {
            AndroidPreDexBuildTarget.$$$reportNull$$$0(11);
        }
        return file;
    }

    @NotNull
    public JpsProject getProject() {
        JpsProject jpsProject = this.myProject;
        if (jpsProject == null) {
            AndroidPreDexBuildTarget.$$$reportNull$$$0(12);
        }
        return jpsProject;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        AndroidPreDexBuildTarget target = (AndroidPreDexBuildTarget)((Object)o);
        return this.myProject.equals(target.myProject);
    }

    public int hashCode() {
        return this.myProject.hashCode();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libModules";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "externalJars";
                break;
            }
            case 4: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataPaths";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "platform";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/jps/android/builder/AndroidPreDexBuildTarget";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/jps/android/builder/AndroidPreDexBuildTarget";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "computeRootDescriptors";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableName";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getOutputRoots";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getOutputFile";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getOutputDir";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "fillDepsRecursively";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getOutputDir";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class MyRootDescriptor
    extends BuildRootDescriptorImpl {
        private final String myModuleName;

        private MyRootDescriptor(@NotNull BuildTarget target, @NotNull File root, @Nullable String moduleName) {
            if (target == null) {
                MyRootDescriptor.$$$reportNull$$$0(0);
            }
            if (root == null) {
                MyRootDescriptor.$$$reportNull$$$0(1);
            }
            super(target, root);
            this.myModuleName = moduleName;
        }

        @Nullable
        public String getModuleName() {
            return this.myModuleName;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "target";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "root";
                    break;
                }
            }
            objectArray[1] = "org/jetbrains/jps/android/builder/AndroidPreDexBuildTarget$MyRootDescriptor";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class MyTargetType
    extends BuildTargetType<AndroidPreDexBuildTarget> {
        public static final MyTargetType INSTANCE = new MyTargetType();

        private MyTargetType() {
            super("android-pre-dex");
        }

        @NotNull
        public List<AndroidPreDexBuildTarget> computeAllTargets(@NotNull JpsModel model) {
            if (model == null) {
                MyTargetType.$$$reportNull$$$0(0);
            }
            if (!AndroidJpsUtil.isAndroidProjectWithoutGradleFacet(model.getProject())) {
                List<AndroidPreDexBuildTarget> list = Collections.emptyList();
                if (list == null) {
                    MyTargetType.$$$reportNull$$$0(1);
                }
                return list;
            }
            List<AndroidPreDexBuildTarget> list = Collections.singletonList(new AndroidPreDexBuildTarget(model.getProject()));
            if (list == null) {
                MyTargetType.$$$reportNull$$$0(2);
            }
            return list;
        }

        @NotNull
        public BuildTargetLoader<AndroidPreDexBuildTarget> createLoader(@NotNull JpsModel model) {
            if (model == null) {
                MyTargetType.$$$reportNull$$$0(3);
            }
            final JpsProject project = model.getProject();
            BuildTargetLoader<AndroidPreDexBuildTarget> buildTargetLoader = new BuildTargetLoader<AndroidPreDexBuildTarget>(){

                @Nullable
                public AndroidPreDexBuildTarget createTarget(@NotNull String targetId) {
                    if (targetId == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return AndroidPreDexBuildTarget.ID.equals(targetId) && AndroidJpsUtil.isAndroidProjectWithoutGradleFacet(project) ? new AndroidPreDexBuildTarget(project) : null;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetId", "org/jetbrains/jps/android/builder/AndroidPreDexBuildTarget$MyTargetType$1", "createTarget"));
                }
            };
            if (buildTargetLoader == null) {
                MyTargetType.$$$reportNull$$$0(4);
            }
            return buildTargetLoader;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "model";
                    break;
                }
                case 1: 
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/jps/android/builder/AndroidPreDexBuildTarget$MyTargetType";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/jps/android/builder/AndroidPreDexBuildTarget$MyTargetType";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "computeAllTargets";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createLoader";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "computeAllTargets";
                    break;
                }
                case 1: 
                case 2: 
                case 4: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "createLoader";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

