/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.annotator;

import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeHighlighting.TextEditorHighlightingPassFactory;
import com.intellij.codeHighlighting.TextEditorHighlightingPassRegistrar;
import com.intellij.lang.Language;
import com.intellij.openapi.components.AbstractProjectComponent;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyLanguage;
import org.jetbrains.plugins.groovy.annotator.GrReferenceHighlighter;
import org.jetbrains.plugins.groovy.extensions.GroovyScriptTypeDetector;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFileBase;
import org.jetbrains.plugins.groovy.util.GrFileIndexUtil;

public class GrReferenceHighlighterFactory
extends AbstractProjectComponent
implements TextEditorHighlightingPassFactory {
    public GrReferenceHighlighterFactory(Project project, TextEditorHighlightingPassRegistrar registrar) {
        super(project);
        registrar.registerTextEditorHighlightingPass((TextEditorHighlightingPassFactory)this, null, null, false, -1);
    }

    public TextEditorHighlightingPass createHighlightingPass(@NotNull PsiFile file, @NotNull Editor editor) {
        GroovyFileBase groovyFile;
        if (file == null) {
            GrReferenceHighlighterFactory.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            GrReferenceHighlighterFactory.$$$reportNull$$$0(1);
        }
        if ((groovyFile = GrReferenceHighlighterFactory.getAndCheckFile(file)) == null) {
            return null;
        }
        return new GrReferenceHighlighter(editor.getDocument(), groovyFile);
    }

    @Nullable
    private static GroovyFileBase getAndCheckFile(@NotNull PsiFile file) {
        if (file == null) {
            GrReferenceHighlighterFactory.$$$reportNull$$$0(2);
        }
        if (GrReferenceHighlighterFactory.isSpecificScriptFile(file)) {
            return (GroovyFileBase)file;
        }
        PsiFile psiGroovyFile = file.getViewProvider().getPsi((Language)GroovyLanguage.INSTANCE);
        if (!(psiGroovyFile instanceof GroovyFileBase)) {
            return null;
        }
        GroovyFileBase groovyFile = (GroovyFileBase)psiGroovyFile;
        return GrFileIndexUtil.isGroovySourceFile(groovyFile) ? groovyFile : null;
    }

    private static boolean isSpecificScriptFile(@NotNull PsiFile file) {
        if (file == null) {
            GrReferenceHighlighterFactory.$$$reportNull$$$0(3);
        }
        if (!(file instanceof GroovyFile)) {
            return false;
        }
        if (!((GroovyFile)file).isScript()) {
            return false;
        }
        for (GroovyScriptTypeDetector detector : (GroovyScriptTypeDetector[])GroovyScriptTypeDetector.EP_NAME.getExtensions()) {
            if (!detector.isSpecificScriptFile((GroovyFile)file)) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/groovy/annotator/GrReferenceHighlighterFactory";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createHighlightingPass";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getAndCheckFile";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isSpecificScriptFile";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

