/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.stubs;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiShortNamesCache;
import com.intellij.psi.stubs.StubIndex;
import com.intellij.util.ArrayFactory;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.Processors;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashSet;
import com.intellij.util.indexing.IdFilter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrAnnotationMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.impl.search.GrSourceFilterScope;
import org.jetbrains.plugins.groovy.lang.psi.stubs.index.GrAnnotationMethodNameIndex;
import org.jetbrains.plugins.groovy.lang.psi.stubs.index.GrFieldNameIndex;
import org.jetbrains.plugins.groovy.lang.psi.stubs.index.GrFullClassNameIndex;
import org.jetbrains.plugins.groovy.lang.psi.stubs.index.GrFullScriptNameIndex;
import org.jetbrains.plugins.groovy.lang.psi.stubs.index.GrMethodNameIndex;
import org.jetbrains.plugins.groovy.lang.psi.stubs.index.GrScriptClassNameIndex;

public class GroovyShortNamesCache
extends PsiShortNamesCache {
    private final Project myProject;

    public GroovyShortNamesCache(Project project) {
        this.myProject = project;
    }

    public static GroovyShortNamesCache getGroovyShortNamesCache(Project project) {
        return (GroovyShortNamesCache)((Object)ObjectUtils.assertNotNull((Object)ContainerUtil.findInstance((Object[])project.getExtensions(PsiShortNamesCache.EP_NAME), GroovyShortNamesCache.class)));
    }

    @NotNull
    public PsiClass[] getClassesByName(@NotNull @NonNls String name, @NotNull GlobalSearchScope scope) {
        if (name == null) {
            GroovyShortNamesCache.$$$reportNull$$$0(0);
        }
        if (scope == null) {
            GroovyShortNamesCache.$$$reportNull$$$0(1);
        }
        SmartList allClasses = new SmartList();
        this.processClassesWithName(name, (Processor<? super PsiClass>)Processors.cancelableCollectProcessor((Collection)allClasses), scope, null);
        if (allClasses.isEmpty()) {
            if (PsiClass.EMPTY_ARRAY == null) {
                GroovyShortNamesCache.$$$reportNull$$$0(2);
            }
            return PsiClass.EMPTY_ARRAY;
        }
        PsiClass[] psiClassArray = allClasses.toArray(new PsiClass[allClasses.size()]);
        if (psiClassArray == null) {
            GroovyShortNamesCache.$$$reportNull$$$0(3);
        }
        return psiClassArray;
    }

    public List<PsiClass> getScriptClassesByFQName(String name, GlobalSearchScope scope, boolean srcOnly) {
        Object actualScope = srcOnly ? new GrSourceFilterScope(scope) : scope;
        Collection files = StubIndex.getElements(GrFullScriptNameIndex.KEY, (Object)name.hashCode(), (Project)this.myProject, (GlobalSearchScope)actualScope, GroovyFile.class);
        if (files.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<PsiClass> result = new ArrayList<PsiClass>();
        for (GroovyFile file : files) {
            PsiClass scriptClass;
            if (!file.isScript() || (scriptClass = file.getScriptClass()) == null || !name.equals(scriptClass.getQualifiedName())) continue;
            result.add(scriptClass);
        }
        return result;
    }

    @NotNull
    public List<PsiClass> getClassesByFQName(String name, GlobalSearchScope scope, boolean inSource) {
        ArrayList result = ContainerUtil.newArrayList();
        for (PsiElement psiClass : StubIndex.getElements(GrFullClassNameIndex.KEY, (Object)name.hashCode(), (Project)this.myProject, (GlobalSearchScope)(inSource ? new GrSourceFilterScope(scope) : scope), PsiClass.class)) {
            if (!name.equals(((PsiClass)psiClass).getQualifiedName())) continue;
            result.add((PsiClass)psiClass);
        }
        result.addAll(this.getScriptClassesByFQName(name, scope, inSource));
        ArrayList arrayList = result;
        if (arrayList == null) {
            GroovyShortNamesCache.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    @NotNull
    public String[] getAllClassNames() {
        String[] stringArray = ArrayUtil.toStringArray((Collection)StubIndex.getInstance().getAllKeys(GrScriptClassNameIndex.KEY, this.myProject));
        if (stringArray == null) {
            GroovyShortNamesCache.$$$reportNull$$$0(5);
        }
        return stringArray;
    }

    public void getAllClassNames(@NotNull HashSet<String> dest) {
        if (dest == null) {
            GroovyShortNamesCache.$$$reportNull$$$0(6);
        }
        dest.addAll(StubIndex.getInstance().getAllKeys(GrScriptClassNameIndex.KEY, this.myProject));
    }

    @NotNull
    public PsiMethod[] getMethodsByName(@NonNls @NotNull String name, @NotNull GlobalSearchScope scope) {
        if (name == null) {
            GroovyShortNamesCache.$$$reportNull$$$0(7);
        }
        if (scope == null) {
            GroovyShortNamesCache.$$$reportNull$$$0(8);
        }
        Collection methods = StubIndex.getElements(GrMethodNameIndex.KEY, (Object)name, (Project)this.myProject, (GlobalSearchScope)new GrSourceFilterScope(scope), GrMethod.class);
        Collection annMethods = StubIndex.getElements(GrAnnotationMethodNameIndex.KEY, (Object)name, (Project)this.myProject, (GlobalSearchScope)new GrSourceFilterScope(scope), GrAnnotationMethod.class);
        if (methods.isEmpty() && annMethods.isEmpty()) {
            if (PsiMethod.EMPTY_ARRAY == null) {
                GroovyShortNamesCache.$$$reportNull$$$0(9);
            }
            return PsiMethod.EMPTY_ARRAY;
        }
        PsiMethod[] psiMethodArray = (PsiMethod[])ArrayUtil.mergeCollections((Collection)annMethods, (Collection)methods, (ArrayFactory)PsiMethod.ARRAY_FACTORY);
        if (psiMethodArray == null) {
            GroovyShortNamesCache.$$$reportNull$$$0(10);
        }
        return psiMethodArray;
    }

    public boolean processMethodsWithName(@NonNls @NotNull String name, @NotNull GlobalSearchScope scope, @NotNull Processor<PsiMethod> processor) {
        if (name == null) {
            GroovyShortNamesCache.$$$reportNull$$$0(11);
        }
        if (scope == null) {
            GroovyShortNamesCache.$$$reportNull$$$0(12);
        }
        if (processor == null) {
            GroovyShortNamesCache.$$$reportNull$$$0(13);
        }
        return this.processMethodsWithName(name, processor, scope, null);
    }

    public boolean processMethodsWithName(@NonNls @NotNull String name, @NotNull Processor<? super PsiMethod> processor, @NotNull GlobalSearchScope scope, @Nullable IdFilter filter) {
        if (name == null) {
            GroovyShortNamesCache.$$$reportNull$$$0(14);
        }
        if (processor == null) {
            GroovyShortNamesCache.$$$reportNull$$$0(15);
        }
        if (scope == null) {
            GroovyShortNamesCache.$$$reportNull$$$0(16);
        }
        GrSourceFilterScope filterScope = new GrSourceFilterScope(scope);
        return StubIndex.getInstance().processElements(GrMethodNameIndex.KEY, (Object)name, this.myProject, (GlobalSearchScope)filterScope, filter, GrMethod.class, processor) && StubIndex.getInstance().processElements(GrAnnotationMethodNameIndex.KEY, (Object)name, this.myProject, (GlobalSearchScope)filterScope, filter, GrAnnotationMethod.class, processor);
    }

    @NotNull
    public PsiMethod[] getMethodsByNameIfNotMoreThan(@NonNls @NotNull String name, @NotNull GlobalSearchScope scope, int maxCount) {
        if (name == null) {
            GroovyShortNamesCache.$$$reportNull$$$0(17);
        }
        if (scope == null) {
            GroovyShortNamesCache.$$$reportNull$$$0(18);
        }
        PsiMethod[] psiMethodArray = this.getMethodsByName(name, scope);
        if (psiMethodArray == null) {
            GroovyShortNamesCache.$$$reportNull$$$0(19);
        }
        return psiMethodArray;
    }

    @NotNull
    public PsiField[] getFieldsByNameIfNotMoreThan(@NonNls @NotNull String name, @NotNull GlobalSearchScope scope, int maxCount) {
        if (name == null) {
            GroovyShortNamesCache.$$$reportNull$$$0(20);
        }
        if (scope == null) {
            GroovyShortNamesCache.$$$reportNull$$$0(21);
        }
        PsiField[] psiFieldArray = this.getFieldsByName(name, scope);
        if (psiFieldArray == null) {
            GroovyShortNamesCache.$$$reportNull$$$0(22);
        }
        return psiFieldArray;
    }

    @NotNull
    public String[] getAllMethodNames() {
        Collection keys = StubIndex.getInstance().getAllKeys(GrMethodNameIndex.KEY, this.myProject);
        keys.addAll(StubIndex.getInstance().getAllKeys(GrAnnotationMethodNameIndex.KEY, this.myProject));
        String[] stringArray = ArrayUtil.toStringArray((Collection)keys);
        if (stringArray == null) {
            GroovyShortNamesCache.$$$reportNull$$$0(23);
        }
        return stringArray;
    }

    public void getAllMethodNames(@NotNull HashSet<String> set) {
        if (set == null) {
            GroovyShortNamesCache.$$$reportNull$$$0(24);
        }
        set.addAll(StubIndex.getInstance().getAllKeys(GrMethodNameIndex.KEY, this.myProject));
    }

    @NotNull
    public PsiField[] getFieldsByName(@NotNull @NonNls String name, @NotNull GlobalSearchScope scope) {
        Collection fields;
        if (name == null) {
            GroovyShortNamesCache.$$$reportNull$$$0(25);
        }
        if (scope == null) {
            GroovyShortNamesCache.$$$reportNull$$$0(26);
        }
        if ((fields = StubIndex.getElements(GrFieldNameIndex.KEY, (Object)name, (Project)this.myProject, (GlobalSearchScope)new GrSourceFilterScope(scope), GrField.class)).isEmpty()) {
            if (PsiField.EMPTY_ARRAY == null) {
                GroovyShortNamesCache.$$$reportNull$$$0(27);
            }
            return PsiField.EMPTY_ARRAY;
        }
        PsiField[] psiFieldArray = fields.toArray(new PsiField[fields.size()]);
        if (psiFieldArray == null) {
            GroovyShortNamesCache.$$$reportNull$$$0(28);
        }
        return psiFieldArray;
    }

    @NotNull
    public String[] getAllFieldNames() {
        Collection fields = StubIndex.getInstance().getAllKeys(GrFieldNameIndex.KEY, this.myProject);
        String[] stringArray = ArrayUtil.toStringArray((Collection)fields);
        if (stringArray == null) {
            GroovyShortNamesCache.$$$reportNull$$$0(29);
        }
        return stringArray;
    }

    public void getAllFieldNames(@NotNull HashSet<String> set) {
        if (set == null) {
            GroovyShortNamesCache.$$$reportNull$$$0(30);
        }
        set.addAll(StubIndex.getInstance().getAllKeys(GrFieldNameIndex.KEY, this.myProject));
    }

    public boolean processFieldsWithName(@NotNull String name, @NotNull Processor<? super PsiField> processor, @NotNull GlobalSearchScope scope, @Nullable IdFilter filter) {
        if (name == null) {
            GroovyShortNamesCache.$$$reportNull$$$0(31);
        }
        if (processor == null) {
            GroovyShortNamesCache.$$$reportNull$$$0(32);
        }
        if (scope == null) {
            GroovyShortNamesCache.$$$reportNull$$$0(33);
        }
        return StubIndex.getInstance().processElements(GrFieldNameIndex.KEY, (Object)name, this.myProject, (GlobalSearchScope)new GrSourceFilterScope(scope), filter, GrField.class, processor);
    }

    public boolean processClassesWithName(@NotNull String name, @NotNull Processor<? super PsiClass> processor, @NotNull GlobalSearchScope scope, @Nullable IdFilter filter) {
        if (name == null) {
            GroovyShortNamesCache.$$$reportNull$$$0(34);
        }
        if (processor == null) {
            GroovyShortNamesCache.$$$reportNull$$$0(35);
        }
        if (scope == null) {
            GroovyShortNamesCache.$$$reportNull$$$0(36);
        }
        for (GroovyFile file : StubIndex.getElements(GrScriptClassNameIndex.KEY, (Object)name, (Project)this.myProject, (GlobalSearchScope)new GrSourceFilterScope(scope), (IdFilter)filter, GroovyFile.class)) {
            PsiClass aClass = file.getScriptClass();
            if (aClass == null || processor.process((Object)aClass)) continue;
            return true;
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 9: 
            case 10: 
            case 19: 
            case 22: 
            case 23: 
            case 27: 
            case 28: 
            case 29: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 9: 
            case 10: 
            case 19: 
            case 22: 
            case 23: 
            case 27: 
            case 28: 
            case 29: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: 
            case 8: 
            case 12: 
            case 16: 
            case 18: 
            case 21: 
            case 26: 
            case 33: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 9: 
            case 10: 
            case 19: 
            case 22: 
            case 23: 
            case 27: 
            case 28: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/lang/stubs/GroovyShortNamesCache";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dest";
                break;
            }
            case 13: 
            case 15: 
            case 32: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 24: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "set";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/lang/stubs/GroovyShortNamesCache";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassesByName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassesByFQName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllClassNames";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getMethodsByName";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getMethodsByNameIfNotMoreThan";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getFieldsByNameIfNotMoreThan";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllMethodNames";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getFieldsByName";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllFieldNames";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getClassesByName";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 9: 
            case 10: 
            case 19: 
            case 22: 
            case 23: 
            case 27: 
            case 28: 
            case 29: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getAllClassNames";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getMethodsByName";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "processMethodsWithName";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getMethodsByNameIfNotMoreThan";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getFieldsByNameIfNotMoreThan";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getAllMethodNames";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getFieldsByName";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getAllFieldNames";
                break;
            }
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "processFieldsWithName";
                break;
            }
            case 34: 
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "processClassesWithName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 9: 
            case 10: 
            case 19: 
            case 22: 
            case 23: 
            case 27: 
            case 28: 
            case 29: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

