/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib2.writer.builder;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterators;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.jf.dexlib2.iface.AnnotationElement;
import org.jf.dexlib2.iface.value.AnnotationEncodedValue;
import org.jf.dexlib2.iface.value.ArrayEncodedValue;
import org.jf.dexlib2.iface.value.BooleanEncodedValue;
import org.jf.dexlib2.iface.value.ByteEncodedValue;
import org.jf.dexlib2.iface.value.CharEncodedValue;
import org.jf.dexlib2.iface.value.DoubleEncodedValue;
import org.jf.dexlib2.iface.value.EncodedValue;
import org.jf.dexlib2.iface.value.EnumEncodedValue;
import org.jf.dexlib2.iface.value.FieldEncodedValue;
import org.jf.dexlib2.iface.value.FloatEncodedValue;
import org.jf.dexlib2.iface.value.IntEncodedValue;
import org.jf.dexlib2.iface.value.LongEncodedValue;
import org.jf.dexlib2.iface.value.MethodEncodedValue;
import org.jf.dexlib2.iface.value.ShortEncodedValue;
import org.jf.dexlib2.iface.value.StringEncodedValue;
import org.jf.dexlib2.iface.value.TypeEncodedValue;
import org.jf.dexlib2.writer.builder.BuilderAnnotationElement;
import org.jf.dexlib2.writer.builder.BuilderAnnotationPool;
import org.jf.dexlib2.writer.builder.BuilderAnnotationSetPool;
import org.jf.dexlib2.writer.builder.BuilderClassPool;
import org.jf.dexlib2.writer.builder.BuilderEncodedValues;
import org.jf.dexlib2.writer.builder.BuilderFieldPool;
import org.jf.dexlib2.writer.builder.BuilderMethodPool;
import org.jf.dexlib2.writer.builder.BuilderProtoPool;
import org.jf.dexlib2.writer.builder.BuilderStringPool;
import org.jf.dexlib2.writer.builder.BuilderTypeListPool;
import org.jf.dexlib2.writer.builder.BuilderTypePool;
import org.jf.util.ExceptionWithContext;

class BuilderContext {
    @Nonnull
    final BuilderStringPool stringPool = new BuilderStringPool();
    @Nonnull
    final BuilderTypePool typePool = new BuilderTypePool(this);
    @Nonnull
    final BuilderFieldPool fieldPool = new BuilderFieldPool(this);
    @Nonnull
    final BuilderMethodPool methodPool = new BuilderMethodPool(this);
    @Nonnull
    final BuilderProtoPool protoPool = new BuilderProtoPool(this);
    @Nonnull
    final BuilderClassPool classPool = new BuilderClassPool();
    @Nonnull
    final BuilderTypeListPool typeListPool = new BuilderTypeListPool(this);
    @Nonnull
    final BuilderAnnotationPool annotationPool = new BuilderAnnotationPool(this);
    @Nonnull
    final BuilderAnnotationSetPool annotationSetPool = new BuilderAnnotationSetPool(this);

    BuilderContext() {
    }

    @Nonnull
    Set<? extends BuilderAnnotationElement> internAnnotationElements(@Nonnull Set<? extends AnnotationElement> elements) {
        return ImmutableSet.copyOf((Iterator)Iterators.transform(elements.iterator(), (Function)new Function<AnnotationElement, BuilderAnnotationElement>(){

            @Nullable
            public BuilderAnnotationElement apply(AnnotationElement input) {
                return BuilderContext.this.internAnnotationElement(input);
            }
        }));
    }

    @Nonnull
    private BuilderAnnotationElement internAnnotationElement(@Nonnull AnnotationElement annotationElement) {
        return new BuilderAnnotationElement(this.stringPool.internString(annotationElement.getName()), this.internEncodedValue(annotationElement.getValue()));
    }

    @Nullable
    BuilderEncodedValues.BuilderEncodedValue internNullableEncodedValue(@Nullable EncodedValue encodedValue) {
        if (encodedValue == null) {
            return null;
        }
        return this.internEncodedValue(encodedValue);
    }

    @Nonnull
    private BuilderEncodedValues.BuilderEncodedValue internEncodedValue(@Nonnull EncodedValue encodedValue) {
        switch (encodedValue.getValueType()) {
            case 29: {
                return this.internAnnotationEncodedValue((AnnotationEncodedValue)encodedValue);
            }
            case 28: {
                return this.internArrayEncodedValue((ArrayEncodedValue)encodedValue);
            }
            case 31: {
                boolean value = ((BooleanEncodedValue)encodedValue).getValue();
                return value ? BuilderEncodedValues.BuilderBooleanEncodedValue.TRUE_VALUE : BuilderEncodedValues.BuilderBooleanEncodedValue.FALSE_VALUE;
            }
            case 0: {
                return new BuilderEncodedValues.BuilderByteEncodedValue(((ByteEncodedValue)encodedValue).getValue());
            }
            case 3: {
                return new BuilderEncodedValues.BuilderCharEncodedValue(((CharEncodedValue)encodedValue).getValue());
            }
            case 17: {
                return new BuilderEncodedValues.BuilderDoubleEncodedValue(((DoubleEncodedValue)encodedValue).getValue());
            }
            case 27: {
                return this.internEnumEncodedValue((EnumEncodedValue)encodedValue);
            }
            case 25: {
                return this.internFieldEncodedValue((FieldEncodedValue)encodedValue);
            }
            case 16: {
                return new BuilderEncodedValues.BuilderFloatEncodedValue(((FloatEncodedValue)encodedValue).getValue());
            }
            case 4: {
                return new BuilderEncodedValues.BuilderIntEncodedValue(((IntEncodedValue)encodedValue).getValue());
            }
            case 6: {
                return new BuilderEncodedValues.BuilderLongEncodedValue(((LongEncodedValue)encodedValue).getValue());
            }
            case 26: {
                return this.internMethodEncodedValue((MethodEncodedValue)encodedValue);
            }
            case 30: {
                return BuilderEncodedValues.BuilderNullEncodedValue.INSTANCE;
            }
            case 2: {
                return new BuilderEncodedValues.BuilderShortEncodedValue(((ShortEncodedValue)encodedValue).getValue());
            }
            case 23: {
                return this.internStringEncodedValue((StringEncodedValue)encodedValue);
            }
            case 24: {
                return this.internTypeEncodedValue((TypeEncodedValue)encodedValue);
            }
        }
        throw new ExceptionWithContext("Unexpected encoded value type: %d", new Object[]{encodedValue.getValueType()});
    }

    @Nonnull
    private BuilderEncodedValues.BuilderAnnotationEncodedValue internAnnotationEncodedValue(@Nonnull AnnotationEncodedValue value) {
        return new BuilderEncodedValues.BuilderAnnotationEncodedValue(this.typePool.internType(value.getType()), this.internAnnotationElements(value.getElements()));
    }

    @Nonnull
    private BuilderEncodedValues.BuilderArrayEncodedValue internArrayEncodedValue(@Nonnull ArrayEncodedValue value) {
        return new BuilderEncodedValues.BuilderArrayEncodedValue((List<? extends BuilderEncodedValues.BuilderEncodedValue>)ImmutableList.copyOf((Iterator)Iterators.transform(value.getValue().iterator(), (Function)new Function<EncodedValue, BuilderEncodedValues.BuilderEncodedValue>(){

            @Nullable
            public BuilderEncodedValues.BuilderEncodedValue apply(EncodedValue input) {
                return BuilderContext.this.internEncodedValue(input);
            }
        })));
    }

    @Nonnull
    private BuilderEncodedValues.BuilderEnumEncodedValue internEnumEncodedValue(@Nonnull EnumEncodedValue value) {
        return new BuilderEncodedValues.BuilderEnumEncodedValue(this.fieldPool.internField(value.getValue()));
    }

    @Nonnull
    private BuilderEncodedValues.BuilderFieldEncodedValue internFieldEncodedValue(@Nonnull FieldEncodedValue value) {
        return new BuilderEncodedValues.BuilderFieldEncodedValue(this.fieldPool.internField(value.getValue()));
    }

    @Nonnull
    private BuilderEncodedValues.BuilderMethodEncodedValue internMethodEncodedValue(@Nonnull MethodEncodedValue value) {
        return new BuilderEncodedValues.BuilderMethodEncodedValue(this.methodPool.internMethod(value.getValue()));
    }

    @Nonnull
    private BuilderEncodedValues.BuilderStringEncodedValue internStringEncodedValue(@Nonnull StringEncodedValue string) {
        return new BuilderEncodedValues.BuilderStringEncodedValue(this.stringPool.internString(string.getValue()));
    }

    @Nonnull
    private BuilderEncodedValues.BuilderTypeEncodedValue internTypeEncodedValue(@Nonnull TypeEncodedValue type) {
        return new BuilderEncodedValues.BuilderTypeEncodedValue(this.typePool.internType(type.getValue()));
    }
}

