/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intentions;

import com.intellij.codeInsight.intention.AbstractIntentionAction;
import com.intellij.jsp.JspBundle;
import com.intellij.lang.html.HTMLLanguage;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JspPsiUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.jsp.JspFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlComment;
import com.intellij.util.IncorrectOperationException;
import com.intellij.xml.util.XmlUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JspCommentIntention
extends AbstractIntentionAction {
    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        XmlComment comment;
        if (project == null) {
            JspCommentIntention.$$$reportNull$$$0(0);
        }
        return (comment = JspCommentIntention.getXmlComment(editor, file)) != null && XmlUtil.getCommentText((XmlComment)comment) != null;
    }

    @Nullable
    private static XmlComment getXmlComment(Editor editor, PsiFile file) {
        PsiFile psiFile;
        JspFile jspFile = JspPsiUtil.getJspFile((PsiElement)file);
        if (jspFile != null && (psiFile = jspFile.getBaseLanguageRoot()).getLanguage().equals(HTMLLanguage.INSTANCE)) {
            PsiElement element = psiFile.findElementAt(editor.getCaretModel().getOffset());
            return (XmlComment)PsiTreeUtil.getParentOfType((PsiElement)element, XmlComment.class, (boolean)false);
        }
        return null;
    }

    @NotNull
    public String getText() {
        String string = JspBundle.message("replace.with.jsp.comment.intention", new Object[0]);
        if (string == null) {
            JspCommentIntention.$$$reportNull$$$0(1);
        }
        return string;
    }

    public void invoke(@NotNull Project project, final Editor editor, PsiFile file) throws IncorrectOperationException {
        String text;
        XmlComment comment;
        if (project == null) {
            JspCommentIntention.$$$reportNull$$$0(2);
        }
        if ((comment = JspCommentIntention.getXmlComment(editor, file)) != null && (text = XmlUtil.getCommentText((XmlComment)comment)) != null) {
            new WriteCommandAction.Simple(project, new PsiFile[]{file}){

                protected void run() throws Throwable {
                    TextRange range = comment.getTextRange();
                    editor.getDocument().replaceString(range.getStartOffset(), range.getEndOffset(), (CharSequence)("<%--" + text + "--%>"));
                }
            }.execute();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/intentions/JspCommentIntention";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/intentions/JspCommentIntention";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

