/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.profiles;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.xml.XmlFile;
import com.intellij.spring.contexts.model.SpringModel;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.spring.model.utils.SpringProfileUtils;
import com.intellij.spring.model.xml.beans.Beans;
import com.intellij.spring.profiles.SpringChangeActiveProfilesAction;
import com.intellij.spring.profiles.SpringProfilesPanel;
import com.intellij.spring.settings.SpringGeneralSettings;
import com.intellij.ui.EditorNotifications;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.DomChangeAdapter;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomEventListener;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.DomUtil;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class SpringProfilesEditorNotificationsProvider
extends EditorNotifications.Provider<SpringProfilesPanel> {
    private final Project myProject;
    private static final Key<SpringProfilesPanel> KEY = Key.create((String)"SpringProfilesPanelKey");

    public SpringProfilesEditorNotificationsProvider(Project project) {
        this.myProject = project;
        DomManager.getDomManager((Project)project).addDomEventListener((DomEventListener)new DomChangeAdapter(){

            protected void elementChanged(DomElement element) {
                DomFileElement domFileElement = (DomFileElement)DomUtil.getParentOfType((DomElement)element, DomFileElement.class, (boolean)false);
                if (domFileElement != null && domFileElement.isValid() && domFileElement.getRootElement() instanceof Beans) {
                    EditorNotifications.getInstance((Project)SpringProfilesEditorNotificationsProvider.this.myProject).updateAllNotifications();
                }
            }
        }, (Disposable)project);
    }

    @NotNull
    public Key<SpringProfilesPanel> getKey() {
        Key<SpringProfilesPanel> key = KEY;
        if (key == null) {
            SpringProfilesEditorNotificationsProvider.$$$reportNull$$$0(0);
        }
        return key;
    }

    public SpringProfilesPanel createNotificationPanel(@NotNull VirtualFile file, @NotNull FileEditor fileEditor) {
        if (file == null) {
            SpringProfilesEditorNotificationsProvider.$$$reportNull$$$0(1);
        }
        if (fileEditor == null) {
            SpringProfilesEditorNotificationsProvider.$$$reportNull$$$0(2);
        }
        if (!SpringGeneralSettings.getInstance((Project)this.myProject).isShowProfilesPanel()) {
            return null;
        }
        if (DumbService.isDumb((Project)this.myProject)) {
            DumbService.getInstance((Project)this.myProject).smartInvokeLater(() -> {
                if (file == null) {
                    SpringProfilesEditorNotificationsProvider.$$$reportNull$$$0(5);
                }
                EditorNotifications.getInstance((Project)this.myProject).updateNotifications(file);
            });
            return null;
        }
        if (!SpringCommonUtils.hasSpringFacets((Project)this.myProject)) {
            return null;
        }
        PsiFile psiFile = PsiManager.getInstance((Project)this.myProject).findFile(file);
        if (psiFile == null) {
            return null;
        }
        SpringModel springModel = SpringChangeActiveProfilesAction.getSpringModel(psiFile);
        if (springModel == null || springModel.getFileSet() == null) {
            return null;
        }
        Set<String> allProfiles = SpringProfilesEditorNotificationsProvider.filterNonProfiles(springModel.getAllProfiles());
        Set activeProfiles = springModel.getActiveProfiles();
        if (allProfiles.size() == 1 && "_DEFAULT_PROFILE_NAME_".equals(allProfiles.iterator().next()) && (activeProfiles == null || activeProfiles.isEmpty())) {
            return null;
        }
        if (allProfiles.isEmpty()) {
            return null;
        }
        return new SpringProfilesPanel(this.myProject, SpringProfileUtils.profilesAsString((Set)activeProfiles), SpringProfilesEditorNotificationsProvider.isFileInActiveProfile(psiFile, springModel));
    }

    @NotNull
    private static Set<String> filterNonProfiles(@NotNull Set<String> profiles) {
        if (profiles == null) {
            SpringProfilesEditorNotificationsProvider.$$$reportNull$$$0(3);
        }
        Set set = ContainerUtil.map2Set(profiles, s -> s.startsWith("!") ? s.substring(1) : s);
        if (set == null) {
            SpringProfilesEditorNotificationsProvider.$$$reportNull$$$0(4);
        }
        return set;
    }

    private static boolean isFileInActiveProfile(PsiFile file, SpringModel model) {
        if (file instanceof XmlFile) {
            return true;
        }
        return model.hasConfigFile(file);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/profiles/SpringProfilesEditorNotificationsProvider";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileEditor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "profiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getKey";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/profiles/SpringProfilesEditorNotificationsProvider";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "filterNonProfiles";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createNotificationPanel";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "filterNonProfiles";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "lambda$createNotificationPanel$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

