/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.refactoring;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.internal.statistic.UsageTrigger;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.jsp.JspFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlChildRole;
import com.intellij.psi.xml.XmlDoctype;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlProlog;
import com.intellij.psi.xml.XmlTag;
import com.intellij.spring.SpringBundle;
import com.intellij.spring.dom.SpringDomUtils;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.SpringModelVisitor;
import com.intellij.spring.model.scope.SpringBeanScope;
import com.intellij.spring.model.xml.beans.Beans;
import com.intellij.spring.model.xml.beans.SpringBean;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.xml.DomFileElement;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class SpringUpdateSchemaIntention
implements IntentionAction {
    @NonNls
    private static final String BEANS = "beans xmlns=\"http://www.springframework.org/schema/beans\"\nxmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\nxsi:schemaLocation=\"http://www.springframework.org/schema/beans http://www.springframework.org/schema/beans/spring-beans.xsd\"";

    @NotNull
    public String getText() {
        String string = SpringBundle.message("update.schema.intention", new Object[0]);
        if (string == null) {
            SpringUpdateSchemaIntention.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = this.getText();
        if (string == null) {
            SpringUpdateSchemaIntention.$$$reportNull$$$0(1);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            SpringUpdateSchemaIntention.$$$reportNull$$$0(2);
        }
        if (file instanceof XmlFile && !(file instanceof JspFile) && SpringDomUtils.isSpringXml((XmlFile)((XmlFile)file))) {
            int offset = editor.getCaretModel().getOffset();
            PsiElement psiElement = file.findElementAt(offset);
            if (PsiTreeUtil.getParentOfType((PsiElement)psiElement, XmlProlog.class) != null || PsiTreeUtil.getParentOfType((PsiElement)psiElement, XmlDoctype.class) != null) {
                return SpringUpdateSchemaIntention.isUpdateNeeded((XmlFile)file);
            }
            XmlTag tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)psiElement, XmlTag.class);
            if (tag != null && tag.getParentTag() == null) {
                return SpringUpdateSchemaIntention.isUpdateNeeded((XmlFile)file);
            }
        }
        return false;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            SpringUpdateSchemaIntention.$$$reportNull$$$0(3);
        }
        SpringUpdateSchemaIntention.updateSchema((XmlFile)file);
    }

    public static boolean requestSchemaUpdate(@NotNull XmlFile file) throws IncorrectOperationException {
        if (file == null) {
            SpringUpdateSchemaIntention.$$$reportNull$$$0(4);
        }
        if (!SpringUpdateSchemaIntention.isUpdateNeeded(file)) {
            return true;
        }
        boolean unitTestMode = ApplicationManager.getApplication().isUnitTestMode();
        if (!unitTestMode && Messages.showYesNoDialog((String)SpringBundle.message("xml.schema.will.be.updated", new Object[0]), (String)SpringBundle.message("xml.schema.update.is.required", new Object[0]), (Icon)Messages.getQuestionIcon()) != 0) {
            return false;
        }
        boolean success = SpringUpdateSchemaIntention.updateSchema(file);
        if (!success && !unitTestMode) {
            Messages.showErrorDialog((Project)file.getProject(), (String)("Schema update failed for invalid file " + file.getName()), (String)"Spring Schema Update");
        }
        return success;
    }

    private static boolean updateSchema(@NotNull XmlFile file) throws IncorrectOperationException {
        XmlDoctype doctype;
        Project project;
        PsiDocumentManager documentManager;
        Document doc;
        if (file == null) {
            SpringUpdateSchemaIntention.$$$reportNull$$$0(5);
        }
        if ((doc = (documentManager = PsiDocumentManager.getInstance((Project)(project = file.getProject()))).getDocument((PsiFile)file)) == null) {
            return false;
        }
        DomFileElement element = SpringDomUtils.getSpringDomFileElement((XmlFile)file);
        if (element == null) {
            return false;
        }
        XmlTag tag = element.getRootTag();
        if (tag == null) {
            return false;
        }
        ASTNode node = tag.getNode();
        if (node == null) {
            return false;
        }
        ASTNode child = XmlChildRole.START_TAG_NAME_FINDER.findChild(node);
        if (child == null) {
            return false;
        }
        TextRange range = child.getTextRange();
        doc.replaceString(range.getStartOffset(), range.getEndOffset(), (CharSequence)BEANS);
        documentManager.commitDocument(doc);
        CodeStyleManager.getInstance((Project)project).reformatRange((PsiElement)tag, range.getStartOffset(), range.getStartOffset() + BEANS.length());
        SpringModelVisitor.visitBeans((SpringModelVisitor)new SpringModelVisitor(){

            protected boolean visitBean(CommonSpringBean bean) {
                Boolean value;
                if (bean instanceof SpringBean && (value = (Boolean)((SpringBean)bean).getSingleton().getValue()) != null) {
                    ((SpringBean)bean).getSingleton().undefine();
                    ((SpringBean)bean).getScope().setValue((Object)(value != false ? SpringBeanScope.SINGLETON_SCOPE : SpringBeanScope.PROTOTYPE_SCOPE));
                }
                return true;
            }
        }, (Beans)((Beans)element.getRootElement()));
        XmlProlog prolog = ((XmlDocument)ObjectUtils.assertNotNull((Object)file.getDocument())).getProlog();
        XmlDoctype xmlDoctype = doctype = prolog == null ? null : prolog.getDoctype();
        if (doctype != null) {
            doctype.delete();
        }
        UsageTrigger.trigger((String)"spring.SpringUpdateSchemaIntention");
        return true;
    }

    public boolean startInWriteAction() {
        return true;
    }

    private static boolean isUpdateNeeded(@NotNull XmlFile config) {
        if (config == null) {
            SpringUpdateSchemaIntention.$$$reportNull$$$0(6);
        }
        XmlDocument document = config.getDocument();
        assert (document != null);
        XmlTag tag = document.getRootTag();
        assert (tag != null);
        return !tag.getNamespace().equals("http://www.springframework.org/schema/beans");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/refactoring/SpringUpdateSchemaIntention";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/refactoring/SpringUpdateSchemaIntention";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "requestSchemaUpdate";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "updateSchema";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isUpdateNeeded";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

