/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.run;

import com.intellij.codeInsight.hint.HintManager;
import com.intellij.codeInsight.navigation.NavigationUtil;
import com.intellij.execution.filters.Filter;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.spring.run.SpringMultipleOccurrencesFilter;
import com.intellij.util.Consumer;
import com.intellij.util.PsiNavigateUtil;
import org.jetbrains.annotations.Nullable;

class AutowireMethodFieldLinkFilter
extends SpringMultipleOccurrencesFilter {
    private static final String AUTOWIRE_FIELD = "autowire field: ";
    private static final String[] DETECTION_MESSAGES = new String[]{"autowire method: ", "autowire field: "};

    AutowireMethodFieldLinkFilter() {
    }

    @Override
    @Nullable
    protected Filter.Result findNextOccurrence(int startOffset, String line, int entireLength) {
        int index = -1;
        int messageLength = -1;
        boolean localIsField = false;
        for (String message : DETECTION_MESSAGES) {
            index = StringUtil.indexOf((CharSequence)line, (CharSequence)message, (int)startOffset);
            if (index == -1) continue;
            messageLength = message.length();
            localIsField = message.equals(AUTOWIRE_FIELD);
            break;
        }
        if (index == -1) {
            return null;
        }
        int methodSignatureStart = index + messageLength;
        int methodSignatureEnd = StringUtil.indexOf((CharSequence)line, (char)';', (int)methodSignatureStart);
        String methodSignature = line.substring(methodSignatureStart, methodSignatureEnd);
        int textStartOffset = entireLength - line.length() + methodSignatureStart;
        boolean isFieldMode = localIsField;
        return new Filter.Result(textStartOffset, textStartOffset + methodSignature.length(), project -> {
            Couple<String> parseResult = AutowireMethodFieldLinkFilter.parseSignature(methodSignature, isFieldMode);
            if (parseResult == null) {
                AutowireMethodFieldLinkFilter.showResult((Consumer<Editor>)((Consumer)editor -> HintManager.getInstance().showErrorHint(editor, "Could not parse signature '" + methodSignature + "'")));
                return;
            }
            String classname = (String)parseResult.getFirst();
            String methodName = (String)parseResult.getSecond();
            AutowireMethodFieldLinkFilter.showResult((Consumer<Editor>)((Consumer)editor -> {
                PsiClass psiClass = JavaPsiFacade.getInstance((Project)project).findClass(classname.replace('$', '.'), GlobalSearchScope.allScope((Project)project));
                if (psiClass == null) {
                    HintManager.getInstance().showErrorHint(editor, "Could not resolve class '" + classname + "'");
                    return;
                }
                if (isFieldMode) {
                    PsiField field = psiClass.findFieldByName(methodName, true);
                    PsiNavigateUtil.navigate((PsiElement)field);
                    return;
                }
                PsiMethod[] methods = psiClass.findMethodsByName(methodName, true);
                if (methods.length == 1) {
                    PsiNavigateUtil.navigate((PsiElement)methods[0]);
                    return;
                }
                JBPopup popup = NavigationUtil.getPsiElementPopup((PsiElement[])methods, (String)"Choose Method");
                popup.showInBestPositionFor(editor);
            }));
        });
    }

    @Nullable
    static Couple<String> parseSignature(String methodSignature, boolean isFieldMode) {
        int openParenthIdx = isFieldMode ? methodSignature.length() : methodSignature.lastIndexOf(40);
        int lastSpace = methodSignature.lastIndexOf(32);
        if (openParenthIdx == -1 || lastSpace == -1) {
            return null;
        }
        String qualifiedMethodName = methodSignature.substring(lastSpace + 1, openParenthIdx);
        String classname = qualifiedMethodName.substring(0, qualifiedMethodName.lastIndexOf(46));
        String methodName = isFieldMode ? methodSignature.substring(methodSignature.lastIndexOf(46) + 1) : methodSignature.substring(methodSignature.indexOf(classname) + classname.length() + 1, openParenthIdx);
        return Couple.of((Object)classname, (Object)methodName);
    }
}

