/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodeJs;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.javascript.debugger.impl.DebuggableFileFinder;
import com.intellij.javascript.nodejs.debug.NodeDebugRunConfiguration;
import com.intellij.util.net.NetUtils;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugSession;
import com.jetbrains.nodeJs.NodeJsDebugProcess;
import io.netty.bootstrap.Bootstrap;
import java.io.IOException;
import java.net.InetSocketAddress;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.debugger.Vm;
import org.jetbrains.debugger.connection.RemoteVmConnection;
import org.jetbrains.debugger.connection.VmConnection;
import org.jetbrains.v8.StandaloneV8VmKt;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=2, d1={"\u00004\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u001a0\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b\u001a\u0006\u0010\f\u001a\u00020\r\u001a\u0006\u0010\u000e\u001a\u00020\u0003\u001a\u0010\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u0011H\u0002\u00a8\u0006\u0012"}, d2={"createNodeJsDebugProcess", "Lcom/intellij/xdebugger/XDebugProcess;", "socketAddress", "Ljava/net/InetSocketAddress;", "session", "Lcom/intellij/xdebugger/XDebugSession;", "executionResult", "Lcom/intellij/execution/ExecutionResult;", "environment", "Lcom/intellij/execution/runners/ExecutionEnvironment;", "fileFinder", "Lcom/intellij/javascript/debugger/impl/DebuggableFileFinder;", "createRemoteConnection", "Lorg/jetbrains/debugger/connection/RemoteVmConnection;", "findAvailablePortOnLocalhost", "getDebugAddress", "configuration", "Lcom/intellij/javascript/nodejs/debug/NodeDebugRunConfiguration;", "ChromeConnector"})
public final class NodeDebugProgramRunnerKt {
    @NotNull
    public static final XDebugProcess createNodeJsDebugProcess(@NotNull InetSocketAddress socketAddress, @NotNull XDebugSession session2, @Nullable ExecutionResult executionResult, @NotNull ExecutionEnvironment environment, @NotNull DebuggableFileFinder fileFinder) {
        Intrinsics.checkParameterIsNotNull((Object)socketAddress, (String)"socketAddress");
        Intrinsics.checkParameterIsNotNull((Object)session2, (String)"session");
        Intrinsics.checkParameterIsNotNull((Object)environment, (String)"environment");
        Intrinsics.checkParameterIsNotNull((Object)fileFinder, (String)"fileFinder");
        RemoteVmConnection connection = NodeDebugProgramRunnerKt.createRemoteConnection();
        NodeJsDebugProcess process2 = new NodeJsDebugProcess(session2, (VmConnection<Vm>)((VmConnection)connection), fileFinder, executionResult, environment.getExecutor());
        RemoteVmConnection.open$default((RemoteVmConnection)connection, (InetSocketAddress)socketAddress, null, (int)2, null);
        return (XDebugProcess)process2;
    }

    private static final InetSocketAddress getDebugAddress(NodeDebugRunConfiguration configuration) {
        InetSocketAddress debugAddress = configuration.getDebugAddress();
        if (debugAddress == null) {
            debugAddress = NodeDebugProgramRunnerKt.findAvailablePortOnLocalhost();
        }
        return debugAddress;
    }

    @NotNull
    public static final RemoteVmConnection createRemoteConnection() {
        return new RemoteVmConnection(){

            @NotNull
            public Bootstrap createBootstrap(@NotNull InetSocketAddress address, @NotNull AsyncPromise<Vm> vmResult) {
                Intrinsics.checkParameterIsNotNull((Object)address, (String)"address");
                Intrinsics.checkParameterIsNotNull(vmResult, (String)"vmResult");
                return StandaloneV8VmKt.createV8VmBootstrap(vmResult, this.getDebugEventListener());
            }
        };
    }

    @NotNull
    public static final InetSocketAddress findAvailablePortOnLocalhost() {
        try {
            return new InetSocketAddress(NetUtils.getLoopbackAddress(), NetUtils.findAvailableSocketPort());
        }
        catch (IOException e) {
            throw (Throwable)new ExecutionException("Cannot find available port", (Throwable)e);
        }
    }

    @NotNull
    public static final /* synthetic */ InetSocketAddress access$getDebugAddress(@NotNull NodeDebugRunConfiguration configuration) {
        return NodeDebugProgramRunnerKt.getDebugAddress(configuration);
    }
}

