/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodeJs;

import com.intellij.javascript.nodejs.library.NodeJsCoreLibraryManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Url;
import com.intellij.util.Urls;
import com.jetbrains.javascript.debugger.BaseNodeJsFileFinder;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NodeJSFileFinder
extends BaseNodeJsFileFinder {
    private final NodeJsCoreLibraryManager myCoreLibraryManager;

    public NodeJSFileFinder(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/nodeJs/NodeJSFileFinder", "<init>"));
        }
        this.myCoreLibraryManager = NodeJsCoreLibraryManager.getInstance((Project)project);
    }

    @Nullable
    public VirtualFile findFile(@NotNull Url url, @NotNull Project project) {
        VirtualFile file;
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/jetbrains/nodeJs/NodeJSFileFinder", "findFile"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/nodeJs/NodeJSFileFinder", "findFile"));
        }
        String path = url.getPath();
        if (NodeJSFileFinder.isModuleName(path) && (file = this.myCoreLibraryManager.findCoreModuleFileByName(StringUtil.trimEnd((String)path, (String)".js"))) != null) {
            return file;
        }
        return super.findFile(url, project);
    }

    public static boolean isModuleName(@Nullable String path) {
        return path != null && path.indexOf(47) == -1 && path.indexOf(92) == -1;
    }

    @NotNull
    public List<Url> getRemoteUrls(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/nodeJs/NodeJSFileFinder", "getRemoteUrls"));
        }
        List<Url> list = this.myCoreLibraryManager.isCoreModuleLibraryFile(file) ? Collections.singletonList(Urls.newLocalFileUrl((String)file.getName())) : super.getRemoteUrls(file);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodeJs/NodeJSFileFinder", "getRemoteUrls"));
        }
        return list;
    }
}

