/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nwjs;

import com.google.common.io.Files;
import com.google.gson.stream.JsonReader;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ColoredProcessHandler;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.platform.templates.github.ZipUtil;
import com.intellij.util.Base64Converter;
import com.intellij.util.SystemProperties;
import com.intellij.util.Url;
import com.intellij.util.Urls;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.execution.ParametersListUtil;
import com.intellij.util.io.URLUtil;
import com.jetbrains.debugger.wip.WipRemoteVmConnection;
import com.jetbrains.javascript.debugger.execution.DebuggableProcessRunConfiguration;
import com.jetbrains.javascript.debugger.execution.DebuggableProcessState;
import com.jetbrains.nwjs.NwjsRunConfiguration;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.debugger.sourcemap.SourceResolver;

class NwjsProcessState
extends DebuggableProcessState<NwjsRunConfiguration> {
    private static final Logger LOG = Logger.getInstance(NwjsProcessState.class);
    private static final Pattern SKIPPED_CONSOLE_MESSAGE_PATTERN = Pattern.compile("^\\[\\d+:\\d+/\\d+:[A-Z]+:CONSOLE");
    static final String PACKAGE_JSON = "package.json";
    private Url url;
    private WipRemoteVmConnection vmConnection;
    private List<String> programParametersList;

    public NwjsProcessState(@NotNull NwjsRunConfiguration configuration, @NotNull ExecutionEnvironment environment) {
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/jetbrains/nwjs/NwjsProcessState", "<init>"));
        }
        if (environment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "environment", "com/jetbrains/nwjs/NwjsProcessState", "<init>"));
        }
        super((DebuggableProcessRunConfiguration)configuration, environment);
    }

    @Nullable
    private static String getMainUrl(@NotNull Reader reader) throws IOException {
        if (reader == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reader", "com/jetbrains/nwjs/NwjsProcessState", "getMainUrl"));
        }
        try {
            JsonReader jsonReader = new JsonReader(reader);
            jsonReader.beginObject();
            while (jsonReader.hasNext()) {
                if (jsonReader.nextName().equals("main")) {
                    String string = jsonReader.nextString();
                    return string;
                }
                jsonReader.skipValue();
            }
        }
        finally {
            reader.close();
        }
        return null;
    }

    @NotNull
    protected Promise<Void> prepareDebug() throws ExecutionException {
        String rawUrl;
        block11: {
            this.initProgramParameters();
            rawUrl = null;
            if (!ContainerUtil.isEmpty(this.programParametersList)) {
                Iterator<String> iterator = this.programParametersList.iterator();
                while (iterator.hasNext()) {
                    String param = iterator.next();
                    if (param.startsWith("--remote-debugging-port=")) {
                        iterator.remove();
                        continue;
                    }
                    if (!param.startsWith("--rawUrl=")) continue;
                    rawUrl = param.substring("--rawUrl=".length());
                    iterator.remove();
                }
            }
            if (rawUrl == null) {
                File file;
                block12: {
                    AsyncPromise asyncPromise;
                    try {
                        file = new File(this.getInputPath());
                        if (file.isDirectory()) {
                            rawUrl = NwjsProcessState.getMainUrlFromManifest(file);
                            break block11;
                        }
                        if (!file.isFile()) break block12;
                        final AsyncPromise callback = new AsyncPromise();
                        ProgressManager.getInstance().run((Task)new Task.Backgroundable(this.environment.getProject(), "Unpacking NW.js app..."){

                            public void run(@NotNull ProgressIndicator indicator) {
                                if (indicator == null) {
                                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/jetbrains/nwjs/NwjsProcessState$1", "run"));
                                }
                                try {
                                    File tempDirectory = FileUtil.createTempDirectory((String)"NW.js", (String)"idea");
                                    ZipUtil.unzip((ProgressIndicator)indicator, (File)tempDirectory, (File)file, null, null, (boolean)true);
                                    NwjsProcessState.this.url = NwjsProcessState.parseRawUrl(NwjsProcessState.getMainUrlFromManifest(tempDirectory), tempDirectory.getPath());
                                }
                                catch (Exception e) {
                                    callback.setError((Throwable)e);
                                    LOG.error("Cannot unpack packaged app " + file.getPath(), (Throwable)e);
                                }
                            }

                            public void onCancel() {
                                callback.setError("canceled");
                            }

                            public void onSuccess() {
                                callback.setResult(null);
                            }
                        });
                        asyncPromise = callback;
                    }
                    catch (IOException e) {
                        throw new ExecutionException((Throwable)e);
                    }
                    if (asyncPromise == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nwjs/NwjsProcessState", "prepareDebug"));
                    }
                    return asyncPromise;
                }
                if (!file.exists()) {
                    throw new ExecutionException("NW.js app doesn't exist " + file.getPath());
                }
                throw new ExecutionException("Unknown file " + file.getPath());
            }
        }
        this.url = NwjsProcessState.parseRawUrl(rawUrl, this.getInputPath());
        Promise promise2 = Promise.DONE;
        if (promise2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nwjs/NwjsProcessState", "prepareDebug"));
        }
        return promise2;
    }

    @Nullable
    private static String getMainUrlFromManifest(@NotNull File parent) throws IOException, ExecutionException {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/jetbrains/nwjs/NwjsProcessState", "getMainUrlFromManifest"));
        }
        File file = new File(parent, PACKAGE_JSON);
        if (file.exists()) {
            return NwjsProcessState.getMainUrl(Files.newReader((File)file, (Charset)CharsetToolkit.UTF8_CHARSET));
        }
        throw new ExecutionException("Manifest file not found, package.json not exists");
    }

    protected void configureCommandLine(@NotNull GeneralCommandLine commandLine, int debugPort) throws ExecutionException {
        if (commandLine == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commandLine", "com/jetbrains/nwjs/NwjsProcessState", "configureCommandLine"));
        }
        if (debugPort == -1) {
            this.initProgramParameters();
        } else {
            LOG.assertTrue(this.url != null);
            commandLine.addParameter("--remote-debugging-port=" + debugPort);
            if (SystemProperties.getBooleanProperty((String)"nodewebkit.use.bootstrap", (boolean)true)) {
                String bootstrapUrl = "data:text/html;base64," + Base64Converter.encode((String)("<!DOCTYPE html><title>Loading " + this.url + "</title>"));
                commandLine.addParameter("--url=" + bootstrapUrl);
                this.vmConnection = new WipRemoteVmConnection(this.url, bootstrapUrl);
            } else {
                this.vmConnection = new WipRemoteVmConnection(this.url, null);
            }
        }
        if (this.programParametersList != null) {
            commandLine.addParameters(this.programParametersList);
        }
        this.addInputPathArg(commandLine);
    }

    @NotNull
    private static Url parseRawUrl(@Nullable String url, @NotNull String parentPath) throws ExecutionException {
        if (parentPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentPath", "com/jetbrains/nwjs/NwjsProcessState", "parseRawUrl"));
        }
        if (url == null) {
            throw new ExecutionException("Cannot get main URL");
        }
        String absoluteUrl = URLUtil.containsScheme((String)url) || SourceResolver.Companion.isAbsolute(url) ? url : "file://" + parentPath + '/' + url;
        Url parsedUrl = Urls.parseEncoded((String)absoluteUrl);
        if (parsedUrl == null) {
            throw new ExecutionException("Cannot parse main URL: " + absoluteUrl);
        }
        if (parsedUrl.isInLocalFileSystem() && !new File(parsedUrl.getPath()).isFile()) {
            throw new ExecutionException("Main file not valid");
        }
        Url url2 = parsedUrl;
        if (url2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nwjs/NwjsProcessState", "parseRawUrl"));
        }
        return url2;
    }

    private void initProgramParameters() {
        String programParameters = ((NwjsRunConfiguration)this.configuration).getProgramParameters();
        this.programParametersList = StringUtil.isEmpty((String)programParameters) ? null : ParametersListUtil.parse((String)programParameters);
    }

    protected ProcessHandler createProcessHandler(@NotNull GeneralCommandLine commandLine, int debugPort) throws ExecutionException {
        if (commandLine == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commandLine", "com/jetbrains/nwjs/NwjsProcessState", "createProcessHandler"));
        }
        if (debugPort == -1) {
            return super.createProcessHandler(commandLine, debugPort);
        }
        MyProcessHandler handler2 = new MyProcessHandler(commandLine);
        LOG.assertTrue(this.vmConnection != null);
        handler2.vmConnection = this.vmConnection;
        return handler2;
    }

    static class MyProcessHandler
    extends ColoredProcessHandler {
        WipRemoteVmConnection vmConnection;

        public MyProcessHandler(@NotNull GeneralCommandLine commandLine) throws ExecutionException {
            if (commandLine == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commandLine", "com/jetbrains/nwjs/NwjsProcessState$MyProcessHandler", "<init>"));
            }
            super(commandLine);
        }

        public void coloredTextAvailable(String text, Key outputType) {
            if (outputType == ProcessOutputTypes.STDERR && !text.isEmpty() && text.charAt(0) == '[' && SKIPPED_CONSOLE_MESSAGE_PATTERN.matcher(text).find()) {
                return;
            }
            super.coloredTextAvailable(text, outputType);
        }
    }
}

