/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nwjs;

import com.intellij.chromeConnector.debugger.ChromeDebugProcess;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.javascript.debugger.impl.DebuggableFileFinder;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugSession;
import com.jetbrains.javascript.debugger.DebuggableFileFinderImpl;
import com.jetbrains.javascript.debugger.execution.DebuggableProcessRunConfigurationBase;
import com.jetbrains.javascript.debugger.execution.DebuggableProcessRunConfigurationEditor;
import com.jetbrains.nwjs.NwjsProcessState;
import java.io.File;
import java.net.InetSocketAddress;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.debugger.connection.VmConnection;

final class NwjsRunConfiguration
extends DebuggableProcessRunConfigurationBase {
    public NwjsRunConfiguration(Project project, ConfigurationFactory factory, String name) {
        super(project, factory, name);
    }

    public void checkConfiguration() throws RuntimeConfigurationException {
        super.checkConfiguration();
        this.checkExePath("NW.js interpreter");
    }

    @NotNull
    protected String getInputFileTitle() {
        if ("NW.js app" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nwjs/NwjsRunConfiguration", "getInputFileTitle"));
        }
        return "NW.js app";
    }

    @NotNull
    public SettingsEditor<? extends RunConfiguration> getConfigurationEditor() {
        DebuggableProcessRunConfigurationEditor<NwjsRunConfiguration> debuggableProcessRunConfigurationEditor = new DebuggableProcessRunConfigurationEditor<NwjsRunConfiguration>(this.getProject()){

            @NotNull
            protected DebuggableProcessRunConfigurationEditor.DebuggableProgramParametersPanel createEditor() {
                DebuggableProcessRunConfigurationEditor.DebuggableProgramParametersPanel editor = super.createEditor();
                editor.inputPathLabel("NW.js app").programParametersLabel("NW.js arguments:").exePathLabel("NW.js interpreter:");
                editor.setAnchor((JComponent)editor.getProgramParametersComponent().getLabel());
                DebuggableProcessRunConfigurationEditor.DebuggableProgramParametersPanel debuggableProgramParametersPanel = editor;
                if (debuggableProgramParametersPanel == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nwjs/NwjsRunConfiguration$1", "createEditor"));
                }
                return debuggableProgramParametersPanel;
            }

            protected FileChooserDescriptor createInputPathDescriptor() {
                return new FileChooserDescriptor(true, true, false, false, false, false){

                    public boolean isFileSelectable(VirtualFile file) {
                        boolean selectable = super.isFileSelectable(file);
                        if (!selectable) {
                            return false;
                        }
                        if (file.isDirectory()) {
                            return file.findChild("package.json") != null;
                        }
                        return StringUtilRt.endsWithIgnoreCase((CharSequence)file.getNameSequence(), (CharSequence)".nw");
                    }
                };
            }
        };
        if (debuggableProcessRunConfigurationEditor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nwjs/NwjsRunConfiguration", "getConfigurationEditor"));
        }
        return debuggableProcessRunConfigurationEditor;
    }

    @Nullable
    public RunProfileState getState(@NotNull Executor executor, @NotNull ExecutionEnvironment environment) {
        if (executor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executor", "com/jetbrains/nwjs/NwjsRunConfiguration", "getState"));
        }
        if (environment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "environment", "com/jetbrains/nwjs/NwjsRunConfiguration", "getState"));
        }
        return new NwjsProcessState(this, environment);
    }

    @NotNull
    public String correctExePath(@NotNull String exePath) {
        if (exePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "exePath", "com/jetbrains/nwjs/NwjsRunConfiguration", "correctExePath"));
        }
        if (SystemInfo.isMac) {
            if (exePath.endsWith("/node-webkit.app")) {
                String string = exePath + "/Contents/MacOS/node-webkit";
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nwjs/NwjsRunConfiguration", "correctExePath"));
                }
                return string;
            }
            if (exePath.endsWith("/nwjs.app")) {
                String string = exePath + "/Contents/MacOS/nwjs";
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nwjs/NwjsRunConfiguration", "correctExePath"));
                }
                return string;
            }
        }
        String string = exePath;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nwjs/NwjsRunConfiguration", "correctExePath"));
        }
        return string;
    }

    @NotNull
    public XDebugProcess createDebugProcess(@NotNull InetSocketAddress socketAddress, @NotNull XDebugSession session2, @Nullable ExecutionResult executionResult, @NotNull ExecutionEnvironment environment) {
        if (socketAddress == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "socketAddress", "com/jetbrains/nwjs/NwjsRunConfiguration", "createDebugProcess"));
        }
        if (session2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/jetbrains/nwjs/NwjsRunConfiguration", "createDebugProcess"));
        }
        if (environment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "environment", "com/jetbrains/nwjs/NwjsRunConfiguration", "createDebugProcess"));
        }
        assert (executionResult != null);
        NwjsProcessState.MyProcessHandler processHandler = (NwjsProcessState.MyProcessHandler)executionResult.getProcessHandler();
        DebuggableFileFinderImpl fileFinder = new DebuggableFileFinderImpl(session2.getProject(), processHandler.vmConnection.getUrl());
        ChromeDebugProcess process2 = new ChromeDebugProcess(session2, (DebuggableFileFinder)fileFinder, (VmConnection<?>)processHandler.vmConnection, executionResult);
        processHandler.vmConnection.open(socketAddress, null);
        processHandler.vmConnection = null;
        ChromeDebugProcess chromeDebugProcess = process2;
        if (chromeDebugProcess == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nwjs/NwjsRunConfiguration", "createDebugProcess"));
        }
        return chromeDebugProcess;
    }

    @Nullable
    protected String computeDefaultExePath() {
        String appdata;
        File file = null;
        if (SystemInfo.isUnix) {
            if (SystemInfo.isMac) {
                file = new File("/Applications/node-webkit.app/Contents/MacOS/node-webkit");
                if (!file.exists()) {
                    file = new File("/usr/local/lib/node_modules/nodewebkit/nodewebkit/node-webkit.app/Contents/MacOS/node-webkit");
                }
                if (!file.exists()) {
                    file = new File("/Applications/nwjs.app/Contents/MacOS/nwjs");
                }
            }
            if (!(file != null && file.exists() || (file = new File("/usr/local/bin/node-webkit")).exists())) {
                file = new File("/usr/local/bin/nwjs");
            }
        } else if (SystemInfo.isWindows && (appdata = System.getenv("APPDATA")) != null && !(file = new File(appdata, "npm\\node_modules\\nodewebkit\\nodewebkit\\nw.exe")).exists()) {
            file = new File("npm\\node_modules\\nwjs\\nwjs\\nwjs.exe");
        }
        return file == null || !file.exists() ? null : file.getPath();
    }
}

