/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.wip;

import com.intellij.openapi.util.Pair;
import com.intellij.util.Function;
import com.intellij.util.SmartList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.debugger.Breakpoint;
import org.jetbrains.debugger.BreakpointListener;
import org.jetbrains.debugger.BreakpointManagerBase;
import org.jetbrains.debugger.BreakpointTarget;
import org.jetbrains.jsonProtocol.Request;
import org.jetbrains.rpc.CommandProcessorKt;
import org.jetbrains.wip.WipBreakpoint;
import org.jetbrains.wip.WipBreakpointManagerKt;
import org.jetbrains.wip.WipCommandProcessor;
import org.jetbrains.wip.protocol.debugger.BreakpointResolvedEventData;
import org.jetbrains.wip.protocol.debugger.DebuggerKt;
import org.jetbrains.wip.protocol.debugger.LocationValue;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\u0006\u0010\u0011\u001a\u00020\u000eJ:\u0010\u0012\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00162\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\u0007H\u0014J\u0016\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u000e0\u001d2\u0006\u0010\u001e\u001a\u00020\u0002H\u0014J\u001e\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020 0\u001d2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u001e\u001a\u00020\u0002H\u0014J\u0014\u0010!\u001a\u0006\u0012\u0002\b\u00030\u001d2\u0006\u0010\u001b\u001a\u00020\u0007H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u0007X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\""}, d2={"Lorg/jetbrains/wip/WipBreakpointManager;", "Lorg/jetbrains/debugger/BreakpointManagerBase;", "Lorg/jetbrains/wip/WipBreakpoint;", "commandProcessor", "Lorg/jetbrains/wip/WipCommandProcessor;", "(Lorg/jetbrains/wip/WipCommandProcessor;)V", "breakpointsActive", "", "getCommandProcessor", "()Lorg/jetbrains/wip/WipCommandProcessor;", "regExpBreakpointSupported", "getRegExpBreakpointSupported", "()Z", "breakpointReportedResolved", "", "eventData", "Lorg/jetbrains/wip/protocol/debugger/BreakpointResolvedEventData;", "clearNonProvisionalBreakpoints", "createBreakpoint", "target", "Lorg/jetbrains/debugger/BreakpointTarget;", "line", "", "column", "condition", "", "ignoreCount", "enabled", "doClearBreakpoint", "Lorg/jetbrains/concurrency/Promise;", "breakpoint", "doSetBreakpoint", "Lorg/jetbrains/debugger/Breakpoint;", "enableBreakpoints", "wip-backend"})
public final class WipBreakpointManager
extends BreakpointManagerBase<WipBreakpoint> {
    private boolean breakpointsActive;
    private final boolean regExpBreakpointSupported = true;
    @NotNull
    private final WipCommandProcessor commandProcessor;

    public boolean getRegExpBreakpointSupported() {
        return this.regExpBreakpointSupported;
    }

    @NotNull
    protected WipBreakpoint createBreakpoint(@NotNull BreakpointTarget target, int line, int column, @Nullable String condition, int ignoreCount, boolean enabled) {
        Intrinsics.checkParameterIsNotNull((Object)target, (String)"target");
        return new WipBreakpoint(target, line, column, condition, enabled);
    }

    @NotNull
    protected Promise<Breakpoint> doSetBreakpoint(@NotNull BreakpointTarget target, @NotNull WipBreakpoint breakpoint) {
        Intrinsics.checkParameterIsNotNull((Object)target, (String)"target");
        Intrinsics.checkParameterIsNotNull((Object)((Object)breakpoint), (String)"breakpoint");
        Promise promise2 = WipBreakpointManagerKt.sendSetBreakpointRequest(target, breakpoint.getLine(), breakpoint.getColumn(), breakpoint.getCondition(), this.commandProcessor).then(new Function<? super T, ? extends SUB_RESULT>(this, breakpoint){
            final /* synthetic */ WipBreakpointManager this$0;
            final /* synthetic */ WipBreakpoint $breakpoint;

            @NotNull
            public final WipBreakpoint fun(Pair<String, List<LocationValue>> it) {
                this.$breakpoint.setRemoteData((String)it.first, (List)it.second);
                WipBreakpointManager.access$notifyBreakpointResolvedListener(this.this$0, this.$breakpoint);
                return this.$breakpoint;
            }
            {
                this.this$0 = wipBreakpointManager;
                this.$breakpoint = wipBreakpoint;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)promise2, (String)"sendSetBreakpointRequest\u2026       breakpoint\n      }");
        return promise2;
    }

    @NotNull
    protected Promise<Unit> doClearBreakpoint(@NotNull WipBreakpoint breakpoint) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)breakpoint), (String)"breakpoint");
        String string = breakpoint.getVmId();
        if (string == null) {
            Intrinsics.throwNpe();
        }
        return this.commandProcessor.send((Request)DebuggerKt.RemoveBreakpoint(string));
    }

    public final void clearNonProvisionalBreakpoints() {
        SmartList deleteList = new SmartList();
        for (WipBreakpoint breakpoint : this.getBreakpoints()) {
            if (breakpoint.getTarget() instanceof BreakpointTarget.ScriptId) {
                deleteList.add((Object)breakpoint);
                continue;
            }
            breakpoint.clearActualLocations();
        }
        for (WipBreakpoint breakpoint : deleteList) {
            try {
                this.getBreakpoints().remove((Object)breakpoint);
                BreakpointListener breakpointListener = (BreakpointListener)this.getDispatcher().getMulticaster();
                Breakpoint breakpoint2 = (Breakpoint)breakpoint;
                Intrinsics.checkExpressionValueIsNotNull((Object)breakpoint2, (String)"breakpoint");
                breakpointListener.nonProvisionalBreakpointRemoved(breakpoint2);
            }
            catch (Throwable e) {
                CommandProcessorKt.getLOG().error(e);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void breakpointReportedResolved(@NotNull BreakpointResolvedEventData eventData) {
        Object v0;
        block2: {
            void $receiver$iv$iv;
            void $receiver$iv;
            Intrinsics.checkParameterIsNotNull((Object)eventData, (String)"eventData");
            String vmId = eventData.breakpointId();
            Iterable iterable = this.getBreakpoints();
            void var5_4 = $receiver$iv;
            for (Object element$iv$iv : $receiver$iv$iv) {
                WipBreakpoint it = (WipBreakpoint)((Object)element$iv$iv);
                if (!Intrinsics.areEqual((Object)vmId, (Object)it.getVmId())) continue;
                v0 = element$iv$iv;
                break block2;
            }
            v0 = null;
        }
        WipBreakpoint wipBreakpoint = v0;
        if (wipBreakpoint == null) {
            return;
        }
        WipBreakpoint breakpoint = wipBreakpoint;
        breakpoint.addResolvedLocation(eventData.location());
        this.notifyBreakpointResolvedListener(breakpoint);
    }

    @NotNull
    public Promise<?> enableBreakpoints(boolean enabled) {
        this.breakpointsActive = enabled;
        return this.commandProcessor.send((Request)DebuggerKt.SetBreakpointsActive(enabled));
    }

    @NotNull
    public final WipCommandProcessor getCommandProcessor() {
        return this.commandProcessor;
    }

    public WipBreakpointManager(@NotNull WipCommandProcessor commandProcessor2) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)commandProcessor2), (String)"commandProcessor");
        this.commandProcessor = commandProcessor2;
        this.breakpointsActive = true;
        this.regExpBreakpointSupported = true;
    }

    public static final /* synthetic */ void access$notifyBreakpointResolvedListener(WipBreakpointManager $this, @NotNull WipBreakpoint breakpoint) {
        $this.notifyBreakpointResolvedListener(breakpoint);
    }
}

