/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.wip;

import com.intellij.openapi.util.Comparing;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.PromiseKt;
import org.jetbrains.debugger.CallFrame;
import org.jetbrains.debugger.CallFrameBaseKt;
import org.jetbrains.debugger.EvaluateContext;
import org.jetbrains.debugger.Scope;
import org.jetbrains.debugger.Variable;
import org.jetbrains.rpc.CommandProcessorKt;
import org.jetbrains.wip.WipEvaluateContextBase;
import org.jetbrains.wip.WipSuspendContextManagerKt;
import org.jetbrains.wip.WipValueManager;
import org.jetbrains.wip.WipVm;
import org.jetbrains.wip.protocol.WipRequest;
import org.jetbrains.wip.protocol.debugger.CallFrameValue;
import org.jetbrains.wip.protocol.debugger.DebuggerKt;
import org.jetbrains.wip.protocol.debugger.EvaluateOnCallFrameResult;
import org.jetbrains.wip.protocol.debugger.ScopeValue;
import org.jetbrains.wip.protocol.runtime.RemoteObjectValue;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001:\u0001@B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0016\u0010=\u001a\u00020>2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0002\u001a\u00020\u0003J\b\u0010?\u001a\u00020\u001fH\u0016R\"\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u00020\u000fX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0018\u001a\u00020\u0019X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u0014\u0010\u001e\u001a\u00020\u001fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u0014\u0010\"\u001a\u00020#8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010%R(\u0010'\u001a\u0004\u0018\u00010\u001f2\b\u0010&\u001a\u0004\u0018\u00010\u001f@BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010!\"\u0004\b)\u0010*R\u001a\u0010+\u001a\u00020\u000fX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b,\u0010\u0011\"\u0004\b-\u0010\u0013R\u001c\u0010.\u001a\n\u0012\u0006\u0012\u0004\u0018\u0001000/8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b1\u00102R4\u00104\u001a\n\u0012\u0004\u0012\u000203\u0018\u00010\b2\u000e\u0010&\u001a\n\u0012\u0004\u0012\u000203\u0018\u00010\b@BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b5\u0010\u000b\"\u0004\b6\u0010\rR(\u00107\u001a\u0004\u0018\u00010\u001f2\b\u0010&\u001a\u0004\u0018\u00010\u001f@BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b8\u0010!\"\u0004\b9\u0010*R\u0010\u0010:\u001a\u0004\u0018\u000100X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010;\u001a\b\u0012\u0004\u0012\u00020\t0\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b<\u0010\u000b\u00a8\u0006A"}, d2={"Lorg/jetbrains/wip/WipCallFrame;", "Lorg/jetbrains/debugger/CallFrame;", "valueManager", "Lorg/jetbrains/wip/WipValueManager;", "frameData", "Lorg/jetbrains/wip/protocol/debugger/CallFrameValue;", "(Lorg/jetbrains/wip/WipValueManager;Lorg/jetbrains/wip/protocol/debugger/CallFrameValue;)V", "_variableScopes", "", "Lorg/jetbrains/debugger/Scope;", "get_variableScopes", "()Ljava/util/List;", "set_variableScopes", "(Ljava/util/List;)V", "column", "", "getColumn", "()I", "setColumn", "(I)V", "equalityObject", "", "getEqualityObject", "()Ljava/lang/Object;", "evaluateContext", "Lorg/jetbrains/debugger/EvaluateContext;", "getEvaluateContext", "()Lorg/jetbrains/debugger/EvaluateContext;", "setEvaluateContext", "(Lorg/jetbrains/debugger/EvaluateContext;)V", "functionName", "", "getFunctionName", "()Ljava/lang/String;", "hasOnlyGlobalScope", "", "getHasOnlyGlobalScope", "()Z", "<set-?>", "id", "getId", "setId", "(Ljava/lang/String;)V", "line", "getLine", "setLine", "receiverVariable", "Lorg/jetbrains/concurrency/Promise;", "Lorg/jetbrains/debugger/Variable;", "getReceiverVariable", "()Lorg/jetbrains/concurrency/Promise;", "Lorg/jetbrains/wip/protocol/debugger/ScopeValue;", "scopesData", "getScopesData", "setScopesData", "scriptId", "getScriptId", "setScriptId", "thisObject", "variableScopes", "getVariableScopes", "reinit", "", "toString", "WipCallFrameEvaluateContext", "wip-backend"})
public final class WipCallFrame
implements CallFrame {
    private int line;
    private int column;
    @NotNull
    private final String functionName;
    @NotNull
    private EvaluateContext evaluateContext;
    @Nullable
    private String id;
    private Variable thisObject;
    @Nullable
    private String scriptId;
    @Nullable
    private List<? extends ScopeValue> scopesData;
    @Nullable
    private List<? extends Scope> _variableScopes;
    private final WipValueManager valueManager;

    public int getLine() {
        return this.line;
    }

    public void setLine(int n) {
        this.line = n;
    }

    public int getColumn() {
        return this.column;
    }

    public void setColumn(int n) {
        this.column = n;
    }

    @NotNull
    public String getFunctionName() {
        return this.functionName;
    }

    @NotNull
    public EvaluateContext getEvaluateContext() {
        return this.evaluateContext;
    }

    public void setEvaluateContext(@NotNull EvaluateContext evaluateContext2) {
        Intrinsics.checkParameterIsNotNull((Object)evaluateContext2, (String)"<set-?>");
        this.evaluateContext = evaluateContext2;
    }

    @Nullable
    public final String getId() {
        return this.id;
    }

    private final void setId(String string) {
        this.id = string;
    }

    @Nullable
    public final String getScriptId() {
        return this.scriptId;
    }

    private final void setScriptId(String string) {
        this.scriptId = string;
    }

    @Nullable
    public final List<ScopeValue> getScopesData() {
        return this.scopesData;
    }

    private final void setScopesData(List<? extends ScopeValue> list) {
        this.scopesData = list;
    }

    @NotNull
    public Promise<Variable> getReceiverVariable() {
        return PromiseKt.resolvedPromise((Object)this.thisObject);
    }

    @NotNull
    public Object getEqualityObject() {
        return this.scriptId + "#" + this.getFunctionName();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean getHasOnlyGlobalScope() {
        List<? extends ScopeValue> list = this.scopesData;
        if (list == null) {
            Intrinsics.throwNpe();
        }
        if (list.size() != 1) return false;
        List<? extends ScopeValue> list2 = this.scopesData;
        if (list2 == null) {
            Intrinsics.throwNpe();
        }
        if (!Intrinsics.areEqual((Object)((Object)((ScopeValue)CollectionsKt.first(list2)).type()), (Object)((Object)ScopeValue.Type.GLOBAL))) return false;
        return true;
    }

    @Nullable
    public final List<Scope> get_variableScopes() {
        return this._variableScopes;
    }

    public final void set_variableScopes(@Nullable List<? extends Scope> list) {
        this._variableScopes = list;
    }

    @NotNull
    public List<Scope> getVariableScopes() {
        if (this._variableScopes == null) {
            List<? extends ScopeValue> list = this.scopesData;
            if (list == null) {
                Intrinsics.throwNpe();
            }
            this._variableScopes = ArraysKt.asList((Object[])WipSuspendContextManagerKt.createScopes(list, this.id, null, this.valueManager));
        }
        List<Scope> list = this._variableScopes;
        if (list == null) {
            Intrinsics.throwNpe();
        }
        return list;
    }

    public final void reinit(@NotNull CallFrameValue frameData, @NotNull WipValueManager valueManager) {
        Intrinsics.checkParameterIsNotNull((Object)frameData, (String)"frameData");
        Intrinsics.checkParameterIsNotNull((Object)((Object)valueManager), (String)"valueManager");
        CommandProcessorKt.getLOG().assertTrue(Comparing.strEqual((String)frameData.functionName(), (String)this.getFunctionName()));
        CommandProcessorKt.getLOG().assertTrue(this.getLine() == frameData.location().getLineNumber());
        this.scopesData = frameData.scopeChain();
        this._variableScopes = null;
        this.id = frameData.callFrameId();
        this.scriptId = frameData.location().scriptId();
        RemoteObjectValue thisObjectData = frameData.getThis();
        this.thisObject = valueManager.createVariable(CallFrameBaseKt.RECEIVER_NAME, thisObjectData, null);
    }

    @NotNull
    public String toString() {
        return this.scriptId + " " + this.getFunctionName();
    }

    public WipCallFrame(@NotNull WipValueManager valueManager, @NotNull CallFrameValue frameData) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)valueManager), (String)"valueManager");
        Intrinsics.checkParameterIsNotNull((Object)frameData, (String)"frameData");
        this.valueManager = valueManager;
        this.line = frameData.location().getLineNumber();
        this.column = frameData.location().getColumnNumber();
        this.functionName = frameData.functionName();
        this.evaluateContext = (EvaluateContext)new WipCallFrameEvaluateContext(this.valueManager);
        this.reinit(frameData, this.valueManager);
    }

    @Nullable
    public static final /* synthetic */ String access$getId$p(WipCallFrame $this) {
        return $this.id;
    }

    public static final /* synthetic */ void access$setId$p(WipCallFrame $this, @Nullable String string) {
        $this.id = string;
    }

    @Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u001e\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0003\u001a\u00020\u0004H\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0002H\u0014J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\f\u001a\u00020\u0002H\u0014J\u0014\u0010\u000f\u001a\u00060\u0000R\u00020\u00102\u0006\u0010\u0011\u001a\u00020\tH\u0016\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/wip/WipCallFrame$WipCallFrameEvaluateContext;", "Lorg/jetbrains/wip/WipEvaluateContextBase;", "Lorg/jetbrains/wip/protocol/debugger/EvaluateOnCallFrameResult;", "valueManager", "Lorg/jetbrains/wip/WipValueManager;", "(Lorg/jetbrains/wip/WipCallFrame;Lorg/jetbrains/wip/WipValueManager;)V", "createRequest", "Lorg/jetbrains/wip/protocol/WipRequest;", "expression", "", "getRemoteObjectValue", "Lorg/jetbrains/wip/protocol/runtime/RemoteObjectValue;", "data", "getWasThrown", "", "withValueManager", "Lorg/jetbrains/wip/WipCallFrame;", "objectGroup", "wip-backend"})
    private final class WipCallFrameEvaluateContext
    extends WipEvaluateContextBase<EvaluateOnCallFrameResult> {
        @Override
        @NotNull
        public WipRequest<EvaluateOnCallFrameResult> createRequest(@NotNull String expression, @NotNull WipValueManager valueManager) {
            Intrinsics.checkParameterIsNotNull((Object)expression, (String)"expression");
            Intrinsics.checkParameterIsNotNull((Object)((Object)valueManager), (String)"valueManager");
            String string = WipCallFrame.this.getId();
            if (string == null) {
                Intrinsics.throwNpe();
            }
            return DebuggerKt.EvaluateOnCallFrame$default(string, expression, valueManager.getObjectGroupId(), false, false, false, false, 120, null);
        }

        @Override
        @NotNull
        protected RemoteObjectValue getRemoteObjectValue(@NotNull EvaluateOnCallFrameResult data) {
            Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
            return data.result();
        }

        @Override
        protected boolean getWasThrown(@NotNull EvaluateOnCallFrameResult data) {
            Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
            return data.getWasThrown();
        }

        @NotNull
        public WipCallFrameEvaluateContext withValueManager(@NotNull String objectGroup) {
            Intrinsics.checkParameterIsNotNull((Object)objectGroup, (String)"objectGroup");
            return new WipCallFrameEvaluateContext(new WipValueManager((WipVm)((WipValueManager)this.getValueManager()).getVm(), objectGroup));
        }

        public WipCallFrameEvaluateContext(WipValueManager valueManager) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)valueManager), (String)"valueManager");
            super(valueManager);
        }
    }
}

