/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.wip;

import com.intellij.util.Function;
import com.intellij.util.ThreeState;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.PromiseManager;
import org.jetbrains.debugger.Scope;
import org.jetbrains.debugger.values.FunctionValue;
import org.jetbrains.debugger.values.ValueType;
import org.jetbrains.jsonProtocol.Request;
import org.jetbrains.wip.WipObject;
import org.jetbrains.wip.WipSuspendContextManagerKt;
import org.jetbrains.wip.WipValueManager;
import org.jetbrains.wip.WipVm;
import org.jetbrains.wip.protocol.debugger.DebuggerKt;
import org.jetbrains.wip.protocol.debugger.FunctionDetailsValue;
import org.jetbrains.wip.protocol.debugger.GetFunctionDetailsResult;
import org.jetbrains.wip.protocol.debugger.ScopeValue;
import org.jetbrains.wip.protocol.runtime.RemoteObjectValue;

class WipFunction
extends WipObject
implements FunctionValue {
    private static final PromiseManager<WipFunction, FunctionValue> FUNCTION_DETAILS_LOADER = new PromiseManager<WipFunction, FunctionValue>(WipFunction.class){

        @NotNull
        public Promise<FunctionValue> load(final @NotNull WipFunction function) {
            if (function == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "org/jetbrains/wip/WipFunction$1", "load"));
            }
            Promise promise2 = ((WipVm)((WipValueManager)function.getChildrenManager().valueManager).getVm()).getCommandProcessor().send((Request)DebuggerKt.GetFunctionDetails(function.getRefId())).then((Function)new Function<GetFunctionDetailsResult, FunctionValue>(){

                public FunctionValue fun(GetFunctionDetailsResult result) {
                    function.value = result.details();
                    return function;
                }
            });
            if (promise2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/wip/WipFunction$1", "load"));
            }
            return promise2;
        }
    };
    private volatile Promise<FunctionValue> resolvedFunction;
    private FunctionDetailsValue value;

    WipFunction(@NotNull RemoteObjectValue valueData, @NotNull WipValueManager valueLoader) {
        if (valueData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueData", "org/jetbrains/wip/WipFunction", "<init>"));
        }
        if (valueLoader == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueLoader", "org/jetbrains/wip/WipFunction", "<init>"));
        }
        super(ValueType.FUNCTION, valueData, valueLoader);
    }

    @NotNull
    public Promise<FunctionValue> resolve() {
        Promise promise2 = FUNCTION_DETAILS_LOADER.get((Object)this);
        if (promise2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/wip/WipFunction", "resolve"));
        }
        return promise2;
    }

    public String getScriptId() {
        return this.value.getLocation().scriptId();
    }

    public int getOpenParenLine() {
        return this.value.getLocation().getLineNumber();
    }

    public int getOpenParenColumn() {
        return this.value.getLocation().getColumnNumber();
    }

    @Nullable
    public Scope[] getScopes() {
        List<ScopeValue> data = this.value.getScopeChain();
        return data == null ? null : WipSuspendContextManagerKt.createScopes(data, null, this.getRefId(), (WipValueManager)this.getChildrenManager().valueManager);
    }

    @NotNull
    public ThreeState hasScopes() {
        ThreeState threeState = ThreeState.UNSURE;
        if (threeState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/wip/WipFunction", "hasScopes"));
        }
        return threeState;
    }
}

