/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.wip;

import com.intellij.util.Function;
import com.intellij.util.Url;
import com.intellij.util.UrlImpl;
import com.intellij.util.Urls;
import com.intellij.util.containers.UtilKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.debugger.CallFrame;
import org.jetbrains.debugger.Script;
import org.jetbrains.debugger.ScriptManagerBaseEx;
import org.jetbrains.debugger.ScriptManagerKt;
import org.jetbrains.debugger.values.FunctionValue;
import org.jetbrains.jsonProtocol.Request;
import org.jetbrains.rpc.CommandProcessorKt;
import org.jetbrains.v8.liveEditProtocol.HotSwapScriptManager;
import org.jetbrains.v8.liveEditProtocol.LiveEditResult;
import org.jetbrains.v8.liveEditProtocol.ScriptLiveChangeResult;
import org.jetbrains.v8.protocol.V8ProtocolUtilKt;
import org.jetbrains.wip.WipCallFrame;
import org.jetbrains.wip.WipCommandProcessor;
import org.jetbrains.wip.WipFunction;
import org.jetbrains.wip.WipNetworkManager;
import org.jetbrains.wip.WipScript;
import org.jetbrains.wip.WipScriptManager;
import org.jetbrains.wip.WipSuspendContextManager;
import org.jetbrains.wip.WipVm;
import org.jetbrains.wip.protocol.debugger.CallFrameValue;
import org.jetbrains.wip.protocol.debugger.DebuggerKt;
import org.jetbrains.wip.protocol.debugger.ScriptParsedEventData;
import org.jetbrains.wip.protocol.debugger.SetScriptSourceResult;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0002\b\u0002\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\u00022\u0006\u0010\f\u001a\u00020\rH\u0016J\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J#\u0010\u0011\u001a\u0015\u0012\f\u0012\n \u0013*\u0004\u0018\u00010\u00120\u00120\u000e\u00a2\u0006\u0002\b\u00142\u0006\u0010\t\u001a\u00020\u0002H\u0014J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0012H\u0014J\u000e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bJ&\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001d0\u000e2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\bH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lorg/jetbrains/wip/WipScriptManager;", "Lorg/jetbrains/debugger/ScriptManagerBaseEx;", "Lorg/jetbrains/wip/WipScript;", "Lorg/jetbrains/v8/liveEditProtocol/HotSwapScriptManager;", "vm", "Lorg/jetbrains/wip/WipVm;", "(Lorg/jetbrains/wip/WipVm;)V", "containsScript", "", "script", "Lorg/jetbrains/debugger/Script;", "getScript", "frame", "Lorg/jetbrains/debugger/CallFrame;", "Lorg/jetbrains/concurrency/Promise;", "function", "Lorg/jetbrains/debugger/values/FunctionValue;", "loadScriptSource", "", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "rawUrlToOurUrl", "Lcom/intellij/util/Url;", "rawUrl", "scriptParsed", "", "data", "Lorg/jetbrains/wip/protocol/debugger/ScriptParsedEventData;", "setSourceOnRemote", "Lorg/jetbrains/v8/liveEditProtocol/ScriptLiveChangeResult;", "newSource", "", "preview", "wip-backend"})
public final class WipScriptManager
extends ScriptManagerBaseEx<WipScript>
implements HotSwapScriptManager {
    private final WipVm vm;

    public boolean containsScript(@NotNull Script script) {
        Intrinsics.checkParameterIsNotNull((Object)script, (String)"script");
        return script instanceof WipScript && this.getIdToScript().containsKey(((WipScript)script).id);
    }

    @NotNull
    protected Promise<String> loadScriptSource(@NotNull WipScript script) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)script), (String)"script");
        WipCommandProcessor wipCommandProcessor = this.vm.getCommandProcessor();
        CharSequence charSequence = script.id;
        Intrinsics.checkExpressionValueIsNotNull((Object)charSequence, (String)"script.id");
        return wipCommandProcessor.send((Request)DebuggerKt.GetScriptSource(charSequence)).then((Function)loadScriptSource.1.INSTANCE);
    }

    @Override
    @NotNull
    public Promise<ScriptLiveChangeResult> setSourceOnRemote(@NotNull Script script, @NotNull CharSequence newSource, boolean preview) {
        Intrinsics.checkParameterIsNotNull((Object)script, (String)"script");
        Intrinsics.checkParameterIsNotNull((Object)newSource, (String)"newSource");
        WipCommandProcessor wipCommandProcessor = this.vm.getCommandProcessor();
        Script script2 = script;
        if (script2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.wip.WipScript");
        }
        CharSequence charSequence = ((WipScript)script2).id;
        Intrinsics.checkExpressionValueIsNotNull((Object)charSequence, (String)"(script as WipScript).id");
        Promise promise2 = wipCommandProcessor.send((Request)DebuggerKt.SetScriptSource(charSequence, newSource, preview)).then(new Function<? super T, ? extends SUB_RESULT>(this, preview){
            final /* synthetic */ WipScriptManager this$0;
            final /* synthetic */ boolean $preview;

            @NotNull
            public final ScriptLiveChangeResult fun(SetScriptSourceResult it) {
                List<CallFrameValue> callFrames;
                if (!this.$preview && !UtilKt.isNullOrEmpty(callFrames = it.getCallFrames())) {
                    WipSuspendContextManager wipSuspendContextManager = WipScriptManager.access$getVm$p(this.this$0).getSuspendContextManager();
                    List<CallFrameValue> list = callFrames;
                    if (list == null) {
                        Intrinsics.throwNpe();
                    }
                    wipSuspendContextManager.updateStackTrace(list);
                }
                SetScriptSourceResult.Result result = it.getResult();
                if (result == null) {
                    Intrinsics.throwNpe();
                }
                SetScriptSourceResult.Result data = result;
                LiveEditResult liveEditResult = V8ProtocolUtilKt.getLIVE_EDIT().parseLiveEditResult(data.getDeferredReader());
                Intrinsics.checkExpressionValueIsNotNull((Object)liveEditResult, (String)"LIVE_EDIT.parseLiveEditResult(data.deferredReader)");
                return new ScriptLiveChangeResult(liveEditResult);
            }
            {
                this.this$0 = wipScriptManager;
                this.$preview = bl;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)promise2, (String)"vm.commandProcessor.send\u2026.deferredReader))\n      }");
        return promise2;
    }

    @NotNull
    public Promise<Script> getScript(@NotNull FunctionValue function) {
        Intrinsics.checkParameterIsNotNull((Object)function, (String)"function");
        Promise promise2 = function.resolve().then(new Function<? super T, ? extends SUB_RESULT>(this){
            final /* synthetic */ WipScriptManager this$0;

            @Nullable
            public final WipScript fun(FunctionValue it) {
                FunctionValue functionValue = it;
                if (functionValue == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.wip.WipFunction");
                }
                String string = ((WipFunction)functionValue).getScriptId();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"(it as WipFunction).scriptId");
                return (WipScript)this.this$0.findScriptById(string);
            }
            {
                this.this$0 = wipScriptManager;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)promise2, (String)"function.resolve()\n    .\u2026 WipFunction).scriptId) }");
        return promise2;
    }

    @Nullable
    public WipScript getScript(@NotNull CallFrame frame) {
        Intrinsics.checkParameterIsNotNull((Object)frame, (String)"frame");
        CallFrame callFrame = frame;
        if (callFrame == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.wip.WipCallFrame");
        }
        String string = ((WipCallFrame)callFrame).getScriptId();
        if (string == null) {
            Intrinsics.throwNpe();
        }
        return (WipScript)this.findScriptById(string);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @NotNull
    protected Url rawUrlToOurUrl(@NotNull String rawUrl) {
        Url url;
        String absoluteUrl;
        Intrinsics.checkParameterIsNotNull((Object)rawUrl, (String)"rawUrl");
        if (StringsKt.startsWith$default((String)rawUrl, (String)"extensions::", (boolean)false, (int)2, null)) {
            return (Url)new UrlImpl(rawUrl);
        }
        Url url2 = Urls.parseEncoded((String)rawUrl);
        if (url2 != null) {
            return url2;
        }
        Url tabUrl = this.vm.getCurrentUrl();
        if (tabUrl == null) {
            CommandProcessorKt.getLOG().warn("current url null while process script parsed " + rawUrl);
            Url url3 = Urls.newFromEncoded((String)rawUrl);
            Intrinsics.checkExpressionValueIsNotNull((Object)url3, (String)"Urls.newFromEncoded(rawUrl)");
            return url3;
        }
        String documentUrl = tabUrl.trimParameters().toExternalForm();
        int lastSlash = StringsKt.lastIndexOf$default((CharSequence)documentUrl, (char)'/', (int)0, (boolean)false, (int)6, null);
        if (lastSlash == -1) {
            absoluteUrl = documentUrl + "/" + rawUrl;
        } else {
            void endIndex$iv;
            void startIndex$iv;
            void $receiver$iv;
            String string = documentUrl;
            boolean bl = false;
            int n = lastSlash + 1;
            StringBuilder stringBuilder = new StringBuilder();
            void v1 = $receiver$iv;
            if (v1 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string2 = ((String)v1).substring((int)startIndex$iv, (int)endIndex$iv);
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            String string3 = string2;
            absoluteUrl = stringBuilder.append(string3).append(rawUrl).toString();
        }
        Url parsedUrl = Urls.parseEncoded((String)absoluteUrl);
        if (parsedUrl != null) {
            WipNetworkManager wipNetworkManager = this.vm.getNetworkManager();
            String string = parsedUrl.trimParameters().toExternalForm();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"parsedUrl.trimParameters().toExternalForm()");
            if (wipNetworkManager.wasRequested(string)) {
                url = parsedUrl;
                return url;
            }
        }
        url = (Url)new UrlImpl(rawUrl);
        return url;
    }

    /*
     * WARNING - void declaration
     */
    public final void scriptParsed(@NotNull ScriptParsedEventData data) {
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        String id = data.scriptId();
        CharSequence charSequence = data.url();
        Url url = $receiver$iv == null || $receiver$iv.length() == 0 ? Urls.newUri((String)ScriptManagerKt.VM_SCHEME, (String)id) : this.rawUrlToOurUrl(data.url());
        WipScript script = new WipScript(id, data.isContentScript() ? Script.Type.EXTENSION : Script.Type.NORMAL, url, data.getStartLine(), data.getStartColumn(), data.getEndLine());
        if (this.getIdToScript().putIfAbsent(id, script) != null) {
            return;
        }
        if (url.getScheme() != null || !StringsKt.startsWith$default((String)data.url(), (String)"extensions::", (boolean)false, (int)2, null)) {
            this.vm.getDebugListener().scriptAdded((Script)script, data.getSourceMapURL());
        }
    }

    public WipScriptManager(@NotNull WipVm vm) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)vm), (String)"vm");
        this.vm = vm;
    }

    @NotNull
    public static final /* synthetic */ WipVm access$getVm$p(WipScriptManager $this) {
        return $this.vm;
    }
}

