/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.wip;

import com.intellij.util.Function;
import com.intellij.util.SmartList;
import com.intellij.util.containers.UtilKt;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.AsyncValueLoader;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.debugger.Breakpoint;
import org.jetbrains.debugger.ExceptionData;
import org.jetbrains.debugger.SuspendContextBase;
import org.jetbrains.debugger.values.ValueManager;
import org.jetbrains.io.JsonReaderEx;
import org.jetbrains.jsonProtocol.Request;
import org.jetbrains.rpc.CommandProcessorKt;
import org.jetbrains.wip.WipBreakpoint;
import org.jetbrains.wip.WipCallFrame;
import org.jetbrains.wip.WipCommandProcessor;
import org.jetbrains.wip.WipExceptionData;
import org.jetbrains.wip.WipReaderService;
import org.jetbrains.wip.WipSuspendContext;
import org.jetbrains.wip.WipValueManager;
import org.jetbrains.wip.WipVm;
import org.jetbrains.wip.protocol.WipProtocolReader;
import org.jetbrains.wip.protocol.debugger.CallFrameValue;
import org.jetbrains.wip.protocol.debugger.DebuggerKt;
import org.jetbrains.wip.protocol.debugger.GetBacktraceResult;
import org.jetbrains.wip.protocol.debugger.LocationValue;
import org.jetbrains.wip.protocol.debugger.PausedEventData;
import org.jetbrains.wip.protocol.debugger.ScopeValue;
import org.jetbrains.wip.protocol.runtime.RuntimeKt;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000g\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000*\u0001\u001e\b\u0000\u0018\u00002\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0001B\u001d\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ!\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00040\f2\f\u0010,\u001a\b\u0012\u0004\u0012\u00020-0\u000fH\u0002\u00a2\u0006\u0002\u0010.J\n\u0010/\u001a\u0006\u0012\u0002\b\u00030\u001aJ\u0014\u00100\u001a\u0002012\f\u0010,\u001a\b\u0012\u0004\u0012\u00020-0\u000fR\u001c\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\f8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0004\n\u0002\u0010\rR\u001a\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u001c\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R \u0010\u0019\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\f0\u001a8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u0010\u0010\u001d\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u001fR\u0014\u0010 \u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"R\u0016\u0010#\u001a\n\u0012\u0004\u0012\u00020$\u0018\u00010\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010&\u001a\u0004\u0018\u00010\u00042\b\u0010%\u001a\u0004\u0018\u00010\u00048\u0016@RX\u0097\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010(\"\u0004\b)\u0010*\u00a8\u00062"}, d2={"Lorg/jetbrains/wip/WipSuspendContext;", "Lorg/jetbrains/debugger/SuspendContextBase;", "Lorg/jetbrains/wip/WipVm;", "Lorg/jetbrains/wip/WipValueManager;", "Lorg/jetbrains/wip/WipCallFrame;", "vm", "data", "Lorg/jetbrains/wip/protocol/debugger/PausedEventData;", "explicitPaused", "", "(Lorg/jetbrains/wip/WipVm;Lorg/jetbrains/wip/protocol/debugger/PausedEventData;Z)V", "_frames", "", "[Lorg/jetbrains/wip/WipCallFrame;", "breakpointsHit", "", "Lorg/jetbrains/debugger/Breakpoint;", "getBreakpointsHit", "()Ljava/util/List;", "exceptionData", "Lorg/jetbrains/debugger/ExceptionData;", "getExceptionData", "()Lorg/jetbrains/debugger/ExceptionData;", "setExceptionData", "(Lorg/jetbrains/debugger/ExceptionData;)V", "frames", "Lorg/jetbrains/concurrency/Promise;", "getFrames", "()Lorg/jetbrains/concurrency/Promise;", "framesLoader", "org/jetbrains/wip/WipSuspendContext$framesLoader$1", "Lorg/jetbrains/wip/WipSuspendContext$framesLoader$1;", "hasUnresolvedBreakpointsHit", "getHasUnresolvedBreakpointsHit", "()Z", "hitBreakpoints", "", "value", "topFrame", "getTopFrame", "()Lorg/jetbrains/wip/WipCallFrame;", "setTopFrame", "(Lorg/jetbrains/wip/WipCallFrame;)V", "createFrames", "frameDataList", "Lorg/jetbrains/wip/protocol/debugger/CallFrameValue;", "(Ljava/util/List;)[Lorg/jetbrains/wip/WipCallFrame;", "reloadFrames", "setFrames", "", "wip-backend"})
public final class WipSuspendContext
extends SuspendContextBase<WipVm, WipValueManager, WipCallFrame> {
    private final List<String> hitBreakpoints;
    @Nullable
    private volatile WipCallFrame topFrame;
    private volatile WipCallFrame[] _frames;
    @Nullable
    private ExceptionData exceptionData;
    private final framesLoader.1 framesLoader;

    @Nullable
    public WipCallFrame getTopFrame() {
        return this.topFrame;
    }

    private void setTopFrame(WipCallFrame value) {
        this.topFrame = value;
    }

    @Nullable
    public ExceptionData getExceptionData() {
        return this.exceptionData;
    }

    public void setExceptionData(@Nullable ExceptionData exceptionData) {
        this.exceptionData = exceptionData;
    }

    @NotNull
    public Promise<WipCallFrame[]> getFrames() {
        Promise promise2 = this.framesLoader.get();
        Intrinsics.checkExpressionValueIsNotNull((Object)promise2, (String)"framesLoader.get()");
        return promise2;
    }

    public final void setFrames(@NotNull List<? extends CallFrameValue> frameDataList) {
        Intrinsics.checkParameterIsNotNull(frameDataList, (String)"frameDataList");
        WipCallFrame[] frames = this.createFrames(frameDataList);
        if (((Object[])frames).length > 0) {
            this.setTopFrame(frames[0]);
        }
        this._frames = frames;
        this.framesLoader.set(frames);
    }

    /*
     * WARNING - void declaration
     */
    private final WipCallFrame[] createFrames(List<? extends CallFrameValue> frameDataList) {
        int size$iv = frameDataList.size();
        WipCallFrame[] result$iv = new WipCallFrame[size$iv];
        int n = 0;
        int n2 = size$iv - 1;
        if (n <= n2) {
            void i$iv;
            do {
                void it;
                WipCallFrame wipCallFrame;
                void var6_6 = ++i$iv;
                void var10_8 = i$iv;
                WipCallFrame[] wipCallFrameArray = result$iv;
                wipCallFrameArray[var10_8] = wipCallFrame = new WipCallFrame((WipValueManager)this.getValueManager(), frameDataList.get((int)it));
            } while (i$iv != n2);
        }
        return (WipCallFrame[])((Object[])result$iv);
    }

    public boolean getHasUnresolvedBreakpointsHit() {
        if (UtilKt.isNullOrEmpty(this.hitBreakpoints)) {
            return false;
        }
        THashSet hitVmBreakpoints = new THashSet((Collection)this.hitBreakpoints);
        for (WipBreakpoint breakpoint : ((WipVm)((WipValueManager)this.getValueManager()).getVm()).getBreakpointManager().getBreakpoints()) {
            hitVmBreakpoints.remove((Object)breakpoint.getVmId());
        }
        Collection $receiver$iv = (Collection)hitVmBreakpoints;
        return !$receiver$iv.isEmpty();
    }

    @NotNull
    public List<Breakpoint> getBreakpointsHit() {
        Set breakpoints = ((WipVm)((WipValueManager)this.getValueManager()).getVm()).getBreakpointManager().getBreakpoints();
        if (this.hitBreakpoints != null) {
            SmartList result = new SmartList();
            for (WipBreakpoint breakpoint : breakpoints) {
                String vmId = breakpoint.getVmId();
                if (vmId == null || !this.hitBreakpoints.contains(vmId)) continue;
                result.add((Object)breakpoint);
            }
            return (List)result;
        }
        WipCallFrame wipCallFrame = this.getTopFrame();
        if (wipCallFrame == null) {
            return CollectionsKt.emptyList();
        }
        WipCallFrame topFrame = wipCallFrame;
        int line = topFrame.getLine();
        int column = topFrame.getColumn();
        List result = null;
        block1: for (WipBreakpoint breakpoint : breakpoints) {
            for (LocationValue actualLocation : breakpoint.getActualLocations()) {
                int actualColumnNumber = actualLocation.getColumnNumber();
                if (!Intrinsics.areEqual((Object)actualLocation.scriptId(), (Object)topFrame.getScriptId()) || actualLocation.getLineNumber() != line || actualColumnNumber != column && actualColumnNumber > 0) continue;
                if (result == null) {
                    result = (List)new SmartList();
                }
                WipBreakpoint wipBreakpoint = breakpoint;
                Intrinsics.checkExpressionValueIsNotNull((Object)((Object)wipBreakpoint), (String)"breakpoint");
                result.add(wipBreakpoint);
                continue block1;
            }
        }
        List list = result;
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    @NotNull
    public final Promise<?> reloadFrames() {
        this.framesLoader.markDirty();
        SmartList promises = new SmartList();
        if (this._frames == null) {
            Intrinsics.throwNpe();
        }
        WipCallFrame[] wipCallFrameArray = this._frames;
        for (int i = 0; i < wipCallFrameArray.length; ++i) {
            WipCallFrame frame = wipCallFrameArray[i];
            List<ScopeValue> list = frame.getScopesData();
            if (list == null) {
                Intrinsics.throwNpe();
            }
            for (ScopeValue scopeValue : list) {
                WipCommandProcessor wipCommandProcessor = ((WipVm)((WipValueManager)this.getValueManager()).getVm()).getCommandProcessor();
                String string = scopeValue.object().getObjectId();
                if (string == null) {
                    Intrinsics.throwNpe();
                }
                promises.add((Object)wipCommandProcessor.send((Request)RuntimeKt.ReleaseObject(string)));
            }
        }
        promises.add((Object)this.framesLoader.get());
        Promise promise2 = Promise.all((Collection)((Collection)promises));
        if (promise2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.concurrency.Promise<kotlin.Any>");
        }
        Promise promise3 = promise2.then(new Function<? super T, ? extends SUB_RESULT>(this){
            final /* synthetic */ WipSuspendContext this$0;

            public final void fun(Object it) {
                ((WipValueManager)this.this$0.getValueManager()).clearCaches();
            }
            {
                this.this$0 = wipSuspendContext;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)promise3, (String)"(Promise.all(promises) a\u2026ueManager.clearCaches() }");
        return promise3;
    }

    public WipSuspendContext(@NotNull WipVm vm, @NotNull PausedEventData data, boolean explicitPaused) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)vm), (String)"vm");
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        super((ValueManager)new WipValueManager(vm), explicitPaused);
        this.framesLoader = new AsyncValueLoader<WipCallFrame[]>(this){
            final /* synthetic */ WipSuspendContext this$0;

            @NotNull
            protected Promise<WipCallFrame[]> load(@NotNull AsyncPromise<WipCallFrame[]> result) {
                Intrinsics.checkParameterIsNotNull(result, (String)"result");
                return ((WipVm)((WipValueManager)this.this$0.getValueManager()).getVm()).getCommandProcessor().send((Request)DebuggerKt.GetBacktrace()).then((Function)new Function<? super T, ? extends SUB_RESULT>(this){
                    final /* synthetic */ framesLoader.1 this$0;

                    /*
                     * WARNING - void declaration
                     */
                    @NotNull
                    public final WipCallFrame[] fun(GetBacktraceResult it) {
                        void var3_3;
                        List<CallFrameValue> framesInfo = it.callFrames();
                        WipCallFrame[] wipCallFrameArray = WipSuspendContext.access$get_frames$p(this.this$0.this$0);
                        if (wipCallFrameArray == null) {
                            Intrinsics.throwNpe();
                        }
                        WipCallFrame[] existingFrames = wipCallFrameArray;
                        CommandProcessorKt.getLOG().assertTrue(framesInfo.size() == ((Object[])existingFrames).length);
                        IntRange intRange = CollectionsKt.getIndices((Collection)framesInfo);
                        int n = intRange.getFirst();
                        int n2 = intRange.getLast();
                        if (n <= n2) {
                            while (true) {
                                void i;
                                existingFrames[i].reinit(framesInfo.get((int)i), (WipValueManager)this.this$0.this$0.getValueManager());
                                if (i == n2) break;
                                ++i;
                            }
                        }
                        return var3_3;
                    }
                    {
                        this.this$0 = var1_1;
                    }
                });
            }
            {
                this.this$0 = $outer;
            }
        };
        PausedEventData.Data additionalData = data.getData();
        if (data.reason() == PausedEventData.Reason.EXCEPTION && additionalData != null) {
            WipValueManager wipValueManager = (WipValueManager)this.getValueManager();
            WipProtocolReader wipProtocolReader = WipReaderService.get();
            JsonReaderEx jsonReaderEx = additionalData.getDeferredReader();
            Intrinsics.checkExpressionValueIsNotNull((Object)jsonReaderEx, (String)"additionalData.deferredReader");
            this.setExceptionData(new WipExceptionData(wipValueManager.createValue(wipProtocolReader.parseRemoteObjectValue(jsonReaderEx))));
        } else {
            this.setExceptionData(null);
        }
        this.setFrames(data.callFrames());
        this.hitBreakpoints = data.getHitBreakpoints();
    }

    @Nullable
    public static final /* synthetic */ WipCallFrame[] access$get_frames$p(WipSuspendContext $this) {
        return $this._frames;
    }

    public static final /* synthetic */ void access$set_frames$p(WipSuspendContext $this, @Nullable WipCallFrame[] wipCallFrameArray) {
        $this._frames = wipCallFrameArray;
    }
}

