/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.wip;

import com.intellij.util.Function;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncFunction;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.PromiseKt;
import org.jetbrains.debugger.CallFrame;
import org.jetbrains.debugger.DebugEventListener;
import org.jetbrains.debugger.StepAction;
import org.jetbrains.debugger.SuspendContext;
import org.jetbrains.debugger.SuspendContextManagerBase;
import org.jetbrains.io.JsonReaderEx;
import org.jetbrains.jsonProtocol.EventMap;
import org.jetbrains.jsonProtocol.EventType;
import org.jetbrains.jsonProtocol.JsonReaders;
import org.jetbrains.jsonProtocol.Request;
import org.jetbrains.wip.EvaluateHack;
import org.jetbrains.wip.WipCallFrame;
import org.jetbrains.wip.WipCommandProcessor;
import org.jetbrains.wip.WipSuspendContext;
import org.jetbrains.wip.WipSuspendContextManager;
import org.jetbrains.wip.WipSuspendContextManagerKt;
import org.jetbrains.wip.WipValueManager;
import org.jetbrains.wip.WipVm;
import org.jetbrains.wip.protocol.ProtocolResponseReader;
import org.jetbrains.wip.protocol.debugger.CallFrameValue;
import org.jetbrains.wip.protocol.debugger.DebuggerKt;
import org.jetbrains.wip.protocol.debugger.PausedEventData;
import org.jetbrains.wip.protocol.debugger.RestartFrameResult;
import org.jetbrains.wip.protocol.debugger.ResumedEventData;
import org.jetbrains.wip.protocol.page.PageKt;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u001c\u0010\u0017\u001a\u0006\u0012\u0002\b\u00030\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u000e\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001e0\u0018H\u0014J\b\u0010\u001f\u001a\u00020\u001eH\u0002J+\u0010 \u001a\u0015\u0012\f\u0012\n !*\u0004\u0018\u00010\u00120\u00120\u0018\u00a2\u0006\u0002\b\"2\u0006\u0010\u0015\u001a\u00020\u00032\u0006\u0010#\u001a\u00020\u0002H\u0014J\u0012\u0010$\u001a\u00020\u001e2\b\u0010%\u001a\u0004\u0018\u00010&H\u0016J\u0014\u0010'\u001a\u00020\u001e2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020*0)R\u0014\u0010\u0007\u001a\u00020\bX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\u00020\u0012X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0013R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lorg/jetbrains/wip/WipSuspendContextManager;", "Lorg/jetbrains/debugger/SuspendContextManagerBase;", "Lorg/jetbrains/wip/WipSuspendContext;", "Lorg/jetbrains/wip/WipCallFrame;", "vm", "Lorg/jetbrains/wip/WipVm;", "(Lorg/jetbrains/wip/WipVm;)V", "debugListener", "Lorg/jetbrains/debugger/DebugEventListener;", "getDebugListener", "()Lorg/jetbrains/debugger/DebugEventListener;", "evaluateHack", "Lorg/jetbrains/wip/EvaluateHack;", "getEvaluateHack", "()Lorg/jetbrains/wip/EvaluateHack;", "hasOverlay", "Ljava/util/concurrent/atomic/AtomicBoolean;", "isRestartFrameSupported", "", "()Z", "canRestartFrame", "callFrame", "Lorg/jetbrains/debugger/CallFrame;", "continueVm", "Lorg/jetbrains/concurrency/Promise;", "stepAction", "Lorg/jetbrains/debugger/StepAction;", "stepCount", "", "doSuspend", "", "removeOverlay", "restartFrame", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "currentContext", "setOverlayMessage", "message", "", "updateStackTrace", "callFrames", "", "Lorg/jetbrains/wip/protocol/debugger/CallFrameValue;", "wip-backend"})
public final class WipSuspendContextManager
extends SuspendContextManagerBase<WipSuspendContext, WipCallFrame> {
    private final AtomicBoolean hasOverlay;
    @NotNull
    private final EvaluateHack evaluateHack;
    private final boolean isRestartFrameSupported = true;
    @NotNull
    private final DebugEventListener debugListener;
    private final WipVm vm;

    @NotNull
    public final EvaluateHack getEvaluateHack() {
        return this.evaluateHack;
    }

    public boolean isRestartFrameSupported() {
        return this.isRestartFrameSupported;
    }

    @NotNull
    protected DebugEventListener getDebugListener() {
        return this.debugListener;
    }

    @NotNull
    protected Promise<Boolean> restartFrame(@NotNull WipCallFrame callFrame, @NotNull WipSuspendContext currentContext) {
        Intrinsics.checkParameterIsNotNull((Object)callFrame, (String)"callFrame");
        Intrinsics.checkParameterIsNotNull((Object)((Object)currentContext), (String)"currentContext");
        WipCommandProcessor wipCommandProcessor = this.vm.getCommandProcessor();
        String string = callFrame.getId();
        if (string == null) {
            Intrinsics.throwNpe();
        }
        return wipCommandProcessor.send((Request)DebuggerKt.RestartFrame(string)).thenAsync(new AsyncFunction<? super T, SUB_RESULT>(this, currentContext){
            final /* synthetic */ WipSuspendContextManager this$0;
            final /* synthetic */ WipSuspendContext $currentContext;

            @NotNull
            public final Promise<Boolean> fun(RestartFrameResult it) {
                Promise promise2;
                if (Intrinsics.areEqual((Object)this.this$0.getContext(), (Object)((Object)this.$currentContext)) ^ true) {
                    promise2 = PromiseKt.resolvedPromise((Object)false);
                } else {
                    Promise promise3;
                    if (JsonReaders.findBooleanField((String)"stack_update_needs_step_in", (JsonReaderEx)it.result().getDeferredReader())) {
                        Promise<?> promise4 = this.this$0.continueVm(StepAction.IN, 1);
                        if (promise4 == null) {
                            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.concurrency.Promise<kotlin.Any>");
                        }
                        promise3 = promise4.then((Function)restartFrame.1.INSTANCE);
                    } else {
                        this.$currentContext.setFrames(it.callFrames());
                        promise3 = PromiseKt.resolvedPromise((Object)false);
                    }
                    promise2 = promise3;
                    Intrinsics.checkExpressionValueIsNotNull((Object)promise3, (String)"if (JsonReaders.findBool\u2026vedPromise(false)\n      }");
                }
                return promise2;
            }
            {
                this.this$0 = wipSuspendContextManager;
                this.$currentContext = wipSuspendContext;
            }
        });
    }

    public boolean canRestartFrame(@NotNull CallFrame callFrame) {
        Intrinsics.checkParameterIsNotNull((Object)callFrame, (String)"callFrame");
        return this.vm.getScriptManager().getScript(callFrame) != null;
    }

    public final void updateStackTrace(@NotNull List<? extends CallFrameValue> callFrames) {
        Unit unit;
        Intrinsics.checkParameterIsNotNull(callFrames, (String)"callFrames");
        WipSuspendContext wipSuspendContext = (WipSuspendContext)((Object)this.getContextRef().get());
        if (wipSuspendContext != null) {
            wipSuspendContext.setFrames(callFrames);
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
    }

    @NotNull
    protected Promise<Unit> doSuspend() {
        return this.vm.getCommandProcessor().send((Request)DebuggerKt.Pause());
    }

    public void setOverlayMessage(@Nullable String message) {
        if (this.hasOverlay.compareAndSet(false, true)) {
            this.vm.getCommandProcessor().send((Request)PageKt.SetOverlayMessage(message));
        }
    }

    @NotNull
    public Promise<?> continueVm(@NotNull StepAction stepAction, int stepCount) {
        Intrinsics.checkParameterIsNotNull((Object)stepAction, (String)"stepAction");
        ((WipValueManager)((WipSuspendContext)this.getContextOrFail()).getValueManager()).markObsolete();
        this.removeOverlay();
        return this.vm.getCommandProcessor().send((Request)WipSuspendContextManagerKt.access$sdkStepToProtocolStep(stepAction));
    }

    private final void removeOverlay() {
        if (this.hasOverlay.compareAndSet(true, false)) {
            this.vm.getCommandProcessor().send((Request)PageKt.SetOverlayMessage$default(null, 1, null));
        }
    }

    public WipSuspendContextManager(@NotNull WipVm vm) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)vm), (String)"vm");
        this.vm = vm;
        this.hasOverlay = new AtomicBoolean();
        this.evaluateHack = new EvaluateHack(this.vm);
        this.isRestartFrameSupported = true;
        this.debugListener = this.vm.getDebugListener();
        EventMap<ProtocolResponseReader> eventMap = this.vm.getCommandProcessor().getEventMap();
        eventMap.add((EventType)PausedEventData.TYPE, (Function1)new Function1<PausedEventData, Unit>(){

            public final void invoke(@NotNull PausedEventData it) {
                Unit unit;
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                AsyncPromise callback = this.getSuspendCallback().getAndSet(null);
                WipSuspendContext context = new WipSuspendContext(vm, it, callback != null);
                this.setContext(context);
                AsyncPromise asyncPromise = callback;
                if (asyncPromise != null) {
                    asyncPromise.setResult(null);
                    unit = Unit.INSTANCE;
                } else {
                    unit = null;
                }
                vm.getDebugListener().suspended((SuspendContext)context);
            }
        });
        eventMap.add((EventType)ResumedEventData.TYPE, (Function1)new Function1<ResumedEventData, Unit>(){

            public final void invoke(@Nullable ResumedEventData it) {
                this.removeOverlay();
                this.dismissContext();
            }
        });
    }
}

