/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.wip;

import com.intellij.util.Url;
import com.intellij.util.Urls;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.debugger.DebugEventListener;
import org.jetbrains.debugger.EvaluateContext;
import org.jetbrains.debugger.ExceptionCatchMode;
import org.jetbrains.debugger.VmBase;
import org.jetbrains.jsonProtocol.EventMap;
import org.jetbrains.jsonProtocol.EventType;
import org.jetbrains.jsonProtocol.Request;
import org.jetbrains.wip.WipBreakpointManager;
import org.jetbrains.wip.WipCommandProcessor;
import org.jetbrains.wip.WipGlobalEvaluateContext;
import org.jetbrains.wip.WipNetworkManager;
import org.jetbrains.wip.WipScriptManager;
import org.jetbrains.wip.WipSuspendContextManager;
import org.jetbrains.wip.WipValueManager;
import org.jetbrains.wip.WipVm$WhenMappings;
import org.jetbrains.wip.protocol.ProtocolResponseReader;
import org.jetbrains.wip.protocol.console.ConsoleKt;
import org.jetbrains.wip.protocol.debugger.BreakpointResolvedEventData;
import org.jetbrains.wip.protocol.debugger.DebuggerKt;
import org.jetbrains.wip.protocol.debugger.GlobalObjectClearedEventData;
import org.jetbrains.wip.protocol.debugger.ScriptParsedEventData;
import org.jetbrains.wip.protocol.debugger.State;
import org.jetbrains.wip.protocol.page.FrameNavigatedEventData;
import org.jetbrains.wip.protocol.page.FrameValue;
import org.jetbrains.wip.protocol.page.PageKt;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\n\u0010,\u001a\u0004\u0018\u00010-H\u0014J\f\u0010.\u001a\b\u0012\u0004\u0012\u0002000/J\u0006\u00101\u001a\u000200J\f\u00102\u001a\b\u0012\u0004\u0012\u0002000/J\f\u00103\u001a\b\u0012\u0004\u0012\u0002000/J\u0010\u00104\u001a\u0002052\u0006\u00106\u001a\u00020\u0006H\u0002J\u0014\u00107\u001a\u0006\u0012\u0002\b\u00030/2\u0006\u00106\u001a\u00020\u0006H\u0016J\u0016\u00108\u001a\u0002002\u0006\u00109\u001a\u00020\u00182\u0006\u0010:\u001a\u00020;J\u0014\u0010<\u001a\u00020;2\n\u0010=\u001a\u0006\u0012\u0002\b\u00030>H$R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0007\u001a\u00020\b8\u0016X\u0097\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\t\u0010\n\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R*\u0010\u0013\u001a\u0004\u0018\u00010\u00122\b\u0010\u0011\u001a\u0004\u0018\u00010\u00128\u0006@DX\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R(\u0010\u0019\u001a\u0004\u0018\u00010\u00182\b\u0010\u0011\u001a\u0004\u0018\u00010\u0018@BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u0011\u0010\u001e\u001a\u00020\u001f\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u001c\u0010\"\u001a\u00020#8\u0016X\u0097\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b$\u0010\n\u001a\u0004\b%\u0010&R\u001c\u0010'\u001a\u00020(8\u0016X\u0097\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b)\u0010\n\u001a\u0004\b*\u0010+\u00a8\u0006?"}, d2={"Lorg/jetbrains/wip/WipVm;", "Lorg/jetbrains/debugger/VmBase;", "tabListener", "Lorg/jetbrains/debugger/DebugEventListener;", "(Lorg/jetbrains/debugger/DebugEventListener;)V", "breakOnExceptionMode", "Lorg/jetbrains/debugger/ExceptionCatchMode;", "breakpointManager", "Lorg/jetbrains/wip/WipBreakpointManager;", "breakpointManager$annotations", "()V", "getBreakpointManager", "()Lorg/jetbrains/wip/WipBreakpointManager;", "commandProcessor", "Lorg/jetbrains/wip/WipCommandProcessor;", "getCommandProcessor", "()Lorg/jetbrains/wip/WipCommandProcessor;", "<set-?>", "Lcom/intellij/util/Url;", "currentUrl", "getCurrentUrl", "()Lcom/intellij/util/Url;", "setCurrentUrl", "(Lcom/intellij/util/Url;)V", "", "frameId", "getFrameId", "()Ljava/lang/String;", "setFrameId", "(Ljava/lang/String;)V", "networkManager", "Lorg/jetbrains/wip/WipNetworkManager;", "getNetworkManager", "()Lorg/jetbrains/wip/WipNetworkManager;", "scriptManager", "Lorg/jetbrains/wip/WipScriptManager;", "scriptManager$annotations", "getScriptManager", "()Lorg/jetbrains/wip/WipScriptManager;", "suspendContextManager", "Lorg/jetbrains/wip/WipSuspendContextManager;", "suspendContextManager$annotations", "getSuspendContextManager", "()Lorg/jetbrains/wip/WipSuspendContextManager;", "computeEvaluateContext", "Lorg/jetbrains/debugger/EvaluateContext;", "enableConsole", "Lorg/jetbrains/concurrency/Promise;", "", "enableDebugger", "enableNetwork", "enablePage", "sdkToWipCatchMode", "Lorg/jetbrains/wip/protocol/debugger/State;", "catchMode", "setBreakOnException", "updateUrl", "url", "silent", "", "write", "message", "Lorg/jetbrains/jsonProtocol/Request;", "wip-backend"})
public abstract class WipVm
extends VmBase {
    @NotNull
    private final WipCommandProcessor commandProcessor;
    @NotNull
    private final WipScriptManager scriptManager;
    @NotNull
    private final WipBreakpointManager breakpointManager;
    @NotNull
    private final WipSuspendContextManager suspendContextManager;
    @NotNull
    private final WipNetworkManager networkManager;
    private ExceptionCatchMode breakOnExceptionMode;
    @Nullable
    private volatile Url currentUrl;
    @Nullable
    private String frameId;

    @NotNull
    public final WipCommandProcessor getCommandProcessor() {
        return this.commandProcessor;
    }

    private static final /* synthetic */ void scriptManager$annotations() {
    }

    @NotNull
    public WipScriptManager getScriptManager() {
        return this.scriptManager;
    }

    private static final /* synthetic */ void breakpointManager$annotations() {
    }

    @NotNull
    public WipBreakpointManager getBreakpointManager() {
        return this.breakpointManager;
    }

    private static final /* synthetic */ void suspendContextManager$annotations() {
    }

    @NotNull
    public WipSuspendContextManager getSuspendContextManager() {
        return this.suspendContextManager;
    }

    @NotNull
    public final WipNetworkManager getNetworkManager() {
        return this.networkManager;
    }

    @Nullable
    public final Url getCurrentUrl() {
        return this.currentUrl;
    }

    protected final void setCurrentUrl(@Nullable Url url) {
        this.currentUrl = url;
    }

    @Nullable
    public final String getFrameId() {
        return this.frameId;
    }

    private final void setFrameId(String string) {
        this.frameId = string;
    }

    protected abstract boolean write(@NotNull Request<?> var1);

    public final void enableDebugger() {
        this.commandProcessor.send((Request)DebuggerKt.Enable());
    }

    @NotNull
    public final Promise<Unit> enableConsole() {
        return this.commandProcessor.send((Request)ConsoleKt.Enable());
    }

    @NotNull
    public final Promise<Unit> enablePage() {
        return this.commandProcessor.send((Request)PageKt.Enable());
    }

    @NotNull
    public final Promise<Unit> enableNetwork() {
        return this.networkManager.enable(this.commandProcessor);
    }

    public final void updateUrl(@NotNull String url, boolean silent) {
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        this.currentUrl = Urls.newFromEncoded((String)url);
        if (silent) {
            return;
        }
        this.getScriptManager().clear(this.getDebugListener());
        this.getBreakpointManager().clearNonProvisionalBreakpoints();
        this.getDebugListener().navigated(url);
        this.getSuspendContextManager().getEvaluateHack().pageReloaded$wip_backend();
    }

    @NotNull
    public Promise<?> setBreakOnException(@NotNull ExceptionCatchMode catchMode) {
        Intrinsics.checkParameterIsNotNull((Object)catchMode, (String)"catchMode");
        this.breakOnExceptionMode = catchMode;
        return this.commandProcessor.send((Request)DebuggerKt.SetPauseOnExceptions(this.sdkToWipCatchMode(catchMode)));
    }

    private final State sdkToWipCatchMode(ExceptionCatchMode catchMode) {
        switch (WipVm$WhenMappings.$EnumSwitchMapping$0[catchMode.ordinal()]) {
            case 1: {
                return State.ALL;
            }
            case 2: {
                return State.UNCAUGHT;
            }
            case 3: {
                return State.NONE;
            }
        }
        throw (Throwable)new IllegalArgumentException(catchMode.name());
    }

    @Nullable
    protected EvaluateContext computeEvaluateContext() {
        return (EvaluateContext)new WipGlobalEvaluateContext(new WipValueManager(this, "ce"));
    }

    public WipVm(@NotNull DebugEventListener tabListener) {
        Intrinsics.checkParameterIsNotNull((Object)tabListener, (String)"tabListener");
        super(tabListener);
        this.commandProcessor = new WipCommandProcessor((Function1)new Function1<Request<?>, Boolean>(this){
            final /* synthetic */ WipVm this$0;

            public final boolean invoke(@NotNull Request<?> it) {
                Intrinsics.checkParameterIsNotNull(it, (String)"it");
                return this.this$0.write(it);
            }
            {
                this.this$0 = wipVm;
                super(1);
            }
        });
        this.scriptManager = new WipScriptManager(this);
        this.breakpointManager = new WipBreakpointManager(this.commandProcessor);
        this.suspendContextManager = new WipSuspendContextManager(this);
        this.networkManager = new WipNetworkManager(this.commandProcessor.getEventMap());
        this.breakOnExceptionMode = ExceptionCatchMode.NONE;
        EventMap<ProtocolResponseReader> eventMap = this.commandProcessor.getEventMap();
        eventMap.add((EventType)FrameNavigatedEventData.TYPE, (Function1)new Function1<FrameNavigatedEventData, Unit>(){

            public final void invoke(@NotNull FrameNavigatedEventData it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                FrameValue frame = it.frame();
                if (frame.getParentId() == null) {
                    frameId = frame.id();
                    this.updateUrl(frame.url(), false);
                }
            }
        });
        eventMap.add((EventType)GlobalObjectClearedEventData.TYPE, (Function1)new Function1<GlobalObjectClearedEventData, Unit>(){

            public final void invoke(@Nullable GlobalObjectClearedEventData it) {
                this.getScriptManager().clear(this.getDebugListener());
            }
        });
        eventMap.add((EventType)ScriptParsedEventData.TYPE, (Function1)new Function1<ScriptParsedEventData, Unit>(){

            public final void invoke(@NotNull ScriptParsedEventData it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                this.getScriptManager().scriptParsed(it);
            }
        });
        eventMap.add((EventType)BreakpointResolvedEventData.TYPE, (Function1)new Function1<BreakpointResolvedEventData, Unit>(){

            public final void invoke(@NotNull BreakpointResolvedEventData it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                this.getBreakpointManager().breakpointReportedResolved(it);
            }
        });
    }

    @Nullable
    public static final /* synthetic */ String access$getFrameId$p(WipVm $this) {
        return $this.frameId;
    }
}

