/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jboss.jpdl.impl;

import com.intellij.jboss.jpdl.model.JpdlDomModelManager;
import com.intellij.jboss.jpdl.model.JpdlModel;
import com.intellij.jboss.jpdl.model.JpdlModelFactory;
import com.intellij.jboss.jpdl.model.xml.ProcessDefinition;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.xml.DomManager;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class JpdlDomModelManagerImpl
extends JpdlDomModelManager {
    private final JpdlModelFactory myModelFactory;
    private final DomManager myDomManager;

    public JpdlDomModelManagerImpl(Project project, DomManager domManager) {
        this.myDomManager = domManager;
        this.myModelFactory = new JpdlModelFactory(project);
    }

    @Override
    public boolean isJpdl(@NotNull XmlFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/jboss/jpdl/impl/JpdlDomModelManagerImpl", "isJpdl"));
        }
        return this.myDomManager.getFileElement(file, ProcessDefinition.class) != null;
    }

    @Override
    public JpdlModel getJpdlModel(@NotNull XmlFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/jboss/jpdl/impl/JpdlDomModelManagerImpl", "getJpdlModel"));
        }
        return this.myModelFactory.getModelByConfigFile(file);
    }

    @Override
    public List<JpdlModel> getAllModels(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/jboss/jpdl/impl/JpdlDomModelManagerImpl", "getAllModels"));
        }
        return this.myModelFactory.getAllModels((UserDataHolder)module);
    }
}

