/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.autoconfig;

import com.intellij.database.model.DatabaseSystem;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DataSourceDetector {
    public static ExtensionPointName<DataSourceDetector> EP_NAME = ExtensionPointName.create((String)"com.intellij.database.dataSourceDetector");

    public void collectDataSources(@NotNull Project project, @NotNull Builder builder) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/autoconfig/DataSourceDetector", "collectDataSources"));
        }
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/autoconfig/DataSourceDetector", "collectDataSources"));
        }
        for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
            this.collectDataSources(module, builder, false);
        }
    }

    public void collectDataSources(@NotNull Module module, @NotNull Builder builder, boolean onTheFly) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/database/autoconfig/DataSourceDetector", "collectDataSources"));
        }
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/autoconfig/DataSourceDetector", "collectDataSources"));
        }
    }

    public boolean isRelevantFile(@NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/database/autoconfig/DataSourceDetector", "isRelevantFile"));
        }
        return false;
    }

    public static enum Property {
        NAME,
        URL,
        USERNAME,
        PASSWORD,
        DRIVER_CLASS,
        DRIVER_PATH;


        public void set(Builder b, String value) {
            switch (this) {
                case NAME: {
                    b.withName(value);
                    break;
                }
                case URL: {
                    b.withUrl(value);
                    break;
                }
                case USERNAME: {
                    b.withUser(value);
                    break;
                }
                case PASSWORD: {
                    b.withPassword(value);
                    break;
                }
                case DRIVER_CLASS: {
                    b.withDriverClass(value);
                    break;
                }
                case DRIVER_PATH: {
                    b.withDriverPath(value);
                }
            }
        }
    }

    public static abstract class Callback {
        public void onCreated(@NotNull DatabaseSystem dataSource) {
            if (dataSource == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSource", "com/intellij/database/autoconfig/DataSourceDetector$Callback", "onCreated"));
            }
        }

        public void onUpdated(@NotNull DatabaseSystem dataSource) {
            if (dataSource == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSource", "com/intellij/database/autoconfig/DataSourceDetector$Callback", "onUpdated"));
            }
        }
    }

    public static interface Builder {
        public Builder commit(@NotNull String var1, @Nullable Object var2);

        public Builder reset();

        public Builder onCreate(@NotNull Callback var1);

        public Builder withName(@Nullable String var1);

        public Builder withDriverClass(@Nullable String var1);

        public Builder withUrl(@Nullable String var1);

        public Builder withUser(@Nullable String var1);

        public Builder withPassword(@Nullable String var1);

        public Builder withDriverPath(@Nullable String var1);

        public Builder with(@NotNull Property var1, @Nullable String var2);
    }
}

