/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.util;

import com.intellij.database.model.DatabaseSystem;
import com.intellij.database.psi.DbDataSource;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.JBColor;
import com.intellij.ui.ListCellRendererWrapper;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;

public class DbUIUtil {
    private DbUIUtil() {
    }

    public static void configureDataSourceComboBox(JComboBox comboBox, Iterable<DbDataSource> dataSources, boolean allowNull) {
        ArrayList copy = ContainerUtil.newArrayList(dataSources);
        Collections.sort(copy, new Comparator<DatabaseSystem>(){

            @Override
            public int compare(DatabaseSystem o1, DatabaseSystem o2) {
                return Comparing.compare((Comparable)((Object)StringUtil.toLowerCase((String)o1.getName())), (Comparable)((Object)StringUtil.toLowerCase((String)o2.getName())));
            }
        });
        if (allowNull) {
            copy.add(0, null);
        }
        comboBox.setModel(new CollectionComboBoxModel((List)copy));
        comboBox.setRenderer(new ListCellRendererWrapper<DatabaseSystem>(){

            public void customize(JList list, DatabaseSystem element, int index, boolean selected, boolean hasFocus) {
                this.setIcon(element instanceof DbDataSource ? ((DbDataSource)element).getIcon() : null);
                String name = element == null ? "<none>" : element.getName();
                this.setText(StringUtil.notNullize((String)name));
            }
        });
        comboBox.setEditable(false);
    }

    public static void invokeLaterIfNeeded(@NotNull Runnable runnable) {
        if (runnable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/database/util/DbUIUtil", "invokeLaterIfNeeded"));
        }
        UIUtil.invokeLaterIfNeeded((Runnable)runnable);
    }

    public static void invokeLater(@NotNull Runnable runnable) {
        if (runnable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/database/util/DbUIUtil", "invokeLater"));
        }
        SwingUtilities.invokeLater(runnable);
    }

    public static Color softHighlightOf(Color c1) {
        if (c1 == null) {
            return null;
        }
        int i = 16;
        return new JBColor(new Color(Math.max(0, c1.getRed() - i), Math.max(0, c1.getGreen() - i), Math.max(0, c1.getBlue() - i)), new Color(Math.min(255, c1.getRed() + i), Math.min(255, c1.getGreen() + i), Math.min(255, c1.getBlue() + i)));
    }
}

