/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.util;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.ObjectUtils;
import gnu.trove.THashSet;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

public class ErrorHandler {
    public static final Logger LOG = Logger.getInstance((String)"com.intellij.database.util.ErrorHandler");
    private final Set<String> myMessages = new THashSet();
    private final StringBuilder myErrors = new StringBuilder();
    private boolean myTruncated;
    private int mySkippedErrors;

    public boolean addError(@Nullable String message, @Nullable Throwable ex) {
        String exMessage;
        if (ex instanceof ProcessCanceledException) {
            throw (ProcessCanceledException)ex;
        }
        if (this.myTruncated) {
            ++this.mySkippedErrors;
            return true;
        }
        if (ex != null) {
            String m = (String)ObjectUtils.chooseNotNull((Object)ex.getLocalizedMessage(), (Object)ex.getMessage());
            m = StringUtil.isNotEmpty((String)m) ? m : ex.getClass().getName();
            exMessage = m.equals(message) ? null : m;
        } else {
            exMessage = null;
        }
        if (message != null && !this.myMessages.add(message) || exMessage != null && !this.myMessages.add(exMessage)) {
            ++this.mySkippedErrors;
            return true;
        }
        if (ex != null) {
            ExceptionUtil.getUserStackTrace((Throwable)ex, (Logger)LOG);
            LOG.warn(ex);
        }
        if (message != null) {
            this.myErrors.append(message).append("\n");
        }
        if (exMessage != null) {
            this.myErrors.append(exMessage).append("\n");
        }
        if (this.myErrors.length() > 10240) {
            this.myTruncated = true;
        }
        return true;
    }

    public String getSummary() {
        if (this.mySkippedErrors > 0) {
            this.myErrors.append("and ").append(this.mySkippedErrors);
            if (this.myTruncated) {
                this.myErrors.append(" more");
            } else {
                this.myErrors.append(" duplicate reports");
            }
            this.mySkippedErrors = 0;
        }
        return this.myErrors.toString();
    }

    public void setCaption(String message) {
        this.myErrors.insert(0, message + "\n");
    }
}

