/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.psi;

import com.intellij.database.model.DataType;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.sql.psi.SqlNameElement;
import com.intellij.sql.psi.SqlType;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SqlTableType
extends SqlType {
    @Override
    public boolean isPrimitive() {
        return false;
    }

    @Nullable
    public abstract String getTypeName();

    @Nullable
    public abstract PsiElement getTypeElement();

    public abstract int getColumnCount();

    public abstract String getColumnName(int var1);

    public abstract SqlType getColumnType(int var1);

    public abstract DataType getDataType(int var1);

    @NotNull
    public abstract PsiElement getColumnElement(int var1);

    @Nullable
    public abstract PsiElement getSourceColumnElement(int var1);

    @Nullable
    public abstract PsiElement getColumnQualifier(int var1);

    @Nullable
    public abstract String getColumnTypeAlias(int var1);

    public abstract SqlTableType join(SqlTableType var1);

    public abstract SqlTableType add(SqlTableType var1);

    public abstract SqlTableType subtract(PsiElement var1);

    public abstract SqlTableType alias(String var1, PsiElement var2, List<? extends SqlNameElement> var3);

    @Override
    public String getDisplayName() {
        StringBuilder sb = new StringBuilder();
        sb.append(StringUtil.notNullize((String)this.getTypeName())).append("(");
        boolean first = true;
        int len = this.getColumnCount();
        for (int i = 0; i < len; ++i) {
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            DataType dataType = this.getDataType(i);
            SqlType type = this.getColumnType(i);
            sb.append(this.getColumnName(i));
            if (dataType != DataType.UNKNOWN) {
                sb.append(":").append(dataType.getSpecification());
                continue;
            }
            if (type == UNKNOWN) continue;
            sb.append(":").append(type.getDisplayName());
        }
        sb.append(")");
        return sb.toString();
    }
}

