/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.util;

import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.sql.psi.SqlCompositeElementType;
import com.intellij.sql.psi.impl.SqlKeywordTokenType;
import com.intellij.sql.psi.impl.SqlTokenType;
import com.intellij.util.NotNullFunction;
import com.intellij.util.NullableFunction;
import com.intellij.util.PairProcessor;
import com.intellij.util.text.CaseInsensitiveStringHashingStrategy;
import gnu.trove.THashMap;
import gnu.trove.TObjectHashingStrategy;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlTokenRegistry {
    private static final THashMap<String, SqlTokenType> ourTokensMap = SqlTokenRegistry.newTokenMap();
    private static final THashMap<Class, Pair<TokenSet, Map<String, SqlKeywordTokenType>>> ourClassTokensMap = new THashMap();
    private static final THashMap<String, IElementType> ourCompositeMap = new THashMap();

    private SqlTokenRegistry() {
    }

    @NotNull
    public static synchronized SqlTokenType getType(@NonNls @NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/sql/util/SqlTokenRegistry", "getType"));
        }
        SqlTokenType type = (SqlTokenType)((Object)ourTokensMap.get((Object)text));
        if (type == null) {
            type = Character.isLetter(text.charAt(0)) ? new SqlKeywordTokenType(text) : new SqlTokenType(text);
            ourTokensMap.put((Object)text, (Object)type);
        }
        SqlTokenType sqlTokenType = type;
        if (sqlTokenType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/util/SqlTokenRegistry", "getType"));
        }
        return sqlTokenType;
    }

    @NotNull
    public static synchronized SqlTokenType getType(@NonNls @NotNull String text, NotNullFunction<String, ? extends SqlTokenType> factory) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/sql/util/SqlTokenRegistry", "getType"));
        }
        SqlTokenType type = (SqlTokenType)((Object)ourTokensMap.get((Object)text));
        if (type == null) {
            type = (SqlTokenType)((Object)factory.fun((Object)text));
            ourTokensMap.put((Object)text, (Object)type);
        }
        SqlTokenType sqlTokenType = type;
        if (sqlTokenType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/util/SqlTokenRegistry", "getType"));
        }
        return sqlTokenType;
    }

    @NotNull
    public static synchronized SqlCompositeElementType getCompositeType(@NonNls @NotNull String debugName) {
        if (debugName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debugName", "com/intellij/sql/util/SqlTokenRegistry", "getCompositeType"));
        }
        SqlCompositeElementType type = (SqlCompositeElementType)((Object)ourCompositeMap.get((Object)debugName));
        if (type == null) {
            type = new SqlCompositeElementType(debugName);
            ourCompositeMap.put((Object)debugName, (Object)type);
        }
        SqlCompositeElementType sqlCompositeElementType = type;
        if (sqlCompositeElementType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/util/SqlTokenRegistry", "getCompositeType"));
        }
        return sqlCompositeElementType;
    }

    @NotNull
    public static synchronized <T extends IElementType> T getCompositeType(@NonNls @NotNull String debugName, NotNullFunction<String, T> factory) {
        if (debugName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debugName", "com/intellij/sql/util/SqlTokenRegistry", "getCompositeType"));
        }
        IElementType type = (IElementType)ourCompositeMap.get((Object)debugName);
        if (type == null) {
            type = (IElementType)factory.fun((Object)debugName);
            ourCompositeMap.put((Object)debugName, (Object)type);
        }
        IElementType iElementType = type;
        if (iElementType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/util/SqlTokenRegistry", "getCompositeType"));
        }
        return (T)iElementType;
    }

    @Nullable
    public static synchronized SqlTokenType findTokenType(@NonNls @NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/sql/util/SqlTokenRegistry", "findTokenType"));
        }
        return (SqlTokenType)((Object)ourTokensMap.get((Object)text));
    }

    @Nullable
    public static synchronized IElementType findCompositeType(@NonNls @NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/sql/util/SqlTokenRegistry", "findCompositeType"));
        }
        return (IElementType)ourCompositeMap.get((Object)text);
    }

    @Nullable
    public static synchronized IElementType findType(@NonNls @NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/sql/util/SqlTokenRegistry", "findType"));
        }
        SqlTokenType token = (SqlTokenType)((Object)ourTokensMap.get((Object)text));
        if (token != null) {
            return token;
        }
        return (IElementType)ourCompositeMap.get((Object)text);
    }

    /*
     * Exception decompiling
     */
    public static void initTypeMap(Class clazz, @Nullable Set<String> exclude) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.NullPointerException: Cannot invoke "org.benf.cfr.reader.bytecode.analysis.types.BindingSuperContainer.getBoundAssignable(org.benf.cfr.reader.bytecode.analysis.types.JavaGenericRefTypeInstance, org.benf.cfr.reader.bytecode.analysis.types.JavaGenericRefTypeInstance)" because "maybeBindingContainer" is null
         *     at org.benf.cfr.reader.bytecode.analysis.types.GenericTypeBinder.extractBaseBindings(GenericTypeBinder.java:125)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter$InnerExplicitTypeCallRewriter.rewriteFunctionInvokation(ExplicitTypeCallRewriter.java:37)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter$InnerExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:56)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.applyExpressionRewriterToArgs(StaticFunctionInvokation.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:71)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.statement.AssignmentSimple.rewriteExpressions(AssignmentSimple.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.rewrite(Op03SimpleStatement.java:479)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.Op03Rewriters.rewriteWith(Op03Rewriters.java:23)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:819)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static synchronized void addTypeMap(Class clazz, Set<String> keywordSet) {
        Pair tokenSetMapPair = (Pair)ourClassTokensMap.get((Object)clazz);
        THashMap map = tokenSetMapPair == null ? SqlTokenRegistry.newTokenMap() : (Map)tokenSetMapPair.getSecond();
        for (String s : keywordSet) {
            if (map.containsKey(s)) continue;
            String upperCase = StringUtil.toUpperCase((String)s);
            map.put(upperCase, (Object)((Object)((SqlKeywordTokenType)SqlTokenRegistry.getType(upperCase))));
        }
        SqlTokenRegistry.setTypeMap(clazz, map, true);
    }

    private static synchronized void setTypeMap(Class clazz, Map<String, SqlKeywordTokenType> map, boolean force) {
        if (!force && ourClassTokensMap.containsKey((Object)clazz)) {
            return;
        }
        ourClassTokensMap.put((Object)clazz, (Object)Pair.create((Object)TokenSet.create((IElementType[])map.values().toArray(new IElementType[map.size()])), map));
    }

    @NotNull
    public static NullableFunction<String, IElementType> getTokenProvider(@NotNull Class clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "com/intellij/sql/util/SqlTokenRegistry", "getTokenProvider"));
        }
        final Map map = (Map)SqlTokenRegistry.getSafeMap(clazz).getSecond();
        NullableFunction<String, IElementType> nullableFunction = new NullableFunction<String, IElementType>(){

            public IElementType fun(String s) {
                return (IElementType)map.get(s);
            }
        };
        if (nullableFunction == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/util/SqlTokenRegistry", "getTokenProvider"));
        }
        return nullableFunction;
    }

    @NotNull
    public static TokenSet getTokenSet(@NotNull Class clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "com/intellij/sql/util/SqlTokenRegistry", "getTokenSet"));
        }
        TokenSet tokenSet = (TokenSet)SqlTokenRegistry.getSafeMap(clazz).getFirst();
        if (tokenSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/util/SqlTokenRegistry", "getTokenSet"));
        }
        return tokenSet;
    }

    public static Set<String> getTokens(Class clazz) {
        return Collections.unmodifiableSet(((Map)SqlTokenRegistry.getSafeMap(clazz).getSecond()).keySet());
    }

    @NotNull
    private static synchronized Pair<TokenSet, Map<String, SqlKeywordTokenType>> getSafeMap(Class clazz) {
        Pair result = (Pair)ourClassTokensMap.get((Object)clazz);
        assert (result != null) : clazz + " token map not initialized";
        Pair pair = result;
        if (pair == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/util/SqlTokenRegistry", "getSafeMap"));
        }
        return pair;
    }

    private static <T extends IElementType> THashMap<String, T> newTokenMap() {
        return new THashMap((TObjectHashingStrategy)CaseInsensitiveStringHashingStrategy.INSTANCE);
    }

    private static Map<String, SqlKeywordTokenType> buildTokenMap(Class clazz, final Map<String, SqlKeywordTokenType> map) {
        SqlTokenRegistry.processStaticFields(clazz, new PairProcessor<Field, Object>(){

            public boolean process(Field field, Object value) {
                if (value instanceof SqlKeywordTokenType) {
                    SqlKeywordTokenType tokenType = (SqlKeywordTokenType)((Object)value);
                    map.put(tokenType.toString(), tokenType);
                }
                return true;
            }
        });
        return map;
    }

    public static boolean processStaticFields(Class clazz, PairProcessor<Field, Object> processor) {
        for (Field field : clazz.getFields()) {
            try {
                Object value = field.get(null);
                if (processor.process((Object)field, value)) continue;
                return false;
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        return true;
    }
}

